/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.core.optimizer;

import com.tencent.angel.RunningMode;
import com.tencent.angel.ml.core.conf.MLConf$;
import com.tencent.angel.ml.core.conf.SharedConf;
import com.tencent.angel.ml.core.conf.SharedConf$;
import com.tencent.angel.ml.core.network.layers.AngelGraph;
import com.tencent.angel.ml.core.optimizer.AdaDelta;
import com.tencent.angel.ml.core.optimizer.AdaGrad;
import com.tencent.angel.ml.core.optimizer.Adam;
import com.tencent.angel.ml.core.optimizer.FTRL;
import com.tencent.angel.ml.core.optimizer.Momentum;
import com.tencent.angel.ml.core.optimizer.Optimizer;
import com.tencent.angel.ml.core.optimizer.SGD;
import scala.MatchError;

public final class OptUtils$ {
    public static final OptUtils$ MODULE$;

    static {
        new OptUtils$();
    }

    public int getSlotNum(Optimizer optimizer) {
        return optimizer.getNumSlot();
    }

    public int getSlotNum(String optimizer) {
        String string = optimizer.toLowerCase();
        int n = "sgd".equals(string) ? 1 : ("momentum".equals(string) ? 2 : ("adam".equals(string) ? 3 : ("ftrl".equals(string) ? 3 : ("adagrad".equals(string) ? 2 : ("adadelta".equals(string) ? 3 : 1)))));
        return n;
    }

    public Optimizer getOptimizer(String name) {
        Optimizer optimizer;
        SharedConf conf = SharedConf$.MODULE$.get();
        double lr0 = conf.getDouble(MLConf$.MODULE$.ML_LEARN_RATE(), 1.0);
        String string = name.toLowerCase().trim();
        if ("momentum".equals(string)) {
            double momentum = conf.getDouble(MLConf$.MODULE$.ML_OPT_MOMENTUM_MOMENTUM(), MLConf$.MODULE$.DEFAULT_ML_OPT_MOMENTUM_MOMENTUM());
            optimizer = new Momentum(lr0, momentum);
        } else if ("adam".equals(string)) {
            double gamma = conf.getDouble(MLConf$.MODULE$.ML_OPT_ADAM_GAMMA(), MLConf$.MODULE$.DEFAULT_ML_OPT_ADAM_GAMMA());
            double beta = conf.getDouble(MLConf$.MODULE$.ML_OPT_ADAM_BETA(), MLConf$.MODULE$.DEFAULT_ML_OPT_ADAM_BETA());
            optimizer = new Adam(lr0, gamma, beta);
        } else if ("ftrl".equals(string)) {
            double alpha = conf.getDouble(MLConf$.MODULE$.ML_OPT_FTRL_ALPHA(), MLConf$.MODULE$.DEFAULT_ML_OPT_FTRL_ALPHA());
            double beta = conf.getDouble(MLConf$.MODULE$.ML_OPT_FTRL_BETA(), MLConf$.MODULE$.DEFAULT_ML_OPT_FTRL_BETA());
            optimizer = new FTRL(lr0, alpha, beta);
        } else if ("adagrad".equals(string)) {
            double beta = conf.getDouble(MLConf$.MODULE$.ML_OPT_ADAGRAD_BETA(), MLConf$.MODULE$.DEFAULT_ML_OPT_ADAGRAD_BETA());
            optimizer = new AdaGrad(lr0, beta);
        } else if ("adadelta".equals(string)) {
            double alpha = conf.getDouble(MLConf$.MODULE$.ML_OPT_ADADELTA_ALPHA(), MLConf$.MODULE$.DEFAULT_ML_OPT_ADADELTA_ALPHA());
            double beta = conf.getDouble(MLConf$.MODULE$.ML_OPT_ADADELTA_BETA(), MLConf$.MODULE$.DEFAULT_ML_OPT_ADADELTA_BETA());
            optimizer = new AdaDelta(lr0, alpha, beta);
        } else {
            optimizer = new SGD(lr0);
        }
        return optimizer;
    }

    public double getNormal(RunningMode mode, AngelGraph graph) {
        RunningMode runningMode;
        block5: {
            double d;
            block3: {
                block4: {
                    block2: {
                        runningMode = mode;
                        if (!RunningMode.ANGEL_PS.equals(runningMode)) break block2;
                        d = 1.0;
                        break block3;
                    }
                    if (!RunningMode.ANGEL_PS_WORKER.equals(runningMode)) break block4;
                    d = graph.placeHolder().getBatchSize() * graph.taskNum();
                    break block3;
                }
                if (!RunningMode.ANGEL_LOCAL.equals(runningMode)) break block5;
                d = graph.placeHolder().getBatchSize();
            }
            return d;
        }
        throw new MatchError((Object)runningMode);
    }

    private OptUtils$() {
        MODULE$ = this;
    }
}

