/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.core.utils;

import java.util.List;
import java.util.Random;

public class Maths {
    public static float sigmoid(float x) {
        return (float)(1.0 / (1.0 + Math.exp(-x)));
    }

    public static double sigmoid(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }

    public static int sqr(int x) {
        return x * x;
    }

    public static float sqr(float x) {
        return x * x;
    }

    public static double sqr(double x) {
        return x * x;
    }

    public static void softmax(double[] rec) {
        int i;
        double wmax = rec[0];
        for (int i2 = 1; i2 < rec.length; ++i2) {
            wmax = Math.max(rec[i2], wmax);
        }
        double wsum = 0.0;
        for (i = 0; i < rec.length; ++i) {
            rec[i] = Math.exp(rec[i] - wmax);
            wsum += rec[i];
        }
        i = 0;
        while (i < rec.length) {
            int n = i++;
            rec[n] = rec[n] / wsum;
        }
    }

    public static void softmax(float[] rec) {
        int i;
        float wmax = rec[0];
        for (int i2 = 1; i2 < rec.length; ++i2) {
            wmax = Math.max(rec[i2], wmax);
        }
        float wsum = 0.0f;
        for (i = 0; i < rec.length; ++i) {
            rec[i] = (float)Math.exp(rec[i] - wmax);
            wsum += rec[i];
        }
        i = 0;
        while (i < rec.length) {
            int n = i++;
            rec[n] = rec[n] / wsum;
        }
    }

    public static double thresholdL1(double w, double lambda) {
        if (w > lambda) {
            return w - lambda;
        }
        if (w < -lambda) {
            return w + lambda;
        }
        return 0.0;
    }

    public static float thresholdL1(float w, float lambda) {
        if (w > lambda) {
            return w - lambda;
        }
        if (w < -lambda) {
            return w + lambda;
        }
        return 0.0f;
    }

    public static boolean isEven(int v) {
        return v % 2 == 0;
    }

    public static int pow(int a, int b) {
        if (b == 0) {
            return 1;
        }
        if (b == 1) {
            return a;
        }
        if (Maths.isEven(b)) {
            return Maths.pow(a * a, b / 2);
        }
        return a * Maths.pow(a * a, b / 2);
    }

    public static void shuffle(int[] array) {
        Random random = new Random();
        for (int i = array.length - 1; i > 0; --i) {
            int index = random.nextInt(i + 1);
            int temp = array[index];
            array[index] = array[i];
            array[i] = temp;
        }
    }

    public static int[] intList2Arr(List<Integer> integers) {
        int[] ret = new int[integers.size()];
        for (int i = 0; i < integers.size(); ++i) {
            ret[i] = integers.get(i);
        }
        return ret;
    }

    public static float[] floatList2Arr(List<Float> floats) {
        float[] ret = new float[floats.size()];
        for (int i = 0; i < floats.size(); ++i) {
            ret[i] = floats.get(i).floatValue();
        }
        return ret;
    }

    public static long[] longList2Arr(List<Long> longs) {
        long[] ret = new long[longs.size()];
        for (int i = 0; i < longs.size(); ++i) {
            ret[i] = longs.get(i);
        }
        return ret;
    }

    public static int[] list2Arr(List<Integer> nzzIdxes) {
        return null;
    }

    public static int findMaxIndex(float[] floats) {
        int rec = 0;
        float max = floats[rec];
        for (int i = 1; i < floats.length; ++i) {
            if (!(floats[i] > max)) continue;
            rec = i;
            max = floats[i];
        }
        return rec;
    }

    public static float[] double2Float(double[] doubles) {
        float[] ret = new float[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            ret[i] = (float)doubles[i];
        }
        return ret;
    }
}

