/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.lda;

import com.tencent.angel.ml.lda.LDALearner;
import com.tencent.angel.ml.lda.LDAModel;
import com.tencent.angel.ml.lda.algo.CSRTokens;
import com.tencent.angel.ml.lda.algo.Document;
import com.tencent.angel.ml.math2.VFactory;
import com.tencent.angel.ml.math2.vector.IntIntVector;
import com.tencent.angel.ml.math2.vector.Vector;
import com.tencent.angel.worker.storage.DataBlock;
import com.tencent.angel.worker.storage.MemoryDataBlock;
import com.tencent.angel.worker.storage.Reader;
import com.tencent.angel.worker.task.BaseTask;
import com.tencent.angel.worker.task.TaskContext;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\u0001\u0003\u00015\u0011A\u0002\u0014#B)J\f\u0017N\u001c+bg.T!a\u0001\u0003\u0002\u00071$\u0017M\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQ!\u00198hK2T!!\u0003\u0006\u0002\u000fQ,gnY3oi*\t1\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001\u001dA)q\u0002\u0006\f#K5\t\u0001C\u0003\u0002\u0012%\u0005!A/Y:l\u0015\t\u0019b!\u0001\u0004x_J\\WM]\u0005\u0003+A\u0011\u0001BQ1tKR\u000b7o\u001b\t\u0003/\u0001j\u0011\u0001\u0007\u0006\u00033i\t!![8\u000b\u0005ma\u0012A\u00025bI>|\u0007O\u0003\u0002\u001e=\u00051\u0011\r]1dQ\u0016T\u0011aH\u0001\u0004_J<\u0017BA\u0011\u0019\u00051auN\\4Xe&$\u0018M\u00197f!\t92%\u0003\u0002%1\t!A+\u001a=u!\t1\u0013&D\u0001(\u0015\tA#!\u0001\u0003bY\u001e|\u0017B\u0001\u0016(\u0005!!unY;nK:$\b\u0002\u0003\u0017\u0001\u0005\u000b\u0007I\u0011A\u0017\u0002\u0007\r$\b0F\u0001/!\tyq&\u0003\u00021!\tYA+Y:l\u0007>tG/\u001a=u\u0011!\u0011\u0004A!A!\u0002\u0013q\u0013\u0001B2uq\u0002BQ\u0001\u000e\u0001\u0005\u0002U\na\u0001P5oSRtDC\u0001\u001c9!\t9\u0004!D\u0001\u0003\u0011\u0015a3\u00071\u0001/\u0011\u001dQ\u0004A1A\u0005\nm\n1\u0001T(H+\u0005a\u0004CA\u001fC\u001b\u0005q$BA A\u0003\u001dawnZ4j]\u001eT!!\u0011\u000f\u0002\u000f\r|W.\\8og&\u00111I\u0010\u0002\u0004\u0019><\u0007BB#\u0001A\u0003%A(\u0001\u0003M\u001f\u001e\u0003\u0003bB$\u0001\u0001\u0004%\t\u0001S\u0001\u0005I>\u001c7/F\u0001J!\rQU*J\u0007\u0002\u0017*\u0011AJE\u0001\bgR|'/Y4f\u0013\tq5JA\bNK6|'/\u001f#bi\u0006\u0014En\\2l\u0011\u001d\u0001\u0006\u00011A\u0005\u0002E\u000b\u0001\u0002Z8dg~#S-\u001d\u000b\u0003%b\u0003\"a\u0015,\u000e\u0003QS\u0011!V\u0001\u0006g\u000e\fG.Y\u0005\u0003/R\u0013A!\u00168ji\"9\u0011lTA\u0001\u0002\u0004I\u0015a\u0001=%c!11\f\u0001Q!\n%\u000bQ\u0001Z8dg\u0002Bq!\u0018\u0001A\u0002\u0013\u0005a,A\u0001O+\u0005y\u0006CA*a\u0013\t\tGKA\u0002J]RDqa\u0019\u0001A\u0002\u0013\u0005A-A\u0003O?\u0012*\u0017\u000f\u0006\u0002SK\"9\u0011LYA\u0001\u0002\u0004y\u0006BB4\u0001A\u0003&q,\u0001\u0002OA!9\u0011\u000e\u0001a\u0001\n\u0003q\u0016a\u00013jI\"91\u000e\u0001a\u0001\n\u0003a\u0017a\u00023jI~#S-\u001d\u000b\u0003%6Dq!\u00176\u0002\u0002\u0003\u0007q\f\u0003\u0004p\u0001\u0001\u0006KaX\u0001\u0005I&$\u0007\u0005C\u0003r\u0001\u0011\u0005#/A\u0003qCJ\u001cX\rF\u0002&gVDQ\u0001\u001e9A\u0002Y\t1a[3z\u0011\u00151\b\u000f1\u0001#\u0003\u00151\u0018\r\\;f\u0011\u0015A\b\u0001\"\u0011z\u0003)\u0001(/\u001a)s_\u000e,7o\u001d\u000b\u0003%jDQ\u0001L<A\u00029BQ\u0001 \u0001\u0005\u0002u\fQcY1mGV\fG/\u001a,pG\u0006\u0014W\u000f\\1ss:+X\u000e\u0006\u0002`}\"1qp\u001fa\u0001\u0003\u0003\tQ!\\8eK2\u00042aNA\u0002\u0013\r\t)A\u0001\u0002\t\u0019\u0012\u000bUj\u001c3fY\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0011a\u0001:v]R\u0019!+!\u0004\t\r1\n9\u00011\u0001/Q\u0019\t9!!\u0005\u00020A)1+a\u0005\u0002\u0018%\u0019\u0011Q\u0003+\u0003\rQD'o\\<t!\u0011\tI\"!\u000b\u000f\t\u0005m\u0011Q\u0005\b\u0005\u0003;\t\u0019#\u0004\u0002\u0002 )\u0019\u0011\u0011\u0005\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0016bAA\u0014)\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u0016\u0003[\u0011\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005\u001dB+M\u0004\u001f\u0003c\ty$a\u001b\u0011\t\u0005M\u0012\u0011\b\b\u0004'\u0006U\u0012bAA\u001c)\u00061\u0001K]3eK\u001aLA!a\u000f\u0002>\t11\u000b\u001e:j]\u001eT1!a\u000eUc%\u0019\u0013\u0011IA%\u0003C\nY%\u0006\u0003\u0002D\u0005\u0015SCAA\u0019\t\u001d\t9\u0005\u0004b\u0001\u0003#\u0012\u0011\u0001V\u0005\u0005\u0003\u0017\ni%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0004\u0003\u001f\"\u0016A\u0002;ie><8/\u0005\u0003\u0002T\u0005e\u0003cA*\u0002V%\u0019\u0011q\u000b+\u0003\u000f9{G\u000f[5oOB!\u00111LA/\u001d\r\u0019\u0016QE\u0005\u0005\u0003?\niCA\u0005UQJ|w/\u00192mKFJ1%a\u0019\u0002f\u0005\u001d\u0014q\n\b\u0004'\u0006\u0015\u0014bAA()F*!e\u0015+\u0002j\t)1oY1mCF\u001aa%a\u0006")
public class LDATrainTask
extends BaseTask<LongWritable, Text, Document> {
    private final TaskContext ctx;
    private final Log LOG;
    private MemoryDataBlock<Document> docs;
    private int N;
    private int did;

    public TaskContext ctx() {
        return this.ctx;
    }

    private Log LOG() {
        return this.LOG;
    }

    public MemoryDataBlock<Document> docs() {
        return this.docs;
    }

    public void docs_$eq(MemoryDataBlock<Document> x$1) {
        this.docs = x$1;
    }

    public int N() {
        return this.N;
    }

    public void N_$eq(int x$1) {
        this.N = x$1;
    }

    public int did() {
        return this.did;
    }

    public void did_$eq(int x$1) {
        this.did = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public Document parse(LongWritable key, Text value) {
        void var3_3;
        Document doc = new Document(value.toString());
        if (doc != null) {
            this.did_$eq(this.did() + 1);
            this.N_$eq(this.N() + doc.len());
        }
        return var3_3;
    }

    public void preProcess(TaskContext ctx) {
        Reader reader = ctx.getReader();
        while (reader.nextKeyValue()) {
            this.docs().put((Object)this.parse((LongWritable)reader.getCurrentKey(), (Text)reader.getCurrentValue()));
        }
    }

    public int calcuateVocabularyNum(LDAModel model) {
        Iterator iter = this.docs().getvList().iterator();
        int maxVocabularyId = -1;
        while (iter.hasNext()) {
            Document doc = (Document)iter.next();
            maxVocabularyId = Math.max(maxVocabularyId, BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(doc.wids).max((Ordering)Ordering.Int$.MODULE$)));
        }
        int taskId = this.ctx().getTaskIndex();
        int taskNum = this.ctx().getTotalTaskNum();
        IntIntVector update2 = VFactory.sparseIntVector((int)taskNum);
        update2.set(taskId, maxVocabularyId);
        model.vocabularyMatrix().increment(0, (Vector)update2);
        model.vocabularyMatrix().clock(model.vocabularyMatrix().clock$default$1());
        int[] values = ((IntIntVector)model.vocabularyMatrix().getRow(0)).getStorage().getValues();
        return BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(values).max((Ordering)Ordering.Int$.MODULE$)) + 1;
    }

    public void run(TaskContext ctx) throws Exception {
        LDAModel model = new LDAModel(ctx.getConf(), ctx);
        int numVocabulary = this.calcuateVocabularyNum(model);
        this.LOG().info((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"V=", " K=", " alpha=", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)model.V()), BoxesRunTime.boxToInteger((int)model.K()), BoxesRunTime.boxToFloat((float)model.alpha())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"beta=", " M=", " tokens=", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)model.beta()), BoxesRunTime.boxToInteger((int)this.docs().size()), BoxesRunTime.boxToInteger((int)this.N())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"threadNum=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)model.threadNum())}))).toString());
        this.LOG().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"V=", " real V=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)model.V()), BoxesRunTime.boxToInteger((int)numVocabulary)})));
        model.V_$eq(numVocabulary);
        model.vBeta_$eq(model.beta() * (float)model.V());
        int taskId = ctx.getTaskIndex();
        model.wtMat().matrixCtx().setRowNum(numVocabulary);
        model.wtMat().matrixCtx().setMaxRowNumInBlock(model.blockNum(numVocabulary, model.K()));
        model.wtMat().matrixCtx().setMaxColNumInBlock((long)model.K());
        Object object = taskId == 0 ? ctx.createMatrix(model.wtMat().matrixCtx(), 10000L) : BoxedUnit.UNIT;
        CSRTokens tokens = new CSRTokens(model.V(), this.docs().size());
        tokens.build((DataBlock<Document>)this.docs(), model.K());
        this.docs().clean();
        this.LOG().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"build data"})).s((Seq)Nil$.MODULE$));
        model.tMat().clock(false).get();
        model.tMat().getRow(0);
        LDALearner learner = new LDALearner(ctx, model, tokens);
        learner.initialize();
        learner.train(model.epoch());
        if (model.saveWordTopic()) {
            learner.saveWordTopic(model);
        }
        if (model.saveDocTopic()) {
            learner.saveDocTopic(this.conf.get("angel.save.model.path"), tokens, model);
        }
        if (model.saveDocTopicDistribution()) {
            learner.saveDocTopicDistribution(this.conf.get("angel.save.model.path"), tokens, model);
        }
        if (model.saveTopicWordDistribution()) {
            learner.saveWordTopicDistribution(model);
        }
    }

    public LDATrainTask(TaskContext ctx) {
        this.ctx = ctx;
        super(ctx);
        this.LOG = LogFactory.getLog(LDATrainTask.class);
        this.docs = new MemoryDataBlock(-1);
        this.N = 0;
        this.did = 0;
    }
}

