/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.lda.algo;

import com.tencent.angel.ml.lda.algo.Document;
import com.tencent.angel.ml.lda.algo.structures.I2ITranverseMap;
import com.tencent.angel.worker.storage.DataBlock;
import java.io.IOException;

public class CSRTokens {
    public int n_words;
    public int n_docs;
    public int n_tokens;
    public int[] ws;
    public int[] ds;
    public int[] docs;
    public int[] topics;
    public int[] dindex;
    public I2ITranverseMap[] dks;
    public int[] docLens;
    public String[] docIds;
    public int maxDocLen;

    public CSRTokens(int n_words, int n_docs) {
        this.n_words = n_words;
        this.n_docs = n_docs;
    }

    public CSRTokens build(DataBlock<Document> docs, int K) throws IOException {
        int pos;
        int wid;
        int w;
        Document doc;
        int d;
        int[] wcnt = new int[this.n_words];
        this.ws = new int[this.n_words + 1];
        this.docLens = new int[this.n_docs];
        this.docIds = new String[this.n_docs];
        this.ds = new int[this.n_docs + 1];
        this.n_tokens = 0;
        this.maxDocLen = 1;
        this.ds[0] = 0;
        for (d = 0; d < this.n_docs; ++d) {
            doc = (Document)docs.get(d);
            for (w = 0; w < doc.len; ++w) {
                int n = doc.wids[w];
                wcnt[n] = wcnt[n] + 1;
            }
            this.ds[d + 1] = this.ds[d] + doc.len;
            this.n_tokens += doc.len;
            this.docLens[d] = doc.len;
            this.docIds[d] = doc.docId;
            this.maxDocLen = Math.max(this.maxDocLen, doc.len);
        }
        this.docs = new int[this.n_tokens];
        this.topics = new int[this.n_tokens];
        this.dindex = new int[this.n_tokens];
        this.ws[0] = 0;
        for (int i = 0; i < this.n_words; ++i) {
            this.ws[i + 1] = this.ws[i] + wcnt[i];
        }
        for (d = this.n_docs - 1; d >= 0; --d) {
            doc = (Document)docs.get(d);
            for (w = 0; w < doc.len; ++w) {
                int n = wid = doc.wids[w];
                int n2 = wcnt[n] - 1;
                wcnt[n] = n2;
                pos = this.ws[wid] + n2;
                this.docs[pos] = d;
            }
        }
        for (int w2 = 0; w2 < this.n_words; ++w2) {
            wcnt[w2] = this.ws[w2 + 1] - this.ws[w2];
        }
        this.dindex = new int[this.n_tokens];
        for (d = this.n_docs - 1; d >= 0; --d) {
            doc = (Document)docs.get(d);
            for (w = 0; w < doc.wids.length; ++w) {
                wid = doc.wids[w];
                pos = this.ds[d] + w;
                int n = wid;
                int n3 = wcnt[n] - 1;
                wcnt[n] = n3;
                this.dindex[this.ws[wid] + n3] = pos;
            }
        }
        this.dks = new I2ITranverseMap[this.n_docs];
        for (d = 0; d < this.n_docs; ++d) {
            if (((Document)docs.get((int)d)).len <= K) continue;
            this.dks[d] = new I2ITranverseMap(Math.min(K, ((Document)docs.get((int)d)).len));
        }
        return this;
    }
}

