/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.lda.algo.structures;

public class FTree {
    public float[] tree;
    int length;
    int K;

    public FTree(int length) {
        int len = FTree.nextPowerOfTwo(length);
        this.tree = new float[2 * len];
        this.length = len;
        this.K = length;
    }

    public FTree(float[] p, int length) {
        this(length);
        this.build(p);
    }

    public void build(float[] p) {
        int start;
        for (int i = start = Math.min(2 * this.length - 1, this.length + p.length - 1); i > 0; --i) {
            this.tree[i] = i >= this.length ? p[i - this.length] : this.tree[i << 1] + this.tree[(i << 1) + 1];
        }
    }

    public void set(int i, float val) {
        this.tree[i + this.length] = val;
    }

    public void build() {
        for (int i = this.length - 1; i > 0; --i) {
            this.tree[i] = this.tree[i << 1] + this.tree[(i << 1) + 1];
        }
    }

    public void update(int index, float value) {
        int i;
        float delta = value - this.tree[i];
        for (i = index + this.length; i > 0; i >>= 1) {
            int n = i;
            this.tree[n] = this.tree[n] + delta;
        }
    }

    public int sample(float u) {
        int i = 1;
        while (i < this.length) {
            if (u < this.tree[i << 1]) {
                i <<= 1;
                continue;
            }
            u -= this.tree[i << 1];
            i = i * 2 + 1;
        }
        return Math.min(i - this.length, this.K - 1);
    }

    public static int nextPowerOfTwo(int x) {
        if (x == 0) {
            return 1;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        return (x | x >> 16) + 1;
    }

    public float first() {
        return this.tree[1];
    }

    public float get(int index) {
        return this.tree[index + this.length];
    }
}

