/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.lda.algo.structures;

import com.tencent.angel.ml.lda.algo.structures.IntTraverseHashMap;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;

public class I2ITranverseMap
extends IntTraverseHashMap {
    public int[] value;
    boolean[] used;
    public int[] idx;
    int[] poss;

    public I2ITranverseMap(int expected) {
        super(expected);
        this.value = new int[this.n];
        this.used = new boolean[this.n];
        this.idx = new int[this.n];
        this.poss = new int[this.n];
    }

    @Override
    public short get(short k) {
        return -1;
    }

    @Override
    public short get(int k) {
        int pos = HashCommon.murmurHash3((int)k) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return (short)this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return 0;
    }

    @Override
    public void put(short k, short v) {
        this.put((int)k, (int)v);
    }

    @Override
    public void put(int k, int v) {
        if (v == 0) {
            return;
        }
        int pos = HashCommon.murmurHash3((int)k) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                this.value[pos] = v;
                return;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        this.idx[this.size] = pos;
        this.poss[pos] = this.size++;
    }

    @Override
    public void rehash() {
        int[] kkey = this.key;
        int[] vvalue = this.value;
        this.key = new int[this.n];
        this.value = new int[this.n];
        Arrays.fill(this.used, false);
        int temp = this.size;
        this.size = 0;
        for (int i = 0; i < temp; ++i) {
            int k = kkey[this.idx[i]];
            int v = vvalue[this.idx[i]];
            this.put(k, v);
        }
    }

    @Override
    public short dec(short k) {
        return this.dec((int)k);
    }

    @Override
    public short dec(int k) {
        int pos = HashCommon.murmurHash3((int)k) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                int n = pos;
                this.value[n] = this.value[n] - 1;
                if (this.value[pos] == 0) {
                    --this.size;
                    this.idx[this.poss[pos]] = this.idx[this.size];
                    this.poss[this.idx[this.size]] = this.poss[pos];
                }
                return (short)this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return 0;
    }

    @Override
    public short inc(int k) {
        int pos = HashCommon.murmurHash3((int)k) & this.mask;
        int cnt = 0;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                int n = pos;
                this.value[n] = this.value[n] + 1;
                if (this.value[pos] == 1) {
                    this.idx[this.size] = pos;
                    this.poss[pos] = this.size++;
                }
                return (short)this.value[pos];
            }
            if (++cnt > this.n) {
                this.rehash();
                return this.inc(k);
            }
            pos = pos + 1 & this.mask;
        }
        this.key[pos] = k;
        this.value[pos] = 1;
        this.used[pos] = true;
        this.idx[this.size] = pos;
        this.poss[pos] = this.size++;
        return 1;
    }

    @Override
    public short inc(short k) {
        return this.inc((int)k);
    }

    @Override
    public int bytes() {
        int sum = 0;
        sum += this.key.length * 4;
        sum += this.value.length * 4;
        sum += this.used.length;
        sum += this.idx.length * 4;
        return sum += this.poss.length * 4;
    }

    @Override
    public int getIntKey(int idx) {
        return this.key[this.idx[idx]];
    }

    @Override
    public int getVal(int idx) {
        return this.value[this.idx[idx]];
    }

    @Override
    public short getKey(int idx) {
        return (short)this.key[this.idx[idx]];
    }
}

