/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.lda.algo.structures;

import com.tencent.angel.ml.lda.algo.structures.ShortTraverseHashMap;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;

public class S2BTightTraverseMap
extends ShortTraverseHashMap {
    public byte[] values;

    public S2BTightTraverseMap(byte expected) {
        super(expected);
        this.values = new byte[this.n * 3];
    }

    public S2BTightTraverseMap(int expected) {
        this((byte)expected);
    }

    @Override
    public short get(short k) {
        int pos = HashCommon.murmurHash3((int)k) & this.mask;
        short cnt = 0;
        while (this.used(pos)) {
            if (this.key[pos] == k) {
                return this.values[pos];
            }
            pos = pos + 1 & this.mask;
            if (++cnt <= this.n) continue;
            this.rehash();
            return this.get(k);
        }
        return 0;
    }

    @Override
    public short get(int k) {
        return this.get((short)k);
    }

    @Override
    public void put(short k, short v) {
        this.put(k, (byte)v);
    }

    @Override
    public void put(int k, int v) {
        this.put((short)k, (byte)v);
    }

    public void put(short k, byte v) {
        if (v == 0) {
            return;
        }
        int pos = HashCommon.murmurHash3((int)k) & this.mask;
        while (this.used(pos)) {
            if (this.key[pos] == k) {
                this.values[pos] = v;
                return;
            }
            pos = pos + 1 & this.mask;
        }
        this.key[pos] = k;
        this.values[pos] = v;
        this.values[this.idx((int)this.size)] = (byte)pos;
        this.values[this.poss((int)pos)] = (byte)this.size;
        this.size = (short)(this.size + 1);
    }

    @Override
    public void rehash() {
        short[] kkey = this.key;
        byte[] vvalue = this.values;
        this.key = new short[this.n];
        this.values = new byte[this.n * 3];
        Arrays.fill(this.key, (short)-1);
        int temp = this.size;
        this.size = 0;
        for (int i = 0; i < temp; ++i) {
            short k = kkey[vvalue[this.idx(i)]];
            byte v = vvalue[vvalue[this.idx(i)]];
            this.put(k, v);
        }
    }

    @Override
    public short dec(short k) {
        int pos = HashCommon.murmurHash3((int)k) & this.mask;
        while (this.used(pos)) {
            if (this.key[pos] == k) {
                int n = pos;
                this.values[n] = (byte)(this.values[n] - 1);
                if (this.values[pos] == 0) {
                    this.size = (short)(this.size - 1);
                    this.values[this.idx((int)this.values[this.poss((int)pos)])] = this.values[this.idx(this.size)];
                    this.values[this.poss((int)this.values[this.idx((int)this.size)])] = this.values[this.poss(pos)];
                }
                return this.values[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return 0;
    }

    @Override
    public short dec(int k) {
        return this.dec((short)k);
    }

    @Override
    public short inc(short k) {
        int pos = HashCommon.murmurHash3((int)k) & this.mask;
        short cnt = 0;
        while (this.used(pos)) {
            if (this.key[pos] == k) {
                int n = pos;
                this.values[n] = (byte)(this.values[n] + 1);
                if (this.values[pos] == 1) {
                    this.values[this.idx((int)this.size)] = (byte)pos;
                    this.values[this.poss((int)pos)] = (byte)this.size;
                    this.size = (short)(this.size + 1);
                }
                return this.values[pos];
            }
            if (++cnt > this.n) {
                this.rehash();
                return this.inc(k);
            }
            pos = pos + 1 & this.mask;
        }
        this.key[pos] = k;
        this.values[pos] = 1;
        this.values[this.idx((int)this.size)] = (byte)pos;
        this.values[this.poss((int)pos)] = (byte)this.size;
        this.size = (short)(this.size + 1);
        return 1;
    }

    @Override
    public short inc(int k) {
        return this.inc((short)k);
    }

    @Override
    public int bytes() {
        int sum = 0;
        sum += this.key.length * 2;
        return sum += this.values.length;
    }

    @Override
    public short getKey(int idx) {
        return this.key[this.values[this.idx(idx)]];
    }

    @Override
    public int getVal(int idx) {
        return this.values[this.values[this.idx(idx)]];
    }

    @Override
    public int getIntKey(int idx) {
        return this.getKey(idx);
    }
}

