/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.lda.algo.structures;

import com.tencent.angel.ml.lda.algo.structures.ShortTraverseHashMap;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;

public class S2STraverseMap
extends ShortTraverseHashMap {
    public short[] value;
    boolean[] used;
    public short[] idx;
    short[] poss;

    public S2STraverseMap(short expected) {
        super(expected);
        this.value = new short[this.n];
        this.used = new boolean[this.n];
        this.idx = new short[this.n];
        this.poss = new short[this.n];
    }

    public S2STraverseMap(int expected) {
        this((short)expected);
    }

    @Override
    public short get(short k) {
        int pos = HashCommon.murmurHash3((int)k) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return 0;
    }

    @Override
    public short get(int k) {
        return this.get((short)k);
    }

    @Override
    public void put(int k, int v) {
        this.put((short)k, (short)v);
    }

    @Override
    public void put(short k, short v) {
        if (v == 0) {
            return;
        }
        int pos = HashCommon.murmurHash3((int)k) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                this.value[pos] = v;
                return;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        this.idx[this.size] = (short)pos;
        this.poss[(short)pos] = this.size;
        this.size = (short)(this.size + 1);
    }

    @Override
    public void rehash() {
        short[] kkey = this.key;
        short[] vvalue = this.value;
        this.key = new short[this.n];
        this.value = new short[this.n];
        Arrays.fill(this.used, false);
        int temp = this.size;
        this.size = 0;
        for (int i = 0; i < temp; ++i) {
            short k = kkey[this.idx[i]];
            short v = vvalue[this.idx[i]];
            this.put(k, v);
        }
    }

    @Override
    public short dec(int k) {
        return this.dec((short)k);
    }

    @Override
    public short dec(short k) {
        int pos = HashCommon.murmurHash3((int)k) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                int n = pos;
                this.value[n] = (short)(this.value[n] - 1);
                if (this.value[pos] == 0) {
                    this.size = (short)(this.size - 1);
                    this.idx[this.poss[pos]] = this.idx[this.size];
                    this.poss[this.idx[this.size]] = this.poss[pos];
                }
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return 0;
    }

    @Override
    public short inc(int k) {
        return this.inc((short)k);
    }

    @Override
    public short inc(short k) {
        int pos = HashCommon.murmurHash3((int)k) & this.mask;
        short cnt = 0;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                int n = pos;
                this.value[n] = (short)(this.value[n] + 1);
                if (this.value[pos] == 1) {
                    this.idx[this.size] = (short)pos;
                    this.poss[(short)pos] = this.size;
                    this.size = (short)(this.size + 1);
                }
                return this.value[pos];
            }
            if (++cnt > this.n) {
                this.rehash();
                return this.inc(k);
            }
            pos = pos + 1 & this.mask;
        }
        this.key[pos] = k;
        this.value[pos] = 1;
        this.used[pos] = true;
        this.idx[this.size] = (short)pos;
        this.poss[(short)pos] = this.size;
        this.size = (short)(this.size + 1);
        return 1;
    }

    @Override
    public int bytes() {
        int sum = 0;
        sum += this.key.length * 2;
        sum += this.value.length * 2;
        sum += this.used.length;
        sum += this.idx.length * 2;
        return sum += this.poss.length * 2;
    }

    @Override
    public short getKey(int idx) {
        return this.key[this.idx[idx]];
    }

    @Override
    public int getVal(int idx) {
        return this.value[this.idx[idx]];
    }

    @Override
    public int getIntKey(int idx) {
        return this.getKey(idx);
    }
}

