/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.lda.psf;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.ml.matrix.psf.update.base.PartitionUpdateParam;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CSRPartUpdateParam
extends PartitionUpdateParam {
    private static final Log LOG = LogFactory.getLog(CSRPartUpdateParam.class);
    Int2IntOpenHashMap[] updates;
    ByteBuf buf;

    public CSRPartUpdateParam(int matId, PartitionKey pkey, Int2IntOpenHashMap[] updates) {
        super(matId, pkey);
        this.updates = updates;
    }

    public CSRPartUpdateParam() {
    }

    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        int w = this.getPartKey().getStartRow();
        for (int i = 0; i < this.updates.length; ++i) {
            if (this.updates[i] == null) continue;
            buf.writeInt(w + i);
            Int2IntOpenHashMap map = this.updates[i];
            buf.writeInt(map.size());
            ObjectIterator iter = map.int2IntEntrySet().fastIterator();
            while (iter.hasNext()) {
                Int2IntMap.Entry entry = (Int2IntMap.Entry)iter.next();
                buf.writeInt(entry.getIntKey());
                buf.writeInt(entry.getIntValue());
            }
        }
    }

    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.buf = buf.duplicate();
        this.buf.retain();
    }

    public int bufferLen() {
        int len = 0;
        for (int i = 0; i < this.updates.length; ++i) {
            if (this.updates[i] == null) continue;
            len += 8 + this.updates[i].size() * 8;
        }
        return super.bufferLen() + len;
    }
}

