/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.lda.psf;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.ml.matrix.psf.get.base.GetParam;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetParam;
import com.tencent.angel.psagent.PSAgentContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;

public class LikelihoodParam
extends GetParam {
    private final float beta;

    public LikelihoodParam(int matrixId, float beta) {
        super(matrixId);
        this.beta = beta;
    }

    public List<PartitionGetParam> split() {
        ArrayList<PartitionGetParam> params = new ArrayList<PartitionGetParam>();
        List pkeys = PSAgentContext.get().getMatrixMetaManager().getPartitions(this.matrixId);
        for (PartitionKey pkey : pkeys) {
            params.add(new LikelihoodPartParam(this.matrixId, pkey, this.beta));
        }
        return params;
    }

    public static class LikelihoodPartParam
    extends PartitionGetParam {
        private float beta;

        public LikelihoodPartParam(int matrixId, PartitionKey pkey, float beta) {
            super(matrixId, pkey);
            this.beta = beta;
        }

        public LikelihoodPartParam() {
        }

        public void serialize(ByteBuf buf) {
            super.serialize(buf);
            buf.writeFloat(this.beta);
        }

        public void deserialize(ByteBuf buf) {
            super.deserialize(buf);
            this.beta = buf.readFloat();
        }

        public int bufferLen() {
            return super.bufferLen() + 4;
        }

        public float getBeta() {
            return this.beta;
        }
    }
}

