/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.lda.psf;

import com.tencent.angel.exception.AngelException;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetResult;
import com.tencent.angel.ps.storage.vector.ServerIntIntRow;
import com.tencent.angel.ps.storage.vector.ServerRow;
import com.tencent.angel.ps.storage.vector.ServerRowUtils;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PartCSRResult
extends PartitionGetResult {
    private static final Log LOG = LogFactory.getLog(PartCSRResult.class);
    private List<ServerRow> splits;
    private ByteBuf buf;
    private int len;
    private int readerIdx;

    public PartCSRResult(List<ServerRow> splits) {
        this.splits = splits;
    }

    public PartCSRResult() {
    }

    public void serialize(ByteBuf buf) {
        buf.writeInt(this.splits.size());
        for (ServerRow row : this.splits) {
            if (row.isDense()) {
                this.serializeDense(buf, (ServerIntIntRow)row);
                continue;
            }
            if (row.isSparse()) {
                this.serializeSparse(buf, (ServerIntIntRow)row);
                continue;
            }
            throw new AngelException("LDA should be set with ServerDenseIntRow");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeDense(ByteBuf buf, ServerIntIntRow row) {
        try {
            int i;
            row.startRead();
            int[] values = ServerRowUtils.getVector((ServerIntIntRow)row).getStorage().getValues();
            int len = (int)(row.getEndCol() - row.getStartCol());
            int cnt = 0;
            for (i = 0; i < len; ++i) {
                if (values[i] <= 0) continue;
                ++cnt;
            }
            if ((double)cnt > (double)len * 0.5) {
                buf.writeByte(0);
                buf.writeInt(len);
                for (i = 0; i < len; ++i) {
                    buf.writeInt(values[i]);
                }
            } else {
                buf.writeByte(1);
                buf.writeInt(cnt);
                for (i = 0; i < len; ++i) {
                    if (values[i] <= 0) continue;
                    buf.writeInt(i);
                    buf.writeInt(values[i]);
                }
            }
        }
        finally {
            row.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeSparse(ByteBuf buf, ServerIntIntRow row) {
        try {
            row.startRead();
            ObjectIterator iterator = ServerRowUtils.getVector((ServerIntIntRow)row).getStorage().entryIterator();
            buf.writeByte(1);
            int index = buf.writerIndex();
            buf.writeInt(row.size());
            int cnt = 0;
            while (iterator.hasNext()) {
                Int2IntMap.Entry entry = (Int2IntMap.Entry)iterator.next();
                int key = entry.getIntKey();
                int val = entry.getIntValue();
                if (val <= 0) continue;
                buf.writeInt(key);
                buf.writeInt(val);
                ++cnt;
            }
            buf.setInt(index, cnt);
        }
        finally {
            row.getLock().readLock().unlock();
        }
    }

    public void deserialize(ByteBuf buf) {
        this.len = buf.readInt();
        this.buf = buf.duplicate();
        this.buf.retain();
        this.readerIdx = 0;
    }

    public int bufferLen() {
        int len = 4;
        for (ServerRow row : this.splits) {
            int i;
            int cnt;
            int size;
            int[] values;
            if (row.isDense()) {
                values = ServerRowUtils.getVector((ServerIntIntRow)((ServerIntIntRow)row)).getStorage().getValues();
                size = (int)(row.getEndCol() - row.getStartCol());
                cnt = 0;
                for (i = 0; i < size; ++i) {
                    if (values[i] <= 0) continue;
                    ++cnt;
                }
                len += 5;
                if ((double)cnt > (double)size * 0.5) {
                    len += 4 * size;
                    continue;
                }
                len += 8 * cnt;
                continue;
            }
            if (row.isSparse()) {
                values = ServerRowUtils.getVector((ServerIntIntRow)((ServerIntIntRow)row)).getStorage().getValues();
                size = values.length;
                cnt = 0;
                for (i = 0; i < size; ++i) {
                    if (values[i] <= 0) continue;
                    ++cnt;
                }
                len += 5 + 8 * cnt;
                continue;
            }
            return len;
        }
        return len;
    }

    public boolean read(int[] row) {
        if (this.readerIdx == this.len) {
            return false;
        }
        ++this.readerIdx;
        byte type = this.buf.readByte();
        switch (type) {
            case 0: {
                int len = this.buf.readInt();
                for (int i = 0; i < len; ++i) {
                    row[i] = this.buf.readInt();
                }
                break;
            }
            case 1: {
                int len = this.buf.readInt();
                Arrays.fill(row, 0);
                for (int i = 0; i < len; ++i) {
                    int val;
                    int key = this.buf.readInt();
                    row[key] = val = this.buf.readInt();
                }
                break;
            }
            default: {
                throw new AngelException("type mismatch");
            }
        }
        return true;
    }

    public void clear() {
        try {
            this.buf.release();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

