/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.lda.psf;

import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetResult;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PartColumnResult
extends PartitionGetResult {
    private ByteBuf buf;
    public Map<Integer, Int2IntOpenHashMap> cks;

    public PartColumnResult(Map<Integer, Int2IntOpenHashMap> cks) {
        this.cks = cks;
    }

    public PartColumnResult() {
    }

    public void serialize(ByteBuf buf) {
        Iterator<Integer> keyIterator = this.cks.keySet().iterator();
        buf.writeInt(this.cks.size());
        while (keyIterator.hasNext()) {
            int column = keyIterator.next();
            buf.writeInt(column);
            Int2IntOpenHashMap ck = this.cks.get(column);
            buf.writeInt(ck.size());
            ObjectIterator iter = ck.int2IntEntrySet().fastIterator();
            while (iter.hasNext()) {
                Int2IntMap.Entry entry = (Int2IntMap.Entry)iter.next();
                buf.writeInt(entry.getIntKey());
                buf.writeInt(entry.getIntValue());
            }
        }
    }

    public int bufferLen() {
        int len = 4;
        for (int column : this.cks.keySet()) {
            Int2IntOpenHashMap ck = this.cks.get(column);
            len += 8;
            len += ck.keySet().size() * 8;
        }
        return len;
    }

    public void deserialize(ByteBuf buf) {
        int numColumns = buf.readInt();
        this.cks = new HashMap<Integer, Int2IntOpenHashMap>();
        for (int i = 0; i < numColumns; ++i) {
            int column = buf.readInt();
            int size = buf.readInt();
            Int2IntOpenHashMap ck = new Int2IntOpenHashMap(size);
            for (int j = 0; j < size; ++j) {
                ck.put(buf.readInt(), buf.readInt());
            }
            this.cks.put(column, ck);
        }
    }

    public void merge(PartColumnResult other) {
        for (int column : other.cks.keySet()) {
            if (this.cks.containsKey(column)) {
                this.cks.get(column).putAll((Map)other.cks.get(column));
                continue;
            }
            this.cks.put(column, other.cks.get(column));
        }
    }
}

