/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.psf.columns;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.ml.math2.utils.ArrayCopy;
import com.tencent.angel.ml.math2.vector.IntIntVector;
import com.tencent.angel.ml.math2.vector.IntLongVector;
import com.tencent.angel.ml.math2.vector.Vector;
import com.tencent.angel.ml.matrix.psf.get.base.GetParam;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetParam;
import com.tencent.angel.ml.psf.columns.PartitionGetColsParam;
import com.tencent.angel.ps.server.data.request.InitFunc;
import com.tencent.angel.psagent.PSAgentContext;
import java.util.ArrayList;
import java.util.List;

public class GetColsParam
extends GetParam {
    int[] rows;
    long[] cols;
    InitFunc func;

    public GetColsParam(int matId, int[] rows, long[] cols, InitFunc func) {
        super(matId);
        this.rows = rows;
        this.cols = cols;
        this.func = func;
    }

    public GetColsParam(int matId, int[] rows, long[] cols) {
        this(matId, rows, cols, null);
    }

    public GetColsParam(int matId, int[] rows, Vector cols, InitFunc func) {
        this(matId, rows, GetColsParam.getCols(cols), func);
    }

    public GetColsParam(int matId, int[] rows, Vector cols) {
        this(matId, rows, GetColsParam.getCols(cols), null);
    }

    static long[] getCols(Vector colVec) {
        if (colVec instanceof IntLongVector) {
            return ((IntLongVector)colVec).getStorage().getValues();
        }
        int[] values = ((IntIntVector)colVec).getStorage().getValues();
        long[] cols = new long[values.length];
        ArrayCopy.copy((int[])values, (long[])cols);
        return cols;
    }

    public List<PartitionGetParam> split() {
        List pkeys = PSAgentContext.get().getMatrixMetaManager().getPartitions(this.matrixId);
        ArrayList<PartitionGetParam> params = new ArrayList<PartitionGetParam>();
        int start = 0;
        int end = 0;
        for (PartitionKey pkey : pkeys) {
            long startCol = pkey.getStartCol();
            long endCol = pkey.getEndCol();
            if (start >= this.cols.length || this.cols[start] < startCol) continue;
            while (end < this.cols.length && this.cols[end] < endCol) {
                ++end;
            }
            long[] part = new long[end - start];
            System.arraycopy(this.cols, start, part, 0, end - start);
            params.add(new PartitionGetColsParam(this.matrixId, pkey, this.rows, part, this.func));
            start = end;
        }
        return params;
    }
}

