/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.psf.columns;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetParam;
import com.tencent.angel.ps.server.data.request.InitFunc;
import io.netty.buffer.ByteBuf;

public class PartitionGetColsParam
extends PartitionGetParam {
    public long[] cols;
    public int[] rows;
    public InitFunc func;

    public PartitionGetColsParam(int matId, PartitionKey pkey, int[] rows, long[] cols, InitFunc func) {
        super(matId, pkey);
        this.rows = rows;
        this.cols = cols;
        this.func = func;
    }

    public PartitionGetColsParam() {
    }

    public void serialize(ByteBuf buf) {
        int i;
        super.serialize(buf);
        buf.writeBoolean(this.func != null);
        if (this.func != null) {
            byte[] data = this.func.getClass().getName().getBytes();
            buf.writeInt(data.length);
            buf.writeBytes(data);
            this.func.serialize(buf);
        }
        buf.writeInt(this.rows.length);
        for (i = 0; i < this.rows.length; ++i) {
            buf.writeInt(this.rows[i]);
        }
        buf.writeInt(this.cols.length);
        for (i = 0; i < this.cols.length; ++i) {
            buf.writeLong(this.cols[i]);
        }
    }

    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        boolean useInitFunc = buf.readBoolean();
        if (useInitFunc) {
            int size = buf.readInt();
            byte[] data = new byte[size];
            buf.readBytes(data);
            String initFuncClass = new String(data);
            try {
                this.func = (InitFunc)Class.forName(initFuncClass).newInstance();
            }
            catch (Throwable e) {
                throw new UnsupportedOperationException(e);
            }
            this.func.deserialize(buf);
        }
        int nRows = buf.readInt();
        this.rows = new int[nRows];
        for (int i = 0; i < nRows; ++i) {
            this.rows[i] = buf.readInt();
        }
        int nCols = buf.readInt();
        this.cols = new long[nCols];
        for (int i = 0; i < nCols; ++i) {
            this.cols[i] = buf.readLong();
        }
    }

    public int bufferLen() {
        int len = super.bufferLen() + this.rows.length * 4 + this.cols.length * 8 + 8;
        len = this.func != null ? (len += 8 + this.func.getClass().getName().getBytes().length + this.func.bufferLen()) : (len += 4);
        return len;
    }
}

