/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.psf.columns;

import com.tencent.angel.exception.AngelException;
import com.tencent.angel.ml.math2.VFactory;
import com.tencent.angel.ml.math2.vector.CompIntDoubleVector;
import com.tencent.angel.ml.math2.vector.CompIntFloatVector;
import com.tencent.angel.ml.math2.vector.IntDoubleVector;
import com.tencent.angel.ml.math2.vector.IntFloatVector;
import com.tencent.angel.ml.math2.vector.Vector;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetResult;
import io.netty.buffer.ByteBuf;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PartitionGetColsResult
extends PartitionGetResult {
    private static Log LOG = LogFactory.getLog(PartitionGetColsResult.class);
    int[] rows;
    long[] cols;
    Vector vector;

    public PartitionGetColsResult(int[] rows, long[] cols, Vector vector) {
        this.rows = rows;
        this.cols = cols;
        this.vector = vector;
    }

    public PartitionGetColsResult() {
    }

    public void serialize(ByteBuf buf) {
        PartitionGetColsResult.serialize(buf, this.rows, this.cols, this.vector);
    }

    private static void serialize(ByteBuf buf, CompIntDoubleVector vector, long[] cols) {
        buf.writeByte(0);
        IntDoubleVector[] parts = vector.getPartitions();
        for (int c = 0; c < cols.length; ++c) {
            buf.writeLong(cols[c]);
            double[] values = parts[c].getStorage().getValues();
            for (int r = 0; r < values.length; ++r) {
                buf.writeDouble(values[r]);
            }
        }
    }

    private static void serialize(ByteBuf buf, CompIntFloatVector vector, long[] cols) {
        buf.writeByte(1);
        IntFloatVector[] parts = vector.getPartitions();
        for (int c = 0; c < cols.length; ++c) {
            buf.writeLong(cols[c]);
            float[] values = parts[c].getStorage().getValues();
            for (int r = 0; r < values.length; ++r) {
                buf.writeFloat(values[r]);
            }
        }
    }

    public static void serialize(ByteBuf buf, int[] rows, long[] cols, Vector vector) {
        buf.writeInt(rows.length);
        for (int i = 0; i < rows.length; ++i) {
            buf.writeInt(rows[i]);
        }
        buf.writeInt(cols.length);
        PartitionGetColsResult.serialize(buf, cols, vector);
    }

    public static void serialize(ByteBuf buf, long[] cols, Vector vector) {
        if (vector instanceof CompIntDoubleVector) {
            PartitionGetColsResult.serialize(buf, (CompIntDoubleVector)vector, cols);
        } else if (vector instanceof CompIntFloatVector) {
            PartitionGetColsResult.serialize(buf, (CompIntFloatVector)vector, cols);
        } else {
            throw new AngelException("Data Type should be double or float!");
        }
    }

    public void deserialize(ByteBuf buf) {
        int nRows = buf.readInt();
        this.rows = new int[nRows];
        for (int i = 0; i < nRows; ++i) {
            this.rows[i] = buf.readInt();
        }
        int nCols = buf.readInt();
        this.cols = new long[nCols];
        this.vector = PartitionGetColsResult.deserialize(buf, this.rows, this.cols);
    }

    public static Vector deserialize(ByteBuf buf, int[] rows, long[] cols) {
        switch (buf.readByte()) {
            case 0: {
                return PartitionGetColsResult.deserialize(buf, new IntDoubleVector[cols.length], rows.length, cols);
            }
            case 1: {
                return PartitionGetColsResult.deserialize(buf, new IntFloatVector[cols.length], rows.length, cols);
            }
        }
        throw new AngelException("Data Type should be double or float!");
    }

    private static CompIntDoubleVector deserialize(ByteBuf buf, IntDoubleVector[] vectors, int subDim, long[] cols) {
        for (int c = 0; c < cols.length; ++c) {
            cols[c] = buf.readLong();
            double[] values = new double[subDim];
            for (int r = 0; r < subDim; ++r) {
                values[r] = buf.readDouble();
            }
            vectors[c] = VFactory.denseDoubleVector((double[])values);
        }
        return VFactory.compIntDoubleVector((int)(subDim * cols.length), (IntDoubleVector[])vectors, (int)subDim);
    }

    private static CompIntFloatVector deserialize(ByteBuf buf, IntFloatVector[] vectors, int subDim, long[] cols) {
        for (int c = 0; c < cols.length; ++c) {
            cols[c] = buf.readLong();
            float[] values = new float[subDim];
            for (int r = 0; r < subDim; ++r) {
                values[r] = buf.readFloat();
            }
            vectors[c] = VFactory.denseFloatVector((float[])values);
        }
        return VFactory.compIntFloatVector((int)(subDim * cols.length), (IntFloatVector[])vectors, (int)subDim);
    }

    public int bufferLen() {
        int len = 8 + this.rows.length * 4;
        if (this.vector instanceof CompIntDoubleVector) {
            len += 1 + this.cols.length * 8 + this.rows.length * this.cols.length * 8;
        } else if (this.vector instanceof CompIntFloatVector) {
            len += 1 + this.cols.length * 8 + this.rows.length * this.cols.length * 4;
        } else {
            return len;
        }
        return len;
    }

    public static int bufferLen(int[] rows, long[] cols, Vector vector) {
        int len = 8 + rows.length * 4;
        if (vector instanceof CompIntDoubleVector) {
            len += 1 + cols.length * 8 + rows.length * cols.length * 8;
        } else if (vector instanceof CompIntFloatVector) {
            len += 1 + cols.length * 8 + rows.length * cols.length * 4;
        } else {
            return len;
        }
        return len;
    }
}

