/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.psf.columns;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.ml.math2.vector.Vector;
import com.tencent.angel.ml.matrix.psf.update.base.PartitionUpdateParam;
import com.tencent.angel.ml.psf.columns.PartitionGetColsResult;
import com.tencent.angel.ps.server.data.request.UpdateOp;
import io.netty.buffer.ByteBuf;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PartitionUpdateColsParam
extends PartitionUpdateParam {
    private static Log LOG = LogFactory.getLog(PartitionUpdateColsParam.class);
    int[] rows;
    long[] cols;
    Vector vector;
    UpdateOp op;

    public PartitionUpdateColsParam(int matId, PartitionKey pkey, int[] rows, long[] cols, Vector vector, UpdateOp op) {
        super(matId, pkey, false);
        this.rows = rows;
        this.cols = cols;
        this.vector = vector;
        this.op = op;
    }

    public PartitionUpdateColsParam() {
    }

    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.op.getOpId());
        buf.writeInt(this.rows.length);
        for (int i = 0; i < this.rows.length; ++i) {
            buf.writeInt(this.rows[i]);
        }
        buf.writeInt(this.cols.length);
        PartitionGetColsResult.serialize(buf, this.cols, this.vector);
    }

    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.op = UpdateOp.valueOf((int)buf.readInt());
        int nRows = buf.readInt();
        this.rows = new int[nRows];
        for (int i = 0; i < nRows; ++i) {
            this.rows[i] = buf.readInt();
        }
        int nCols = buf.readInt();
        this.cols = new long[nCols];
        this.vector = PartitionGetColsResult.deserialize(buf, this.rows, this.cols);
    }

    public int bufferLen() {
        int len = super.bufferLen();
        return len += 4 + PartitionGetColsResult.bufferLen(this.rows, this.cols, this.vector);
    }
}

