/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.psf.columns;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.exception.AngelException;
import com.tencent.angel.ml.math2.VFactory;
import com.tencent.angel.ml.math2.utils.ArrayCopy;
import com.tencent.angel.ml.math2.utils.VectorUtils;
import com.tencent.angel.ml.math2.vector.IntDoubleVector;
import com.tencent.angel.ml.math2.vector.IntFloatVector;
import com.tencent.angel.ml.math2.vector.IntIntVector;
import com.tencent.angel.ml.math2.vector.IntKeyVector;
import com.tencent.angel.ml.math2.vector.IntLongVector;
import com.tencent.angel.ml.math2.vector.Vector;
import com.tencent.angel.ml.matrix.psf.update.base.PartitionUpdateParam;
import com.tencent.angel.ml.matrix.psf.update.base.UpdateParam;
import com.tencent.angel.ml.psf.columns.PartitionUpdateColsParam;
import com.tencent.angel.ps.server.data.request.UpdateOp;
import com.tencent.angel.psagent.PSAgentContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UpdateColsParam
extends UpdateParam {
    int[] rows;
    private Vector cols;
    Map<Long, Vector> values;
    UpdateOp op;

    public UpdateColsParam(int matId, int[] rows, Vector cols, Map<Long, Vector> values) {
        this(matId, rows, cols, values, UpdateOp.PLUS);
    }

    public UpdateColsParam(int matId, int[] rows, Vector cols, Map<Long, Vector> values, UpdateOp op) {
        super(matId);
        this.rows = rows;
        this.cols = cols;
        this.values = values;
        this.op = op;
    }

    public List<PartitionUpdateParam> split() {
        List pkeys = PSAgentContext.get().getMatrixMetaManager().getPartitions(this.matrixId);
        ArrayList<PartitionUpdateParam> params = new ArrayList<PartitionUpdateParam>();
        int start = 0;
        int end = 0;
        for (PartitionKey pkey : pkeys) {
            int i;
            IntDoubleVector[] updates;
            long startCol = pkey.getStartCol();
            long endCol = pkey.getEndCol();
            if (start >= ((IntKeyVector)this.cols).getDim() || VectorUtils.getLong((Vector)this.cols, (long)start) < startCol) continue;
            while (end < ((IntKeyVector)this.cols).getDim() && VectorUtils.getLong((Vector)this.cols, (long)end) < endCol) {
                ++end;
            }
            long[] part = new long[end - start];
            if (this.cols instanceof IntIntVector) {
                ArrayCopy.copy((int[])((IntIntVector)this.cols).getStorage().getValues(), (int)start, (long[])part, (int)0, (int)(end - start));
            } else {
                System.arraycopy(((IntLongVector)this.cols).getStorage().getValues(), start, part, 0, end - start);
            }
            long firstKey = 0L;
            Iterator<Map.Entry<Long, Vector>> iterator = this.values.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<Long, Vector> first = iterator.next();
                firstKey = first.getKey();
            }
            if (this.values.get(firstKey) instanceof IntDoubleVector) {
                updates = new IntDoubleVector[part.length];
                for (i = 0; i < part.length; ++i) {
                    updates[i] = (IntDoubleVector)this.values.get(part[i]);
                }
                params.add(new PartitionUpdateColsParam(this.matrixId, pkey, this.rows, part, (Vector)VFactory.compIntDoubleVector((int)this.rows.length, (IntDoubleVector[])updates, (int)part.length), this.op));
            } else if (this.values.get(firstKey) instanceof IntFloatVector) {
                updates = new IntFloatVector[part.length];
                for (i = 0; i < part.length; ++i) {
                    updates[i] = (IntFloatVector)this.values.get(part[i]);
                }
                params.add(new PartitionUpdateColsParam(this.matrixId, pkey, this.rows, part, (Vector)VFactory.compIntFloatVector((int)this.rows.length, (IntFloatVector[])updates, (int)part.length), this.op));
            } else {
                throw new AngelException("Update data type should be float or double!");
            }
            start = end;
        }
        return params;
    }
}

