/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.psf.compress;

import com.tencent.angel.ml.math2.vector.IntDoubleVector;
import com.tencent.angel.ml.math2.vector.Vector;
import com.tencent.angel.ml.matrix.psf.update.base.PartitionUpdateParam;
import com.tencent.angel.ml.matrix.psf.update.base.UpdateFunc;
import com.tencent.angel.ml.matrix.psf.update.base.UpdateParam;
import com.tencent.angel.ml.psf.compress.QuantifyDoubleParam;
import com.tencent.angel.ps.storage.partition.RowBasedPartition;
import com.tencent.angel.ps.storage.vector.ServerIntDoubleRow;
import com.tencent.angel.ps.storage.vector.ServerRow;
import com.tencent.angel.ps.storage.vector.ServerRowUtils;

public class QuantifyDoubleFunc
extends UpdateFunc {
    public QuantifyDoubleFunc(int matrixId, int rowId, double[] array, int bitPerItem) {
        super((UpdateParam)new QuantifyDoubleParam(matrixId, rowId, array, bitPerItem));
    }

    public QuantifyDoubleFunc(int matrixId, int rowId, IntDoubleVector vector, int bitPerItem) {
        this(matrixId, rowId, vector.getStorage().getValues(), bitPerItem);
    }

    public QuantifyDoubleFunc(int matrixId, int rowId, Vector vector, int bitPerItem) {
        this(matrixId, rowId, (IntDoubleVector)vector, bitPerItem);
    }

    public QuantifyDoubleFunc() {
        super(null);
    }

    public void partitionUpdate(PartitionUpdateParam partParam) {
        QuantifyDoubleParam.QuantifyDoublePartUParam cp;
        ServerRow row;
        RowBasedPartition part = (RowBasedPartition)this.psContext.getMatrixStorageManager().getPart(partParam.getMatrixId(), partParam.getPartKey().getPartitionId());
        if (part != null && (row = part.getRow((cp = (QuantifyDoubleParam.QuantifyDoublePartUParam)partParam).getRowId())) != null) {
            this.update(row, cp.getArraySlice());
        }
    }

    private void update(ServerRow row, double[] arraySlice) {
        switch (row.getRowType()) {
            case T_DOUBLE_DENSE: {
                this.doUpdate((ServerIntDoubleRow)row, arraySlice);
                return;
            }
        }
        throw new RuntimeException("Spark on Angel currently only supports Double Dense Row");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(ServerIntDoubleRow row, double[] arraySlice) {
        try {
            row.getLock().writeLock().lock();
            double[] values = ServerRowUtils.getVector((ServerIntDoubleRow)row).getStorage().getValues();
            int size = row.size();
            for (int i = 0; i < size; ++i) {
                values[i] = values[i] + arraySlice[i];
            }
        }
        finally {
            row.getLock().writeLock().unlock();
        }
    }
}

