/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.psf.compress;

import com.tencent.angel.ml.math2.vector.IntFloatVector;
import com.tencent.angel.ml.math2.vector.Vector;
import com.tencent.angel.ml.matrix.psf.update.base.PartitionUpdateParam;
import com.tencent.angel.ml.matrix.psf.update.base.UpdateFunc;
import com.tencent.angel.ml.matrix.psf.update.base.UpdateParam;
import com.tencent.angel.ml.psf.compress.QuantifyFloatParam;
import com.tencent.angel.ps.storage.partition.RowBasedPartition;
import com.tencent.angel.ps.storage.vector.ServerIntFloatRow;
import com.tencent.angel.ps.storage.vector.ServerRow;
import com.tencent.angel.ps.storage.vector.ServerRowUtils;

public class QuantifyFloatFunc
extends UpdateFunc {
    public QuantifyFloatFunc(int matrixId, int rowId, float[] array, int bitPerItem) {
        super((UpdateParam)new QuantifyFloatParam(matrixId, rowId, array, bitPerItem));
    }

    public QuantifyFloatFunc(int matrixId, int rowId, IntFloatVector vector, int bitPerItem) {
        this(matrixId, rowId, vector.getStorage().getValues(), bitPerItem);
    }

    public QuantifyFloatFunc(int matrixId, int rowId, Vector vector, int bitPerItem) {
        this(matrixId, rowId, (IntFloatVector)vector, bitPerItem);
    }

    public QuantifyFloatFunc() {
        super(null);
    }

    public void partitionUpdate(PartitionUpdateParam partParam) {
        QuantifyFloatParam.QuantifyFloatPartParam cp;
        ServerRow row;
        RowBasedPartition part = (RowBasedPartition)this.psContext.getMatrixStorageManager().getPart(partParam.getMatrixId(), partParam.getPartKey().getPartitionId());
        if (part != null && (row = part.getRow((cp = (QuantifyFloatParam.QuantifyFloatPartParam)partParam).getRowId())) != null) {
            this.update(row, cp.getArraySlice());
        }
    }

    private void update(ServerRow row, float[] arraySlice) {
        switch (row.getRowType()) {
            case T_FLOAT_DENSE: {
                this.doUpdate((ServerIntFloatRow)row, arraySlice);
                return;
            }
        }
        throw new RuntimeException("Spark on Angel currently only supports Double Dense Row");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(ServerIntFloatRow row, float[] arraySlice) {
        try {
            row.getLock().writeLock().lock();
            float[] values = ServerRowUtils.getVector((ServerIntFloatRow)row).getStorage().getValues();
            int size = row.size();
            for (int i = 0; i < size; ++i) {
                values[i] = values[i] + arraySlice[i];
            }
        }
        finally {
            row.getLock().writeLock().unlock();
        }
    }
}

