/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.psf.compress;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.ml.core.utils.JCompressUtils;
import com.tencent.angel.ml.matrix.psf.update.base.PartitionUpdateParam;
import com.tencent.angel.ml.matrix.psf.update.base.UpdateParam;
import com.tencent.angel.psagent.PSAgentContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;

public class QuantifyFloatParam
extends UpdateParam {
    private final int rowId;
    private final float[] array;
    private int numBits;

    public QuantifyFloatParam(int matrixId, int rowId, float[] array, int numBits) {
        super(matrixId, false);
        this.rowId = rowId;
        this.array = array;
        this.numBits = numBits;
    }

    public List<PartitionUpdateParam> split() {
        List partList = PSAgentContext.get().getMatrixMetaManager().getPartitions(this.matrixId, this.rowId);
        int size = partList.size();
        ArrayList<PartitionUpdateParam> partParams = new ArrayList<PartitionUpdateParam>(size);
        for (PartitionKey part : partList) {
            if (this.rowId < part.getStartRow() || this.rowId >= part.getEndRow()) {
                throw new RuntimeException("Wrong rowId!");
            }
            partParams.add(new QuantifyFloatPartParam(this.matrixId, part, this.rowId, (int)part.getStartCol(), (int)part.getEndCol(), this.array, this.numBits));
        }
        return partParams;
    }

    public static class QuantifyFloatPartParam
    extends PartitionUpdateParam {
        private int rowId;
        private int start;
        private int end;
        private float[] array;
        private float[] arraySlice;
        private int numBits;

        public QuantifyFloatPartParam(int matrixId, PartitionKey partKey, int rowId, int start, int end, float[] array, int numBits) {
            super(matrixId, partKey, false);
            this.rowId = rowId;
            this.start = start;
            this.end = end;
            this.array = array;
            this.numBits = numBits;
        }

        public QuantifyFloatPartParam() {
        }

        public void serialize(ByteBuf buf) {
            super.serialize(buf);
            buf.writeInt(this.rowId);
            JCompressUtils.Quantification.serializeFloat(buf, this.array, this.start, this.end, this.numBits);
        }

        public void deserialize(ByteBuf buf) {
            super.deserialize(buf);
            this.rowId = buf.readInt();
            this.arraySlice = JCompressUtils.Quantification.deserializeFloat(buf);
        }

        public int bufferLen() {
            return super.bufferLen() + 12 + (int)Math.ceil((this.end - this.start) * this.numBits / 8);
        }

        public int getRowId() {
            return this.rowId;
        }

        public float[] getArraySlice() {
            return this.arraySlice;
        }

        public String toString() {
            return "QuantifyDoublePartUParam [rowId=" + this.rowId + ", numBits=" + this.numBits + ", toString()=" + super.toString() + "]";
        }
    }
}

