/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.ml.psf.optimizer;

import com.tencent.angel.ml.math2.ufuncs.OptFuncs;
import com.tencent.angel.ml.math2.vector.Vector;
import com.tencent.angel.ml.psf.optimizer.OptMMUpdateFunc;
import com.tencent.angel.ps.storage.partition.RowBasedPartition;
import com.tencent.angel.ps.storage.vector.ServerRow;
import com.tencent.angel.ps.storage.vector.ServerRowUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AdaGradUpdateFunc
extends OptMMUpdateFunc {
    private static final Log LOG = LogFactory.getLog(AdaGradUpdateFunc.class);

    public AdaGradUpdateFunc() {
    }

    public AdaGradUpdateFunc(int matId, int factor, double epsilon, double beta, double lr, double regL1Param, double regL2Param, int epoch) {
        this(matId, factor, epsilon, beta, lr, regL1Param, regL2Param, epoch, 1);
    }

    public AdaGradUpdateFunc(int matId, int factor, double epsilon, double beta, double lr, double regL1Param, double regL2Param, int epoch, int batchSize) {
        super(matId, new int[]{factor}, new double[]{epsilon, beta, lr, regL1Param, regL2Param, epoch, batchSize});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(RowBasedPartition partition, int factor, double[] scalars) {
        double epsilon = scalars[0];
        double beta = scalars[1];
        double lr = scalars[2];
        double l1RegParam = scalars[3];
        double l2RegParam = scalars[4];
        double epoch = (int)scalars[5];
        double batchSize = (int)scalars[6];
        for (int f = 0; f < factor; ++f) {
            ServerRow gradientServerRow = partition.getRow(f + 2 * factor);
            try {
                gradientServerRow.startWrite();
                Vector weight = ServerRowUtils.getVector((ServerRow)partition.getRow(f));
                Vector square = ServerRowUtils.getVector((ServerRow)partition.getRow(f + factor));
                Vector gradient = ServerRowUtils.getVector((ServerRow)gradientServerRow);
                if (batchSize > 1.0) {
                    gradient.idiv(batchSize);
                }
                OptFuncs.iexpsmoothing2((Vector)square, (Vector)gradient, (double)beta);
                if (l2RegParam != 0.0) {
                    gradient.iaxpy(weight, l2RegParam);
                }
                OptFuncs.iadagraddelta((Vector)gradient, (Vector)square, (double)l2RegParam, (double)lr);
                weight.isub(gradient);
                if (l1RegParam != 0.0) {
                    OptFuncs.iadagradthredshold((Vector)weight, (Vector)square, (double)l1RegParam, (double)l2RegParam, (double)lr);
                }
                gradient.clear();
                continue;
            }
            finally {
                gradientServerRow.endWrite();
            }
        }
    }
}

