/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.sdk.crypto.cryptor;

import com.tencent.bk.sdk.crypto.annotation.Cryptor;
import com.tencent.bk.sdk.crypto.annotation.CryptorTypeEnum;
import com.tencent.bk.sdk.crypto.cryptor.ASymmetricCryptor;
import com.tencent.bk.sdk.crypto.exception.CryptorNotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASymmetricCryptorFactory {
    private static final Logger log = LoggerFactory.getLogger(ASymmetricCryptorFactory.class);
    static Map<String, ASymmetricCryptor> aSymmetricCryptorMap = new ConcurrentHashMap<String, ASymmetricCryptor>();
    static AtomicBoolean load = new AtomicBoolean(false);

    public static ASymmetricCryptor getCryptor(String name) {
        ASymmetricCryptor cryptor;
        if (!load.get()) {
            ASymmetricCryptorFactory.init();
        }
        if ((cryptor = aSymmetricCryptorMap.get(name)) != null) {
            return cryptor;
        }
        throw new CryptorNotFoundException("ASymmetricCryptor for " + name + " not found");
    }

    private static void init() {
        if (!load.compareAndSet(false, true)) {
            return;
        }
        ServiceLoader<ASymmetricCryptor> serviceLoader = ServiceLoader.load(ASymmetricCryptor.class);
        if (!serviceLoader.iterator().hasNext()) {
            serviceLoader = ServiceLoader.load(ASymmetricCryptor.class, ServiceLoader.class.getClassLoader());
        }
        HashMap<String, Integer> candidatePriorityMap = new HashMap<String, Integer>();
        HashMap<String, ASymmetricCryptor> candidateMap = new HashMap<String, ASymmetricCryptor>();
        for (ASymmetricCryptor aSymmetricCryptor : serviceLoader) {
            Integer oldPriority;
            String cryptorName2 = aSymmetricCryptor.getClass().getCanonicalName();
            int priority = 0;
            Cryptor cryptoAnonation = aSymmetricCryptor.getClass().getAnnotation(Cryptor.class);
            if (cryptoAnonation != null) {
                if (cryptoAnonation.type() != CryptorTypeEnum.ASYMMETRIC) continue;
                if (StringUtils.isNotBlank((CharSequence)cryptoAnonation.name())) {
                    cryptorName2 = cryptoAnonation.name();
                }
                priority = cryptoAnonation.priority();
            }
            if ((oldPriority = (Integer)candidatePriorityMap.get(cryptorName2)) != null && priority <= oldPriority) continue;
            candidatePriorityMap.put(cryptorName2, priority);
            candidateMap.put(cryptorName2, aSymmetricCryptor);
        }
        candidateMap.forEach((cryptorName, cryptor) -> {
            aSymmetricCryptorMap.put((String)cryptorName, (ASymmetricCryptor)cryptor);
            log.info("Add ASymmetricCryptor " + cryptorName + " Crypto(" + candidatePriorityMap.get(cryptorName) + ") for " + cryptor);
        });
    }
}

