/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.sdk.crypto.cryptor;

import com.tencent.bk.sdk.crypto.cryptor.ASymmetricCryptor;
import com.tencent.bk.sdk.crypto.exception.CryptoException;
import com.tencent.bk.sdk.crypto.util.Base64Util;
import com.tencent.bk.sdk.crypto.util.CryptorMetaUtil;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractASymmetricCryptor
implements ASymmetricCryptor {
    public abstract byte[] encryptIndeed(@NonNull PublicKey var1, @NonNull byte[] var2);

    public abstract byte[] decryptIndeed(@NonNull PrivateKey var1, @NonNull byte[] var2);

    @Override
    public byte[] encrypt(PublicKey publicKey, byte[] message) {
        if (publicKey == null) {
            throw new CryptoException("encrypt key is invalid: null");
        }
        if (message == null || message.length == 0) {
            return message;
        }
        byte[] encryptedBytes = this.encryptIndeed(publicKey, message);
        return CryptorMetaUtil.addPrefixToEncryptedBytes(this.getStringCipherPrefix(), encryptedBytes);
    }

    @Override
    public byte[] decrypt(PrivateKey privateKey, byte[] encryptedMessage) {
        if (privateKey == null) {
            throw new CryptoException("decrypt key is invalid: null");
        }
        if (encryptedMessage == null || encryptedMessage.length == 0) {
            return encryptedMessage;
        }
        byte[] pureEncryptedBytes = CryptorMetaUtil.removePrefixFromEncryptedBytes(this.getStringCipherPrefix(), encryptedMessage);
        return this.decryptIndeed(privateKey, pureEncryptedBytes);
    }

    @Override
    public abstract String getName();

    @Override
    public String getStringCipherPrefix() {
        return "[Cipher:::" + this.getName() + "]";
    }

    @Override
    public String encrypt(PublicKey publicKey, String message) {
        if (publicKey == null) {
            throw new CryptoException("encrypt key is invalid: null");
        }
        if (StringUtils.isEmpty((CharSequence)message)) {
            return message;
        }
        byte[] encryptedMessage = this.encryptIndeed(publicKey, message.getBytes(StandardCharsets.UTF_8));
        String finalCipher = Base64Util.encodeContentToStr(encryptedMessage);
        String prefix = this.getStringCipherPrefix();
        if (prefix != null) {
            finalCipher = prefix + finalCipher;
        }
        return finalCipher;
    }

    @Override
    public String decrypt(PrivateKey privateKey, String base64MessageWithPrefix) {
        if (privateKey == null) {
            throw new CryptoException("decrypt key is invalid: null");
        }
        if (StringUtils.isEmpty((CharSequence)base64MessageWithPrefix)) {
            return base64MessageWithPrefix;
        }
        String base64EncryptedMessage = StringUtils.removeStart((String)base64MessageWithPrefix, (String)this.getStringCipherPrefix());
        byte[] rawEncryptedMessage = Base64Util.decodeContentToByte(base64EncryptedMessage);
        byte[] decryptedMessage = this.decryptIndeed(privateKey, rawEncryptedMessage);
        return new String(decryptedMessage, StandardCharsets.UTF_8);
    }
}

