/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.sdk.crypto.cryptor;

import com.tencent.bk.sdk.crypto.cryptor.SymmetricCryptor;
import com.tencent.bk.sdk.crypto.exception.CryptoException;
import com.tencent.bk.sdk.crypto.util.Base64Util;
import com.tencent.bk.sdk.crypto.util.CryptorMetaUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSymmetricCryptor
implements SymmetricCryptor {
    public abstract byte[] encryptIndeed(@NonNull byte[] var1, @NonNull byte[] var2);

    public abstract byte[] decryptIndeed(@NonNull byte[] var1, @NonNull byte[] var2);

    public void encryptIndeed(String key, InputStream in, OutputStream out) {
        throw new CryptoException("Stream data encrypt not implemented, please override method: com.tencent.bk.sdk.crypto.cryptor.AbstractSymmetricCryptor.encryptIndeed(String key, InputStream in, OutputStream out) in custom cryptor: " + this.getName());
    }

    public void decryptIndeed(String key, InputStream in, OutputStream out) {
        throw new CryptoException("Stream data decrypt not implemented, please override method: com.tencent.bk.sdk.crypto.cryptor.AbstractSymmetricCryptor.decryptIndeed(String key, InputStream in, OutputStream out) in custom cryptor: " + this.getName());
    }

    @Override
    public byte[] encrypt(byte[] key, byte[] message) {
        if (key == null || key.length == 0) {
            throw new CryptoException("encrypt key is invalid: null or empty");
        }
        if (message == null || message.length == 0) {
            return message;
        }
        byte[] encryptedBytes = this.encryptIndeed(key, message);
        return CryptorMetaUtil.addPrefixToEncryptedBytes(this.getStringCipherPrefix(), encryptedBytes);
    }

    @Override
    public byte[] decrypt(byte[] key, byte[] encryptedMessage) {
        if (key == null || key.length == 0) {
            throw new CryptoException("decrypt key is invalid: null or empty");
        }
        if (encryptedMessage == null || encryptedMessage.length == 0) {
            return encryptedMessage;
        }
        String prefix = this.getStringCipherPrefix();
        byte[] expectedPrefixBytes = prefix.getBytes(StandardCharsets.UTF_8);
        if (encryptedMessage.length < expectedPrefixBytes.length) {
            throw new CryptoException("encryptedMessage is invalid: cannot find enough prefix bytes");
        }
        byte[] pureEncryptedBytes = CryptorMetaUtil.removePrefixFromEncryptedBytes(prefix, encryptedMessage);
        return this.decryptIndeed(key, pureEncryptedBytes);
    }

    @Override
    public void encrypt(String key, InputStream in, OutputStream out) {
        byte[] prefixBytes = this.getStringCipherPrefix().getBytes(StandardCharsets.UTF_8);
        try {
            out.write(prefixBytes);
            this.encryptIndeed(key, in, out);
        }
        catch (IOException e) {
            throw new CryptoException("Fail to encrypt data in stream", e);
        }
    }

    @Override
    public void decrypt(String key, InputStream in, OutputStream out) {
        byte[] prefixBytes = this.getStringCipherPrefix().getBytes(StandardCharsets.UTF_8);
        byte[] cipherPrefixBytes = new byte[prefixBytes.length];
        BufferedInputStream bis = new BufferedInputStream(in);
        bis.mark(prefixBytes.length);
        try {
            int n = bis.read(cipherPrefixBytes);
            if (n != prefixBytes.length) {
                bis.reset();
            } else if (!Arrays.equals(prefixBytes, cipherPrefixBytes)) {
                bis.reset();
            }
            this.decryptIndeed(key, bis, out);
        }
        catch (IOException e) {
            throw new CryptoException("Fail to decrypt data in stream", e);
        }
    }

    @Override
    public abstract String getName();

    @Override
    public String getStringCipherPrefix() {
        return CryptorMetaUtil.getCipherMetaPrefix() + this.getName() + CryptorMetaUtil.getCipherMetaSuffix();
    }

    @Override
    public String encrypt(String key, String message) throws CryptoException {
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw new CryptoException("encrypt key is invalid: null or empty");
        }
        if (StringUtils.isEmpty((CharSequence)message)) {
            return message;
        }
        byte[] encryptedMessage = this.encryptIndeed(key.getBytes(StandardCharsets.UTF_8), message.getBytes(StandardCharsets.UTF_8));
        String finalCipher = Base64Util.encodeContentToStr(encryptedMessage);
        String prefix = this.getStringCipherPrefix();
        if (prefix != null) {
            finalCipher = prefix + finalCipher;
        }
        return finalCipher;
    }

    @Override
    public String decrypt(String key, String base64MessageWithPrefix) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw new CryptoException("decrypt key is invalid: null or empty");
        }
        if (StringUtils.isEmpty((CharSequence)base64MessageWithPrefix)) {
            return base64MessageWithPrefix;
        }
        String base64EncryptedMessage = StringUtils.removeStart((String)base64MessageWithPrefix, (String)this.getStringCipherPrefix());
        byte[] rawEncryptedMessage = Base64Util.decodeContentToByte(base64EncryptedMessage);
        byte[] decryptedMessage = this.decryptIndeed(key.getBytes(StandardCharsets.UTF_8), rawEncryptedMessage);
        return new String(decryptedMessage, StandardCharsets.UTF_8);
    }
}

