/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.sdk.crypto.cryptor.impl;

import com.tencent.bk.sdk.crypto.annotation.Cryptor;
import com.tencent.bk.sdk.crypto.annotation.CryptorTypeEnum;
import com.tencent.bk.sdk.crypto.cryptor.AbstractSymmetricCryptor;
import com.tencent.bk.sdk.crypto.exception.CryptoException;
import com.tencent.bk.sdk.crypto.util.AESUtil;
import java.io.InputStream;
import java.io.OutputStream;
import lombok.NonNull;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

@Cryptor(name="AES", type=CryptorTypeEnum.SYMMETRIC, priority=1)
public class AESCryptor
extends AbstractSymmetricCryptor {
    @Override
    public String getName() {
        return "AES";
    }

    @Override
    public byte[] encryptIndeed(@NonNull byte[] key, @NonNull byte[] message) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        try {
            return AESUtil.encrypt(message, key);
        }
        catch (Exception e) {
            FormattingTuple msg = MessageFormatter.format((String)"Fail to encrypt using AES, key.len={}, message.len={}", (Object)key.length, (Object)message.length);
            throw new CryptoException(msg.getMessage(), e);
        }
    }

    @Override
    public byte[] decryptIndeed(@NonNull byte[] key, @NonNull byte[] encryptedMessage) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (encryptedMessage == null) {
            throw new NullPointerException("encryptedMessage is marked non-null but is null");
        }
        try {
            return AESUtil.decrypt(encryptedMessage, key);
        }
        catch (Exception e) {
            FormattingTuple msg = MessageFormatter.format((String)"Fail to decrypt using AES, key.len={}, encryptedMessage.len={}", (Object)key.length, (Object)encryptedMessage.length);
            throw new CryptoException(msg.getMessage(), e);
        }
    }

    @Override
    public void encryptIndeed(String key, InputStream in, OutputStream out) {
        try {
            AESUtil.encrypt(key, in, out);
        }
        catch (Exception e) {
            FormattingTuple msg = MessageFormatter.format((String)"Fail to encrypt using AES, key.len={}", (Object)key.length());
            throw new CryptoException(msg.getMessage(), e);
        }
    }

    @Override
    public void decryptIndeed(String key, InputStream in, OutputStream out) {
        try {
            AESUtil.decrypt(key, in, out);
        }
        catch (Exception e) {
            FormattingTuple msg = MessageFormatter.format((String)"Fail to decrypt using AES, key.len={}", (Object)key.length());
            throw new CryptoException(msg.getMessage(), e);
        }
    }
}

