/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.sdk.crypto.cryptor.impl;

import com.tencent.bk.sdk.crypto.annotation.Cryptor;
import com.tencent.bk.sdk.crypto.annotation.CryptorTypeEnum;
import com.tencent.bk.sdk.crypto.cryptor.SymmetricCryptor;
import com.tencent.bk.sdk.crypto.exception.CryptoException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

@Cryptor(name="None", type=CryptorTypeEnum.SYMMETRIC, priority=1)
public class NoneCryptor
implements SymmetricCryptor {
    @Override
    public String getName() {
        return "None";
    }

    @Override
    public byte[] encrypt(byte[] key, byte[] message) {
        return message;
    }

    @Override
    public byte[] decrypt(byte[] key, byte[] encryptedMessage) {
        return encryptedMessage;
    }

    @Override
    public void encrypt(String key, InputStream in, OutputStream out) {
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (Exception e) {
            FormattingTuple msg = MessageFormatter.format((String)"Fail to encrypt using None, key.len={}", (Object)key.length());
            throw new CryptoException(msg.getMessage(), e);
        }
    }

    @Override
    public void decrypt(String key, InputStream in, OutputStream out) {
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (Exception e) {
            FormattingTuple msg = MessageFormatter.format((String)"Fail to decrypt using None, key.len={}", (Object)key.length());
            throw new CryptoException(msg.getMessage(), e);
        }
    }

    @Override
    public String getStringCipherPrefix() {
        return "";
    }

    @Override
    public String encrypt(String key, String message) {
        return message;
    }

    @Override
    public String decrypt(String key, String base64MessageWithPrefix) {
        return base64MessageWithPrefix;
    }
}

