/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.sdk.crypto.cryptor.impl;

import com.tencent.bk.sdk.crypto.annotation.Cryptor;
import com.tencent.bk.sdk.crypto.annotation.CryptorTypeEnum;
import com.tencent.bk.sdk.crypto.cryptor.AbstractASymmetricCryptor;
import com.tencent.bk.sdk.crypto.exception.CryptoException;
import com.tencent.bk.sdk.crypto.util.RSAUtil;
import java.security.PrivateKey;
import java.security.PublicKey;
import lombok.NonNull;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

@Cryptor(name="RSA", type=CryptorTypeEnum.ASYMMETRIC, priority=1)
public class RSACryptor
extends AbstractASymmetricCryptor {
    @Override
    public String getName() {
        return "RSA";
    }

    @Override
    public byte[] encryptIndeed(@NonNull PublicKey publicKey, @NonNull byte[] message) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        try {
            return RSAUtil.encryptToBytes(publicKey, message);
        }
        catch (Exception e) {
            FormattingTuple msg = MessageFormatter.format((String)"Fail to encrypt using RSA, publicKey.len={}, message.len={}", (Object)publicKey.getEncoded().length, (Object)message.length);
            throw new CryptoException(msg.getMessage(), e);
        }
    }

    @Override
    public byte[] decryptIndeed(@NonNull PrivateKey privateKey, @NonNull byte[] encryptedMessage) {
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        if (encryptedMessage == null) {
            throw new NullPointerException("encryptedMessage is marked non-null but is null");
        }
        try {
            return RSAUtil.decryptToBytes(privateKey, encryptedMessage);
        }
        catch (Exception e) {
            FormattingTuple msg = MessageFormatter.format((String)"Fail to decrypt using RSA, privateKey.len={}, encryptedMessage.len={}", (Object)privateKey.getEncoded().length, (Object)encryptedMessage.length);
            throw new CryptoException(msg.getMessage(), e);
        }
    }
}

