/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.sdk.crypto.cryptor.impl;

import com.tencent.bk.sdk.crypto.annotation.Cryptor;
import com.tencent.bk.sdk.crypto.annotation.CryptorTypeEnum;
import com.tencent.bk.sdk.crypto.cryptor.AbstractASymmetricCryptor;
import com.tencent.bk.sdk.crypto.util.SM2Util;
import java.security.PrivateKey;
import java.security.PublicKey;
import lombok.NonNull;

@Cryptor(name="SM2", type=CryptorTypeEnum.ASYMMETRIC, priority=1)
public class SM2Cryptor
extends AbstractASymmetricCryptor {
    @Override
    public String getName() {
        return "SM2";
    }

    @Override
    public byte[] encryptIndeed(@NonNull PublicKey publicKey, @NonNull byte[] message) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return SM2Util.encrypt(publicKey, message);
    }

    @Override
    public byte[] decryptIndeed(@NonNull PrivateKey privateKey, @NonNull byte[] encryptedMessage) {
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        if (encryptedMessage == null) {
            throw new NullPointerException("encryptedMessage is marked non-null but is null");
        }
        return SM2Util.decrypt(privateKey, encryptedMessage);
    }
}

