/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.sdk.crypto.cryptor.impl;

import com.tencent.bk.sdk.crypto.annotation.Cryptor;
import com.tencent.bk.sdk.crypto.annotation.CryptorTypeEnum;
import com.tencent.bk.sdk.crypto.cryptor.AbstractSymmetricCryptor;
import com.tencent.bk.sdk.crypto.exception.CryptoException;
import com.tencent.bk.sdk.crypto.util.SM4Util;
import java.io.InputStream;
import java.io.OutputStream;
import lombok.NonNull;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

@Cryptor(name="SM4", type=CryptorTypeEnum.SYMMETRIC, priority=1)
public class SM4Cryptor
extends AbstractSymmetricCryptor {
    @Override
    public String getName() {
        return "SM4";
    }

    @Override
    public byte[] encryptIndeed(@NonNull byte[] key, @NonNull byte[] message) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return SM4Util.encrypt(key, message);
    }

    @Override
    public byte[] decryptIndeed(@NonNull byte[] key, @NonNull byte[] encryptedMessage) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (encryptedMessage == null) {
            throw new NullPointerException("encryptedMessage is marked non-null but is null");
        }
        return SM4Util.decrypt(key, encryptedMessage);
    }

    @Override
    public void encryptIndeed(String key, InputStream in, OutputStream out) {
        try {
            SM4Util.encrypt(key, in, out);
        }
        catch (Exception e) {
            FormattingTuple msg = MessageFormatter.format((String)"Fail to encrypt using SM4, key.len={}", (Object)key.length());
            throw new CryptoException(msg.getMessage(), e);
        }
    }

    @Override
    public void decryptIndeed(String key, InputStream in, OutputStream out) {
        try {
            SM4Util.decrypt(key, in, out);
        }
        catch (Exception e) {
            FormattingTuple msg = MessageFormatter.format((String)"Fail to decrypt using SM4, key.len={}", (Object)key.length());
            throw new CryptoException(msg.getMessage(), e);
        }
    }
}

