/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.sdk.crypto.util;

import com.tencent.bk.sdk.crypto.exception.CryptoException;
import com.tencent.bk.sdk.crypto.util.BasicCipherUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESUtil
extends BasicCipherUtil {
    private static final String CIPHER_ALGORITHM = "AES/CTR/NoPadding";

    public static byte[] encrypt(byte[] data, byte[] key) throws Exception {
        if (data == null || data.length == 0) {
            return data;
        }
        if (key == null || key.length == 0) {
            throw new CryptoException("encrypt key is invalid: null or empty");
        }
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, AESUtil.getKeySpec(cipher, key));
        byte[] iv = cipher.getIV();
        byte[] finalData = cipher.doFinal(data);
        if (iv == null) {
            throw new RuntimeException(String.format("CIPHER_ALGORITHM %s is invalid", CIPHER_ALGORITHM));
        }
        byte[] finalDataWithIv = new byte[finalData.length + iv.length];
        System.arraycopy(iv, 0, finalDataWithIv, 0, iv.length);
        System.arraycopy(finalData, 0, finalDataWithIv, iv.length, finalData.length);
        return finalDataWithIv;
    }

    public static void encrypt(String key, InputStream in, OutputStream out) throws Exception {
        byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, AESUtil.getKeySpec(cipher, keyBytes));
        byte[] arr = cipher.getIV();
        if (arr == null) {
            throw new RuntimeException(String.format("CIPHER_ALGORITHM %s is invalid", CIPHER_ALGORITHM));
        }
        out.write(arr);
        AESUtil.write(in, out, cipher);
    }

    public static byte[] decrypt(byte[] data, byte[] key) throws Exception {
        if (data == null || data.length == 0) {
            return data;
        }
        if (key == null || key.length == 0) {
            throw new CryptoException("decrypt key is invalid: null or empty");
        }
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, (Key)AESUtil.getKeySpec(cipher, key), AESUtil.getIvSpec(cipher, data));
        byte[] dataWithoutIv = new byte[data.length - cipher.getBlockSize()];
        System.arraycopy(data, cipher.getBlockSize(), dataWithoutIv, 0, data.length - cipher.getBlockSize());
        return cipher.doFinal(dataWithoutIv);
    }

    public static void decrypt(String key, InputStream in, OutputStream out) throws Exception {
        byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        byte[] iv = new byte[cipher.getBlockSize()];
        if (in.read(iv) < iv.length) {
            throw new RuntimeException();
        }
        cipher.init(2, (Key)AESUtil.getKeySpec(cipher, keyBytes), new IvParameterSpec(iv));
        AESUtil.write(in, out, cipher);
    }

    private static IvParameterSpec getIvSpec(Cipher cipher, byte[] data) {
        byte[] iv = new byte[cipher.getBlockSize()];
        System.arraycopy(data, 0, iv, 0, iv.length);
        return new IvParameterSpec(iv);
    }

    private static SecretKeySpec getKeySpec(Cipher cipher, byte[] key) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG", "SUN");
        random.setSeed(key);
        kgen.init(cipher.getBlockSize() * 8, random);
        return new SecretKeySpec(kgen.generateKey().getEncoded(), "AES");
    }
}

