/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.sdk.crypto.util;

import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base64Util {
    private static final Logger log = LoggerFactory.getLogger(Base64Util.class);

    public static String decodeContentToStr(String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return null;
        }
        try {
            return new String(Base64.decodeBase64((String)content), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            log.warn("Decode content fail", (Throwable)e);
            return null;
        }
    }

    public static String encodeContentToStr(String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return null;
        }
        try {
            return Base64.encodeBase64String((byte[])content.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.warn("Encode content fail", (Throwable)e);
            return null;
        }
    }

    public static String encodeContentToStr(byte[] byteContent) {
        if (byteContent == null || byteContent.length == 0) {
            return null;
        }
        try {
            return Base64.encodeBase64String((byte[])byteContent);
        }
        catch (Exception e) {
            log.warn("Encode content fail", (Throwable)e);
            return null;
        }
    }

    public static byte[] decodeContentToByte(String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return new byte[0];
        }
        try {
            return Base64.decodeBase64((String)content);
        }
        catch (Exception e) {
            log.warn("Decode content fail", (Throwable)e);
            throw e;
        }
    }
}

