/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.sdk.crypto.util;

import com.tencent.bk.sdk.crypto.cryptor.CryptorMetaDefinition;
import com.tencent.bk.sdk.crypto.exception.CryptoException;
import com.tencent.kona.crypto.CryptoUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptorMetaUtil {
    private static final Logger log = LoggerFactory.getLogger(CryptorMetaUtil.class);

    public static String getCipherMetaPrefix() {
        return CryptorMetaDefinition.getCipherMetaPrefix();
    }

    public static String getCipherMetaSuffix() {
        return CryptorMetaDefinition.getCipherMetaSuffix();
    }

    public static byte[] addPrefixToEncryptedBytes(String prefix, byte[] encryptedBytes) {
        if (StringUtils.isEmpty((CharSequence)prefix)) {
            return encryptedBytes;
        }
        byte[] prefixBytes = prefix.getBytes(StandardCharsets.UTF_8);
        byte[] finalBytes = new byte[encryptedBytes.length + prefixBytes.length];
        System.arraycopy(prefixBytes, 0, finalBytes, 0, prefixBytes.length);
        System.arraycopy(encryptedBytes, 0, finalBytes, prefixBytes.length, encryptedBytes.length);
        return finalBytes;
    }

    public static byte[] removePrefixFromEncryptedBytes(String prefix, byte[] encryptedBytes) {
        byte[] expectedPrefixBytes = prefix.getBytes(StandardCharsets.UTF_8);
        byte[] prefixBytes = new byte[expectedPrefixBytes.length];
        System.arraycopy(encryptedBytes, 0, prefixBytes, 0, prefixBytes.length);
        if (!Arrays.equals(prefixBytes, expectedPrefixBytes)) {
            throw new CryptoException("encryptedMessage is invalid: prefix bytes unexpected, whose hex should be: " + CryptoUtils.toHex((byte[])expectedPrefixBytes));
        }
        byte[] pureEncryptedBytes = new byte[encryptedBytes.length - prefixBytes.length];
        System.arraycopy(encryptedBytes, prefixBytes.length, pureEncryptedBytes, 0, pureEncryptedBytes.length);
        return pureEncryptedBytes;
    }

    public static String getCryptorNameFromCipher(String cipher) {
        String prefix = CryptorMetaUtil.getCipherMetaPrefix();
        if (cipher.startsWith(prefix)) {
            int indexOfPrefixLastChar = cipher.indexOf(CryptorMetaUtil.getCipherMetaSuffix());
            if (indexOfPrefixLastChar < 0) {
                return null;
            }
            return cipher.substring(prefix.length(), indexOfPrefixLastChar);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCryptorNameFromCipherStream(InputStream cipherIns) {
        String prefix = CryptorMetaUtil.getCipherMetaPrefix();
        String suffix = CryptorMetaUtil.getCipherMetaSuffix();
        int cryptorNameMaxLength = 100;
        int cipherMetaMaxLength = prefix.length() + suffix.length() + cryptorNameMaxLength;
        cipherIns = new BufferedInputStream(cipherIns);
        cipherIns.mark(cipherMetaMaxLength);
        byte[] realPrefixBytes = new byte[prefix.length()];
        try {
            int n = cipherIns.read(realPrefixBytes);
            if (n < prefix.length()) {
                log.info("Cannot find enough cipherMetaPrefix bytes: expected={}, actually={}", (Object)prefix.length(), (Object)n);
                String string = null;
                return string;
            }
            if (!Arrays.equals(realPrefixBytes, prefix.getBytes())) {
                log.info("Cannot find cipherMetaPrefix: expected={}, actually={}", (Object)Arrays.toString(prefix.getBytes()), (Object)Arrays.toString(realPrefixBytes));
                String string = null;
                return string;
            }
            byte[] cryptorNameWithSuffixBytes = new byte[cryptorNameMaxLength + suffix.length()];
            n = cipherIns.read(cryptorNameWithSuffixBytes);
            String cryptorNameWithSuffix = new String(cryptorNameWithSuffixBytes);
            int indexOfSuffix = cryptorNameWithSuffix.indexOf(suffix);
            if (indexOfSuffix == -1) {
                log.info("Cannot find cipherMetaSuffix: cryptorNameWithSuffixBytes={}, suffixBytes={}", (Object)Arrays.toString(cryptorNameWithSuffixBytes), (Object)suffix.getBytes());
                String string = null;
                return string;
            }
            String string = cryptorNameWithSuffix.substring(0, indexOfSuffix);
            return string;
        }
        catch (Exception e) {
            log.warn("Fail to read cipherMetaPrefix from cipherIns", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            try {
                cipherIns.reset();
            }
            catch (IOException e) {
                log.error("Fail to reset cipherIns", (Throwable)e);
            }
        }
    }
}

