/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.sdk.crypto.util;

import com.tencent.bk.sdk.crypto.exception.CryptoException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.Cipher;

public class RSAUtil {
    private static final String KEY_ALGORITHM = "RSA";
    private static final int DEFAULT_KEY_SIZE = 2048;

    public static KeyPair genKeyPair() {
        return RSAUtil.genKeyPair(2048);
    }

    public static KeyPair genKeyPair(int keySize) {
        KeyPairGenerator generator;
        try {
            generator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException("Fail to gen RSA key pair", e);
        }
        generator.initialize(keySize);
        return generator.generateKeyPair();
    }

    public static byte[] encryptToBytes(PublicKey publicKey, byte[] messageBytes) {
        if (messageBytes == null || messageBytes.length == 0) {
            throw new CryptoException("messageBytes is invalid: null or empty");
        }
        try {
            Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
            cipher.init(1, publicKey);
            return cipher.doFinal(messageBytes);
        }
        catch (GeneralSecurityException e) {
            throw new CryptoException("Fail to encrypt message using RSA", e);
        }
    }

    public static byte[] decryptToBytes(PrivateKey privateKey, byte[] cipherBytes) {
        if (cipherBytes == null || cipherBytes.length == 0) {
            throw new CryptoException("cipherBytes is invalid: null or empty");
        }
        try {
            Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
            cipher.init(2, privateKey);
            return cipher.doFinal(cipherBytes);
        }
        catch (GeneralSecurityException e) {
            throw new CryptoException("Fail to decrypt cipher using RSA", e);
        }
    }
}

