/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.sdk.crypto.util;

import com.tencent.bk.sdk.crypto.exception.SM2DecryptException;
import com.tencent.bk.sdk.crypto.exception.SM2EncryptException;
import com.tencent.bk.sdk.crypto.exception.SM2GenKeyPairException;
import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.crypto.KonaCryptoProvider;
import com.tencent.kona.crypto.spec.SM2PrivateKeySpec;
import com.tencent.kona.crypto.spec.SM2PublicKeySpec;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM2Util {
    private static final Logger log = LoggerFactory.getLogger(SM2Util.class);
    public static final String PROVIDER_NAME_KONA_CRYPTO = "KonaCrypto";
    private static final String ALGORITHM_SM2 = "SM2";

    public static KeyPair genKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(ALGORITHM_SM2, PROVIDER_NAME_KONA_CRYPTO);
            return keyPairGenerator.generateKeyPair();
        }
        catch (Exception e) {
            throw new SM2GenKeyPairException("Fail to gen SM2 key pair", e);
        }
    }

    public static byte[] encrypt(byte[] publicKey, byte[] message) {
        try {
            return SM2Util.doEncrypt(publicKey, message);
        }
        catch (Exception e) {
            throw new SM2EncryptException("Fail to encrypt message using SM2", e);
        }
    }

    public static byte[] encrypt(PublicKey publicKey, byte[] message) {
        try {
            return SM2Util.doEncrypt(publicKey, message);
        }
        catch (Exception e) {
            throw new SM2EncryptException("Fail to encrypt message using SM2", e);
        }
    }

    public static byte[] decrypt(byte[] privateKey, byte[] encryptedMessage) {
        try {
            return SM2Util.doDecrypt(privateKey, encryptedMessage);
        }
        catch (Exception e) {
            throw new SM2DecryptException("Fail to decrypt encryptedMessage using SM2", e);
        }
    }

    public static byte[] decrypt(PrivateKey privateKey, byte[] encryptedMessage) {
        try {
            return SM2Util.doDecrypt(privateKey, encryptedMessage);
        }
        catch (Exception e) {
            throw new SM2DecryptException("Fail to decrypt encryptedMessage using SM2", e);
        }
    }

    private static byte[] doEncrypt(byte[] publicKey, byte[] message) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_SM2, PROVIDER_NAME_KONA_CRYPTO);
        SM2PublicKeySpec pubKeySpec = new SM2PublicKeySpec(publicKey);
        PublicKey pubKey = keyFactory.generatePublic((KeySpec)pubKeySpec);
        return SM2Util.doEncrypt(pubKey, message);
    }

    private static byte[] doEncrypt(PublicKey publicKey, byte[] message) throws NoSuchProviderException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance(ALGORITHM_SM2, PROVIDER_NAME_KONA_CRYPTO);
        cipher.init(1, publicKey);
        byte[] encryptedMessage = cipher.doFinal(message);
        if (log.isDebugEnabled()) {
            log.debug("publicKey=" + CryptoUtils.toHex((byte[])publicKey.getEncoded()) + ",message=" + CryptoUtils.toHex((byte[])message) + ",encryptedMessage=" + CryptoUtils.toHex((byte[])encryptedMessage));
        }
        return encryptedMessage;
    }

    private static byte[] doDecrypt(byte[] privateKey, byte[] encryptedMessage) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_SM2, PROVIDER_NAME_KONA_CRYPTO);
        SM2PrivateKeySpec privateKeySpec = new SM2PrivateKeySpec(privateKey);
        PrivateKey priKey = keyFactory.generatePrivate((KeySpec)privateKeySpec);
        return SM2Util.doDecrypt(priKey, encryptedMessage);
    }

    private static byte[] doDecrypt(PrivateKey privateKey, byte[] encryptedMessage) throws NoSuchProviderException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance(ALGORITHM_SM2, PROVIDER_NAME_KONA_CRYPTO);
        cipher.init(2, privateKey);
        byte[] decryptedMessage = cipher.doFinal(encryptedMessage);
        if (log.isDebugEnabled()) {
            log.debug("privateKey=" + CryptoUtils.toHex((byte[])privateKey.getEncoded()) + ",encryptedMessage=" + CryptoUtils.toHex((byte[])encryptedMessage) + ",decryptedMessage=" + CryptoUtils.toHex((byte[])decryptedMessage));
        }
        return decryptedMessage;
    }

    static {
        KonaCryptoProvider konaCryptoProvider = new KonaCryptoProvider();
        if (null == Security.getProvider(konaCryptoProvider.getName())) {
            Security.addProvider((Provider)konaCryptoProvider);
        }
    }
}

