/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.sdk.crypto.util;

import com.tencent.bk.sdk.crypto.exception.SM4DecryptException;
import com.tencent.bk.sdk.crypto.exception.SM4EncryptException;
import com.tencent.bk.sdk.crypto.util.BasicCipherUtil;
import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.crypto.KonaCryptoProvider;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM4Util
extends BasicCipherUtil {
    private static final Logger log = LoggerFactory.getLogger(SM4Util.class);
    private static final String PROVIDER_NAME_KONA_CRYPTO = "KonaCrypto";
    private static final String ALGORITHM_SM4 = "SM4";
    private static final String TRANSFORMATION_SM4_CTR_NO_PADDING = "SM4/CTR/NoPadding";
    private static final int CTR_IV_LENGTH = 16;
    private static final SecureRandom random = new SecureRandom();

    public static byte[] encrypt(byte[] key, byte[] message) {
        try {
            byte[] iv = SM4Util.getRandomIv();
            byte[] cipherBytes = SM4Util.encryptWithIV(key, iv, message);
            byte[] finalBytes = new byte[cipherBytes.length + 16];
            System.arraycopy(iv, 0, finalBytes, 0, iv.length);
            System.arraycopy(cipherBytes, 0, finalBytes, iv.length, cipherBytes.length);
            return finalBytes;
        }
        catch (Exception e) {
            throw new SM4EncryptException("Fail to encrypt message using SM4", e);
        }
    }

    public static void encrypt(String key, InputStream in, OutputStream out) throws Exception {
        byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
        Cipher cipher = Cipher.getInstance(TRANSFORMATION_SM4_CTR_NO_PADDING, PROVIDER_NAME_KONA_CRYPTO);
        SecretKeySpec secretKey = new SecretKeySpec(SM4Util.paddingKey(keyBytes), ALGORITHM_SM4);
        byte[] iv = SM4Util.getRandomIv();
        IvParameterSpec paramSpec = new IvParameterSpec(iv);
        cipher.init(1, (Key)secretKey, paramSpec);
        out.write(iv);
        SM4Util.write(in, out, cipher);
    }

    private static byte[] encryptWithIV(byte[] key, byte[] iv, byte[] message) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        if (log.isDebugEnabled()) {
            log.debug("key=" + CryptoUtils.toHex((byte[])key) + ",iv=" + CryptoUtils.toHex((byte[])iv) + ",message=" + CryptoUtils.toHex((byte[])message));
        }
        SecretKeySpec secretKey = new SecretKeySpec(SM4Util.paddingKey(key), ALGORITHM_SM4);
        IvParameterSpec paramSpec = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance(TRANSFORMATION_SM4_CTR_NO_PADDING, PROVIDER_NAME_KONA_CRYPTO);
        cipher.init(1, (Key)secretKey, paramSpec);
        return cipher.doFinal(message);
    }

    private static byte[] getRandomIv() {
        byte[] iv = new byte[16];
        random.nextBytes(iv);
        return iv;
    }

    public static byte[] decrypt(byte[] key, byte[] encryptedMessageWithIV) {
        try {
            if (encryptedMessageWithIV.length < 16) {
                throw new SM4DecryptException("Unexpected encryptedMessageWithIV length:" + encryptedMessageWithIV.length);
            }
            byte[] iv = new byte[16];
            System.arraycopy(encryptedMessageWithIV, 0, iv, 0, iv.length);
            int encryptedMessageLength = encryptedMessageWithIV.length - 16;
            byte[] encryptedMessage = new byte[encryptedMessageLength];
            System.arraycopy(encryptedMessageWithIV, 16, encryptedMessage, 0, encryptedMessage.length);
            return SM4Util.decryptWithIV(key, iv, encryptedMessage);
        }
        catch (Exception e) {
            throw new SM4DecryptException("Fail to decrypt encryptedMessageWithIV using SM4", e);
        }
    }

    public static void decrypt(String key, InputStream in, OutputStream out) throws Exception {
        byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
        Cipher cipher = Cipher.getInstance(TRANSFORMATION_SM4_CTR_NO_PADDING, PROVIDER_NAME_KONA_CRYPTO);
        byte[] iv = new byte[cipher.getBlockSize()];
        if (in.read(iv) < iv.length) {
            throw new RuntimeException();
        }
        SecretKeySpec secretKey = new SecretKeySpec(SM4Util.paddingKey(keyBytes), ALGORITHM_SM4);
        cipher.init(2, (Key)secretKey, new IvParameterSpec(iv));
        SM4Util.write(in, out, cipher);
    }

    private static byte[] decryptWithIV(byte[] key, byte[] iv, byte[] encryptedMessage) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        if (log.isDebugEnabled()) {
            log.debug("key=" + CryptoUtils.toHex((byte[])key) + ",iv=" + CryptoUtils.toHex((byte[])iv) + ",encryptedMessage=" + CryptoUtils.toHex((byte[])encryptedMessage));
        }
        SecretKeySpec secretKey = new SecretKeySpec(SM4Util.paddingKey(key), ALGORITHM_SM4);
        IvParameterSpec paramSpec = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance(TRANSFORMATION_SM4_CTR_NO_PADDING, PROVIDER_NAME_KONA_CRYPTO);
        cipher.init(2, (Key)secretKey, paramSpec);
        return cipher.doFinal(encryptedMessage);
    }

    private static byte[] paddingKey(byte[] key) {
        byte[] paddedKey = new byte[16];
        int keyLength = key.length;
        for (int i = 0; i < 16; ++i) {
            paddedKey[i] = i < keyLength ? key[i] : (byte)0;
        }
        return paddedKey;
    }

    static {
        KonaCryptoProvider konaCryptoProvider = new KonaCryptoProvider();
        if (null == Security.getProvider(konaCryptoProvider.getName())) {
            Security.addProvider((Provider)konaCryptoProvider);
        }
    }
}

