/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.crashreport;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.tencent.bugly.crashreport.ReportInitializedException;
import com.tencent.bugly.crashreport.common.info.AppInfo;
import com.tencent.bugly.crashreport.common.info.a;
import com.tencent.bugly.crashreport.common.strategy.BuglyBroadcastRecevier;
import com.tencent.bugly.crashreport.common.strategy.StrategyBean;
import com.tencent.bugly.crashreport.crash.c;
import com.tencent.bugly.crashreport.crash.h5.H5JavaScriptInterface;
import com.tencent.bugly.proguard.aa;
import com.tencent.bugly.proguard.ab;
import com.tencent.bugly.proguard.ac;
import com.tencent.bugly.proguard.ae;
import com.tencent.bugly.proguard.ag;
import com.tencent.bugly.proguard.p;
import com.tencent.bugly.proguard.q;
import com.tencent.bugly.proguard.w;
import com.tencent.bugly.proguard.y;
import com.tencent.bugly.proguard.z;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CrashReport {
    private static Context a;
    private static boolean b;
    public static boolean isDebug;
    private static String c;
    private static Map<String, String> d;

    public static void enableBugly(boolean enableBugly) {
        b = enableBugly;
        if (!enableBugly) {
            CrashReport.closeCrashReport();
        }
    }

    public static synchronized void initCrashReport(Context appContext, String crashReportAppID, boolean isDebug) {
        CrashReport.initCrashReport(appContext, crashReportAppID, isDebug, null);
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized void initCrashReport(Context appContext, String crashReportAppID, boolean isDebug, UserStrategy customStrategy) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string;
        if (isDebug) {
            CrashReport.isDebug = true;
            z.a(new ac());
            z.d("Bugly debug\u6a21\u5f0f\u5f00\u542f\uff0c\u8bf7\u5728\u53d1\u5e03\u65f6\u628aisDebug\u5173\u95ed\u3002 -- 'isDebug' is enabled. Now is running in debug model, please disable it when you release.", new Object[0]);
            z.e("--------------------------------------------------------------------------------------------", new Object[0]);
            z.d("Bugly debug\u6a21\u5f0f\u5c06\u6709\u4ee5\u4e0b\u884c\u4e3a\u7279\u6027 -- The following list shows the behaviour of debug model: ", new Object[0]);
            z.d("[1] \u8f93\u51fa\u8be6\u7ec6\u7684Bugly SDK\u7684Log -- More detailed log of Bugly SDK will be output to logcat;", new Object[0]);
            z.d("[2] \u6bcf\u4e00\u6761Crash\u90fd\u4f1a\u88ab\u7acb\u5373\u4e0a\u62a5 -- Every crash caught by Bugly will be uploaded immediately.", new Object[0]);
            z.d("[3] \u81ea\u5b9a\u4e49\u65e5\u5fd7\u5c06\u4f1a\u5728Logcat\u4e2d\u8f93\u51fa -- Custom log will be output to logcat.", new Object[0]);
            z.e("--------------------------------------------------------------------------------------------", new Object[0]);
            z.b("[init] bugly in debug mode.", new Object[0]);
        }
        if (customStrategy == null || customStrategy.j) {
            ab.a(appContext);
            z.a("BuglyLog is inited.", new Object[0]);
        }
        if (a != null) {
            z.d("already inited ! nothing to do !", new Object[0]);
            return;
        }
        Context context = appContext;
        a = appContext = ag.a(appContext);
        if (appContext == null) {
            throw new ReportInitializedException("init arg 'appContext' should not be null!");
        }
        z.b("your appid is set to: %s", crashReportAppID);
        a a2 = com.tencent.bugly.crashreport.common.info.a.a(appContext);
        CrashReport.a(appContext, a2);
        List<String> list = a2.H();
        String string2 = string = a2.i().equals("") ? "bugly" : a2.i();
        if (list != null && list.contains(string)) {
            z.a("[init] bugly(%s) is closed.", string);
            b = false;
            return;
        }
        if (list != null && list.size() > 0) {
            for (String object62 : list) {
                z.a("[Configuration] channel disabled: " + object62, new Object[0]);
            }
        }
        z.a(a2.i() + " crash report start init!", new Object[0]);
        z.b("[init] bugly start init...", new Object[0]);
        if (crashReportAppID == null) {
            throw new ReportInitializedException("init arg 'crashReportAppID' should not be null!");
        }
        a2.a(crashReportAppID);
        z.a("setted APPID:%s", crashReportAppID);
        if (customStrategy != null) {
            void var9_14;
            String string3;
            object5 = customStrategy.a;
            if (!TextUtils.isEmpty((CharSequence)object5)) {
                if (((String)object5).length() > 100) {
                    String string4 = ((String)object5).substring(0, 100);
                    z.d("appVersion %s length is over limit %d substring to %s", object5, 100, string4);
                    object5 = string4;
                }
                a2.c((String)object5);
                z.a("setted APPVERSION:%s", customStrategy.a);
            }
            if (!TextUtils.isEmpty((CharSequence)(string3 = customStrategy.b))) {
                if (string3.length() > 100) {
                    object4 = string3.substring(0, 100);
                    z.d("appChannel %s length is over limit %d substring to %s", string3, 100, object4);
                    Object object6 = object4;
                }
                a2.g((String)var9_14);
                z.a("setted APPCHANNEL:%s", customStrategy.b);
            }
            if (!TextUtils.isEmpty((CharSequence)(object4 = customStrategy.c))) {
                if (((String)object4).length() > 100) {
                    object3 = ((String)object4).substring(0, 100);
                    z.d("appPackageName %s length is over limit %d substring to %s", object4, 100, object3);
                    object4 = object3;
                }
                a2.b((String)object4);
                z.a("setted PACKAGENAME:%s", customStrategy.c);
            }
            if (!TextUtils.isEmpty((CharSequence)(object3 = customStrategy.e))) {
                a2.h((String)object3);
                z.a("setted libBugly.so file path :%s", object3);
            }
            if ((object2 = customStrategy.f) != null) {
                if (((String)object2).length() > 100) {
                    object = ((String)object2).substring(0, 100);
                    z.d("deviceId %s length is over limit %d substring to %s", var9_14, 100, object);
                    object2 = object;
                }
                a2.e((String)object2);
                z.a("setted deviceId :%s", object2);
            }
        }
        p.a().a(a);
        object5 = y.a();
        q q2 = q.a(appContext);
        object4 = w.a(appContext, (y)object5, a2, q2);
        object3 = com.tencent.bugly.crashreport.common.strategy.c.a(appContext, a2, new StrategyBean(), q.a(appContext), (w)object4, (y)object5);
        if (customStrategy != null && customStrategy.d > 0L) {
            p.a().a(customStrategy.d);
            z.a("setted APP_REPORT_DELAY %d", customStrategy.d);
        } else {
            p.a().a(0L);
        }
        object2 = null;
        if (customStrategy != null && customStrategy.getCrashHandleCallback() != null) {
            object2 = customStrategy.getCrashHandleCallback();
            z.a("setted CrashHanldeCallback", new Object[0]);
        }
        object = com.tencent.bugly.crashreport.crash.c.a(appContext, q2, (com.tencent.bugly.crashreport.common.strategy.c)object3, (w)object4, a2, (y)object5, isDebug, (CrashHandleCallback)object2);
        ((c)object).d();
        if (customStrategy == null || customStrategy.isEnableNativeCrashMonitor()) {
            ((c)object).f();
        } else {
            z.a("closed native!", new Object[0]);
            ((c)object).e();
        }
        ((c)object).g();
        BuglyBroadcastRecevier buglyBroadcastRecevier = BuglyBroadcastRecevier.getInstance();
        buglyBroadcastRecevier.addFilter("android.net.conn.CONNECTIVITY_CHANGE");
        buglyBroadcastRecevier.regist(appContext);
        CrashReport.a(a2);
        z.a("crash report inited!", new Object[0]);
        z.b("[init] bugly init finished.", new Object[0]);
    }

    private static void a(a a2) {
        String string;
        String string2;
        Class<?> clazz;
        try {
            clazz = Class.forName("com.tencent.bugly.unity.UnityAgent");
            string2 = "com.tencent.bugly";
            string = a2.i();
            if (!"".equals(string)) {
                string2 = string2 + "." + string;
            }
            ae.a(clazz, "sdkPackageName", string2, null);
        }
        catch (Throwable throwable) {
            z.a("no unity agent", new Object[0]);
        }
        try {
            clazz = Class.forName("com.tencent.bugly.cococs.Cocos2dxAgent");
            string2 = "com.tencent.bugly";
            string = a2.i();
            if (!"".equals(string)) {
                string2 = string2 + "." + string;
            }
            ae.a(clazz, "sdkPackageName", string2, null);
        }
        catch (Throwable throwable) {
            z.a("no cocos agent", new Object[0]);
        }
    }

    private static void a(Context context, a a2) {
        List<String> list = a2.I();
        StringBuilder stringBuilder = null;
        if (list == null || list.size() == 0) {
            z.a("not have bugly channel version", new Object[0]);
            return;
        }
        if (list.size() == 1) {
            return;
        }
        stringBuilder = new StringBuilder(16).append(list.get(1));
        for (int i2 = 2; i2 < list.size(); ++i2) {
            stringBuilder.append(",").append(list.get(i2));
        }
        List<String> list2 = a2.H();
        if (!CrashReport.a(list, list2)) {
            String string = String.format("# BUGLY CRASH REPORTER EXISTS IN MULTIPLE SDK. FOR MORE EFFICIENCY, \n# PLEASE SET <meta-data> IN [AndroidManifest.xml]:\n# <application>\n# ...\n#     <meta-data android:name=\"BUGLY_DISABLE\" android:value=\"%s\"/>\n# ...\n# </application>\n# FOR MORE INFOMATION, VISIT:\n# http://bugly.qq.com/androidsdk", stringBuilder);
            String string2 = String.format("# \u60a8\u7684App\u4e2d\u542b\u6709\u591a\u4e2a\u5f02\u5e38\u4e0a\u62a5\u6a21\u5757\uff0c\u4e3a\u4e86\u8282\u7701\u60a8\u7684\u8d44\u6e90\uff0c\n# \u8bf7\u5728[AndroidManifest.xml]\u4e2d\u6dfb\u52a0meta-data\u914d\u7f6e\uff1a[AndroidManifest.xml]:\n# <application>\n# ...\n#     <meta-data android:name=\"BUGLY_DISABLE\" android:value=\"%s\"/>\n# ...\n# </application>\n# \u66f4\u591a\u4fe1\u606f\u8bf7\u53c2\u89c1\uff1a\n# http://bugly.qq.com/androidsdk", stringBuilder);
            z.d("--------------------------BUGLY TIPS--------------------------", new Object[0]);
            z.d(string, new Object[0]);
            z.d("--------------------------------------------------------------", new Object[0]);
            z.d(string2, new Object[0]);
            z.d("--------------------------------------------------------------", new Object[0]);
        }
    }

    private static boolean a(List<String> list, List<String> list2) {
        if (list2 == null || list2.size() == 0) {
            return false;
        }
        int n2 = 0;
        for (String string : list2) {
            if (!list.contains(string)) continue;
            ++n2;
        }
        return n2 >= list.size() - 1;
    }

    public static synchronized String getAppID() {
        if (!b) {
            return "unknown";
        }
        if (a == null) {
            throw new ReportInitializedException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
        return com.tencent.bugly.crashreport.common.info.a.a(a).d();
    }

    public static String getBuglyVersion(Context context) {
        if (context == null) {
            z.d("Please call with context.", new Object[0]);
            return "unknown";
        }
        a a2 = com.tencent.bugly.crashreport.common.info.a.a(context);
        return a2.h();
    }

    public static void setIsAppForeground(boolean isAppForeground) {
        if (isAppForeground) {
            z.c("App is in foreground.", new Object[0]);
        } else {
            z.c("App is in background.", new Object[0]);
        }
        AppInfo.a(isAppForeground);
    }

    public static synchronized void setUserId(String userId) {
        Object object;
        if (!b) {
            Log.w((String)"CrashReport", (String)"Can not set user ID because bugly is disable.");
            return;
        }
        if (a == null) {
            throw new ReportInitializedException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
        if (userId != null && ((String)userId).length() > 100) {
            object = ((String)userId).substring(0, 100);
            z.d("userId %s length is over limit %d substring to %s", userId, 100, object);
            userId = object;
        }
        com.tencent.bugly.crashreport.common.info.a.a(a).d((String)userId);
        z.b("[param] set userId : %s", userId);
        object = com.tencent.bugly.crashreport.common.strategy.c.a();
        ((com.tencent.bugly.crashreport.common.strategy.c)object).f();
    }

    public static synchronized String getUserId() {
        if (!b) {
            return "unknown";
        }
        if (a == null) {
            throw new ReportInitializedException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
        return com.tencent.bugly.crashreport.common.info.a.a(a).m();
    }

    public static synchronized String getAppVer() {
        if (!b) {
            Log.w((String)"CrashReport", (String)"Can not get app version because bugly is disable.");
            return "unknown";
        }
        if (a == null) {
            throw new ReportInitializedException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
        return com.tencent.bugly.crashreport.common.info.a.a(a).e();
    }

    public static synchronized String getAppChannel() {
        if (!b) {
            return "unknown";
        }
        if (!b) {
            return null;
        }
        if (a == null) {
            throw new ReportInitializedException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
        return com.tencent.bugly.crashreport.common.info.a.a(a).B();
    }

    public static synchronized boolean isLastSessionCrash() {
        if (!b) {
            Log.w((String)"CrashReport", (String)"The info isLastSessionCrash is not accurate because bugly is disable.");
            return false;
        }
        if (a == null) {
            throw new ReportInitializedException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
        return com.tencent.bugly.crashreport.crash.c.a().b();
    }

    public static synchronized void testJavaCrash() {
        if (!b) {
            z.d("Can not test Java crash because bugly is disable.", new Object[0]);
            return;
        }
        z.d("Test java crash...", new Object[0]);
        if (a == null) {
            throw new ReportInitializedException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
        throw new RuntimeException("This Crash create for Test! You can go to Bugly see more detail!");
    }

    public static synchronized void testNativeCrash() {
        if (!b) {
            Log.w((String)"CrashReport", (String)"Can not test native crash because bugly is disable.");
            return;
        }
        if (a == null) {
            throw new ReportInitializedException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
        z.a("start to create a native crash for test!", new Object[0]);
        com.tencent.bugly.crashreport.crash.c.a().j();
    }

    public static synchronized void testANRCrash() {
        if (!b) {
            Log.w((String)"CrashReport", (String)"Can not test ANR crash because bugly is disable.");
            return;
        }
        if (a == null) {
            throw new ReportInitializedException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
        z.a("start to create a anr crash for test!", new Object[0]);
        com.tencent.bugly.crashreport.crash.c.a().k();
    }

    public static synchronized void postCatchedException(Throwable catchedThrowable) {
        if (!b) {
            Log.w((String)"CrashReport", (String)"Can not post crash caught because bugly is disable.");
            return;
        }
        if (a == null) {
            throw new ReportInitializedException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
        com.tencent.bugly.crashreport.crash.c.a().a(Thread.currentThread(), catchedThrowable, false);
    }

    public static synchronized void closeNativeReport() {
        if (!b) {
            return;
        }
        if (a == null) {
            throw new ReportInitializedException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
        com.tencent.bugly.crashreport.crash.c.a().e();
    }

    public static synchronized void closeCrashReport() {
        if (!b) {
            return;
        }
        if (a == null) {
            return;
        }
        com.tencent.bugly.crashreport.crash.c.a().i();
    }

    public static void setUserSceneTag(Context context, int tagId) {
        if (!b) {
            Log.w((String)"CrashReport", (String)"Can not set tag caught because bugly is disable.");
            return;
        }
        if (context == null) {
            throw new ReportInitializedException("setTag args context should not be null");
        }
        if (tagId <= 0) {
            throw new ReportInitializedException("setTag args tagId should > 0");
        }
        com.tencent.bugly.crashreport.common.info.a.a(context).a(tagId);
        z.b("[param] set user scene tag: %d", tagId);
    }

    public static int getUserSceneTagId(Context context) {
        if (!b) {
            return -1;
        }
        if (context == null) {
            throw new ReportInitializedException("getUserSceneTagId args context should not be null");
        }
        return com.tencent.bugly.crashreport.common.info.a.a(context).N();
    }

    public static String getUserData(Context context, String key) {
        if (!b) {
            return "unknown";
        }
        if (context == null) {
            throw new ReportInitializedException("getUserDataValue args context should not be null");
        }
        if (ag.b(key)) {
            return null;
        }
        return com.tencent.bugly.crashreport.common.info.a.a(context).k(key);
    }

    public static void putUserData(Context context, String key, String value) {
        a a2;
        if (!b) {
            Log.w((String)"CrashReport", (String)"Can not put user data because bugly is disable.");
            return;
        }
        if (context == null) {
            throw new ReportInitializedException("putUserData args context should not be null");
        }
        if (ag.b(key)) {
            throw new ReportInitializedException("putUserData args key should not be null");
        }
        if (ag.b(value)) {
            z.d("putUserData args value should not be null", new Object[0]);
            return;
        }
        if (!key.matches("[a-zA-Z[0-9]]+")) {
            throw new ReportInitializedException("putUserData args key should match [a-zA-Z[0-9]]+  {" + key + "}");
        }
        if (value.length() > 200) {
            z.d("user data value length over limit %d , has been cutted!", 200);
            value = value.substring(0, 200);
        }
        if ((a2 = com.tencent.bugly.crashreport.common.info.a.a(context)).L().contains(key)) {
            com.tencent.bugly.crashreport.common.info.a.a(context).a(key, value);
            z.c("replace KV %s %s", key, value);
            return;
        }
        if (a2.K() >= 10) {
            z.d("user data size is over limit %d , will drop this new key %s", 10, key);
            return;
        }
        if (key.length() > 50) {
            z.d("user data key length over limit %d , will drop this new key %s", 50, key);
            return;
        }
        com.tencent.bugly.crashreport.common.info.a.a(context).a(key, value);
        z.b("[param] set user data: %s - %s", key, value);
    }

    public static synchronized void setSdkExtraData(Context context, String sdkId, String version) {
        if (!b) {
            Log.w((String)"CrashReport", (String)"Can not put SDK extra data because bugly is disable.");
            return;
        }
        if (context == null || ag.b(sdkId) || ag.b(version)) {
            return;
        }
        if (d == null) {
            d = new HashMap<String, String>();
        }
        d.put(sdkId, version);
        if (d.size() > 0) {
            String string = "SDK_INFO";
            String string2 = "";
            for (Map.Entry<String, String> entry : d.entrySet()) {
                string2 = string2 + "[" + entry.getKey() + "," + entry.getValue() + "] ";
            }
            CrashReport.a(context, string, string2);
        }
    }

    public static Map<String, String> getSdkExtraData() {
        if (!b) {
            return new HashMap<String, String>();
        }
        return d;
    }

    private static void a(Context context, String string, String string2) {
        if (context == null || ag.b(string) || ag.b(string2)) {
            return;
        }
        if ((string = string.replace("[a-zA-Z[0-9]]+", "")).length() > 50) {
            Log.w((String)"CrashReport", (String)String.format("putSdkData key length over limit %d , will drop this new key %s", 50, string));
            return;
        }
        if (string2.length() > 200) {
            Log.w((String)"CrashReport", (String)String.format("putSdkData value length over limit %d , has been cutted!", 200));
            string2 = string2.substring(0, 200);
        }
        com.tencent.bugly.crashreport.common.info.a.a(context).b(string, string2);
        Log.w((String)"CrashReportInfo", (String)String.format("[param] putSdkData data: %s - %s", string, string2));
    }

    public static String removeUserData(Context context, String dataKey) {
        if (!b) {
            Log.w((String)"CrashReport", (String)"Can not remove user data because bugly is disable.");
            return "unknown";
        }
        if (context == null) {
            throw new ReportInitializedException("removeUserData args context should not be null");
        }
        if (ag.b(dataKey)) {
            return null;
        }
        z.b("[param] remove user data: %s", dataKey);
        return com.tencent.bugly.crashreport.common.info.a.a(context).j(dataKey);
    }

    public static Set<String> getAllUserDataKeys(Context context) {
        if (!b) {
            Log.w((String)"CrashReport", (String)"Can not get all keys of user data because bugly is disable.");
            return new HashSet<String>();
        }
        if (context == null) {
            throw new ReportInitializedException("getAllUserDataKeys args context should not be null");
        }
        return com.tencent.bugly.crashreport.common.info.a.a(context).L();
    }

    public static int getUserDatasSize(Context context) {
        if (!b) {
            Log.w((String)"CrashReport", (String)"Can not get size of user data because bugly is disable.");
            return -1;
        }
        if (context == null) {
            throw new ReportInitializedException("getUserDatasSize args context should not be null");
        }
        return com.tencent.bugly.crashreport.common.info.a.a(context).K();
    }

    public static boolean setJavascriptMonitor(WebView webView, boolean autoInject) {
        return CrashReport.setJavascriptMonitor(webView, autoInject, false);
    }

    public static boolean setJavascriptMonitor(WebView webView, boolean autoInject, boolean force) {
        H5JavaScriptInterface h5JavaScriptInterface;
        int n2;
        if (!b) {
            Log.w((String)"CrashReport", (String)"Can not set JavaScript monitor because bugly is disable.");
            return false;
        }
        if (webView.getUrl() == null) {
            return false;
        }
        if (c != null && c.equals(webView.getUrl())) {
            return true;
        }
        c = webView.getUrl();
        if (!force && (n2 = Build.VERSION.SDK_INT) < 19) {
            z.e("This interface is only available for Android 4.4 or later.", new Object[0]);
            return false;
        }
        z.a("Set webview monitor.", new Object[0]);
        WebSettings webSettings = webView.getSettings();
        if (!webSettings.getJavaScriptEnabled()) {
            z.a("Enable the javascript needed by webview monitor.", new Object[0]);
            webSettings.setJavaScriptEnabled(true);
        }
        if ((h5JavaScriptInterface = H5JavaScriptInterface.getInstance(webView)) != null) {
            z.a("Add a secure javascript interface to the webview.", new Object[0]);
            webView.addJavascriptInterface((Object)h5JavaScriptInterface, "exceptionUploader");
        }
        if (autoInject) {
            if (a == null) {
                z.e("CrashReport has not been initialed! please to call method 'initCrashReport' first!", new Object[0]);
                return false;
            }
            z.a("Inject bugly.js(v%s) to the webview.", aa.b());
            String string = aa.a();
            webView.loadUrl("javascript:" + string);
        }
        return true;
    }

    static {
        b = true;
        c = null;
        d = null;
    }

    public static class CrashHandleCallback {
        public static final int MAX_USERDATA_KEY_LENGTH = 100;
        public static final int MAX_USERDATA_VALUE_LENGTH = 30000;
        public static final int CRASHTYPE_JAVA_CRASH = 0;
        public static final int CRASHTYPE_JAVA_CATCH = 1;
        public static final int CRASHTYPE_NATIVE = 2;
        public static final int CRASHTYPE_U3D = 3;
        public static final int CRASHTYPE_ANR = 4;
        public static final int CRASHTYPE_COCOS2DX_JS = 5;
        public static final int CRASHTYPE_COCOS2DX_LUA = 6;

        public synchronized Map<String, String> onCrashHandleStart(int crashType, String errorType, String errorMessage, String errorStack) {
            return null;
        }

        public synchronized byte[] onCrashHandleStart2GetExtraDatas(int crashType, String errorType, String errorMessage, String errorStack) {
            return null;
        }
    }

    public static class UserStrategy {
        private String a;
        private String b;
        private String c;
        private long d;
        private String e;
        private String f;
        private CrashHandleCallback g;
        private boolean h = true;
        private boolean i = true;
        private boolean j = true;

        public UserStrategy(Context context) {
            context = ag.a(context);
            a a2 = com.tencent.bugly.crashreport.common.info.a.a(context);
            this.a = a2.e();
            this.b = a2.B();
            this.c = a2.f();
            this.e = null;
            this.d = 0L;
        }

        public synchronized void setBuglyLogUpload(boolean isBuglyLogUpload) {
            this.j = isBuglyLogUpload;
        }

        public synchronized boolean isBuglyLogUpload() {
            return this.j;
        }

        public synchronized String getAppVersion() {
            return this.a;
        }

        public synchronized UserStrategy setAppVersion(String appVersion) {
            this.a = appVersion;
            return this;
        }

        public synchronized String getAppChannel() {
            return this.b;
        }

        public synchronized UserStrategy setAppChannel(String appChannel) {
            this.b = appChannel;
            return this;
        }

        public synchronized String getAppPackageName() {
            return this.c;
        }

        public synchronized UserStrategy setAppPackageName(String appPackageName) {
            this.c = appPackageName;
            return this;
        }

        public synchronized long getAppReportDelay() {
            return this.d;
        }

        public synchronized UserStrategy setAppReportDelay(long appReportDelay) {
            this.d = appReportDelay;
            return this;
        }

        public synchronized String getLibBuglySOFilePath() {
            return this.e;
        }

        public synchronized void setLibBuglySOFilePath(String customerBuglySOFilePath) {
            this.e = customerBuglySOFilePath;
        }

        public synchronized String getDeviceID() {
            return this.f;
        }

        public synchronized void setDeviceID(String deviceID) {
            this.f = deviceID;
        }

        public synchronized CrashHandleCallback getCrashHandleCallback() {
            return this.g;
        }

        public synchronized void setCrashHandleCallback(CrashHandleCallback crashHandleCallback) {
            this.g = crashHandleCallback;
        }

        public synchronized boolean isEnableNativeCrashMonitor() {
            return this.h;
        }

        public synchronized void setEnableNativeCrashMonitor(boolean enableNativeCrashMonitor) {
            this.h = enableNativeCrashMonitor;
        }

        public synchronized boolean isEnableANRCrashMonitor() {
            return this.i;
        }

        public synchronized void setEnableANRCrashMonitor(boolean enableANRCrashMonitor) {
            this.i = enableANRCrashMonitor;
        }
    }
}

