/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.crashreport;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.webkit.WebView;
import com.tencent.bugly.Bugly;
import com.tencent.bugly.BuglyStrategy;
import com.tencent.bugly.CrashModule;
import com.tencent.bugly.crashreport.BuglyHintException;
import com.tencent.bugly.crashreport.biz.b;
import com.tencent.bugly.crashreport.common.info.a;
import com.tencent.bugly.crashreport.crash.h5.H5JavaScriptInterface;
import com.tencent.bugly.crashreport.crash.h5.c;
import com.tencent.bugly.crashreport.crash.jni.NativeCrashHandler;
import com.tencent.bugly.proguard.u;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CrashReport {
    private static Context a;
    private static Map<String, String> b;

    public static void enableBugly(boolean bl) {
        Bugly.enable = bl;
        if (!bl) {
            CrashReport.closeCrashReport();
        }
    }

    public static synchronized void initCrashReport(Context context) {
        a = context;
        com.tencent.bugly.b.a(context);
    }

    public static synchronized void initCrashReport(Context context, UserStrategy userStrategy) {
        a = context;
        com.tencent.bugly.b.a(context, userStrategy);
    }

    public static synchronized void initCrashReport(Context context, String string, boolean bl) {
        CrashReport.initCrashReport(context, string, bl, null);
    }

    public static synchronized void initCrashReport(Context context, String string, boolean bl, UserStrategy userStrategy) {
        if (context == null) {
            return;
        }
        a = context;
        com.tencent.bugly.b.a(context, string, bl, userStrategy);
    }

    public static String getBuglyVersion(Context context) {
        if (context == null) {
            u.d("Please call with context.", new Object[0]);
            return "unknown";
        }
        com.tencent.bugly.crashreport.common.info.a.a(context);
        return com.tencent.bugly.crashreport.common.info.a.b();
    }

    public static synchronized void testJavaCrash() {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not test Java crash because bugly is disable.");
            return;
        }
        if (!CrashModule.hasInitialized()) {
            throw new BuglyHintException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
        throw new RuntimeException("This Crash create for Test! You can go to Bugly see more detail!");
    }

    public static synchronized void testNativeCrash() {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not test native crash because bugly is disable.");
            return;
        }
        if (!CrashModule.hasInitialized()) {
            throw new BuglyHintException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
        u.a("start to create a native crash for test!", new Object[0]);
        com.tencent.bugly.crashreport.crash.c.a().j();
    }

    public static synchronized void testANRCrash() {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not test ANR crash because bugly is disable.");
            return;
        }
        if (!CrashModule.hasInitialized()) {
            throw new BuglyHintException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
        u.a("start to create a anr crash for test!", new Object[0]);
        com.tencent.bugly.crashreport.crash.c.a().k();
    }

    public static synchronized void postCatchedException(Throwable throwable) {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not post crash caught because bugly is disable.");
            return;
        }
        if (!CrashModule.hasInitialized()) {
            throw new BuglyHintException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
        if (throwable == null) {
            u.d("throwable is null, just return", new Object[0]);
            return;
        }
        com.tencent.bugly.crashreport.crash.c.a().a(Thread.currentThread(), throwable, false, null, null);
    }

    public static synchronized void closeNativeReport() {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not close native report because bugly is disable.");
            return;
        }
        if (!CrashModule.hasInitialized()) {
            throw new BuglyHintException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
        com.tencent.bugly.crashreport.crash.c.a().f();
    }

    public static synchronized void startCrashReport() {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not start crash report because bugly is disable.");
            return;
        }
        if (!CrashModule.hasInitialized()) {
            Log.w((String)u.b, (String)"Report has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        com.tencent.bugly.crashreport.crash.c.a().c();
    }

    public static synchronized void closeCrashReport() {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not close crash report because bugly is disable.");
            return;
        }
        if (!CrashModule.hasInitialized()) {
            Log.w((String)u.b, (String)"Report has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        com.tencent.bugly.crashreport.crash.c.a().d();
    }

    public static void setUserSceneTag(Context context, int n2) {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not set tag caught because bugly is disable.");
            return;
        }
        if (context == null) {
            throw new BuglyHintException("setTag args context should not be null");
        }
        if (n2 <= 0) {
            u.d("setTag args tagId should > 0", new Object[0]);
        }
        com.tencent.bugly.crashreport.common.info.a.a(context).a(n2);
        u.b("[param] set user scene tag: %d", n2);
    }

    public static int getUserSceneTagId(Context context) {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not get user scene tag because bugly is disable.");
            return -1;
        }
        if (context == null) {
            throw new BuglyHintException("getUserSceneTagId args context should not be null");
        }
        return com.tencent.bugly.crashreport.common.info.a.a(context).A();
    }

    public static String getUserData(Context context, String string) {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not get user data because bugly is disable.");
            return "unknown";
        }
        if (context == null) {
            throw new BuglyHintException("getUserDataValue args context should not be null");
        }
        String string2 = string;
        if (string2 == null || string2.trim().length() <= 0) {
            return null;
        }
        return com.tencent.bugly.crashreport.common.info.a.a(context).g(string);
    }

    public static void putUserData(Context context, String string, String string2) {
        Object object;
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not put user data because bugly is disable.");
            return;
        }
        if (context == null) {
            Log.w((String)u.b, (String)"putUserData args context should not be null");
            return;
        }
        if (string == null) {
            u.d("putUserData args key should not be null or empty", new Object[0]);
            return;
        }
        if (string2 == null) {
            u.d("putUserData args value should not be null", new Object[0]);
            return;
        }
        if (!string.matches("[a-zA-Z[0-9]]+")) {
            u.d("putUserData args key should match [a-zA-Z[0-9]]+  {" + string + "}", new Object[0]);
            return;
        }
        if (string2.length() > 200) {
            u.d("user data value length over limit %d, it will be cutted!", 200);
            string2 = string2.substring(0, 200);
        }
        if (((a)(object = com.tencent.bugly.crashreport.common.info.a.a(context))).y().contains(string)) {
            object = NativeCrashHandler.getInstance();
            if (object != null) {
                ((NativeCrashHandler)object).putKeyValueToNative(string, string2);
            }
            com.tencent.bugly.crashreport.common.info.a.a(context).a(string, string2);
            u.c("replace KV %s %s", string, string2);
            return;
        }
        if (((a)object).x() >= 10) {
            u.d("user data size is over limit %d, it will be cutted!", 10);
            return;
        }
        if (string.length() > 50) {
            u.d("user data key length over limit %d , will drop this new key %s", 50, string);
            string = string.substring(0, 50);
        }
        if ((object = NativeCrashHandler.getInstance()) != null) {
            ((NativeCrashHandler)object).putKeyValueToNative(string, string2);
        }
        com.tencent.bugly.crashreport.common.info.a.a(context).a(string, string2);
        u.b("[param] set user data: %s - %s", string, string2);
    }

    public static String removeUserData(Context context, String string) {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not remove user data because bugly is disable.");
            return "unknown";
        }
        if (context == null) {
            throw new BuglyHintException("removeUserData args context should not be null");
        }
        String string2 = string;
        if (string2 == null || string2.trim().length() <= 0) {
            return null;
        }
        u.b("[param] remove user data: %s", string);
        return com.tencent.bugly.crashreport.common.info.a.a(context).f(string);
    }

    public static Set<String> getAllUserDataKeys(Context context) {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not get all keys of user data because bugly is disable.");
            return new HashSet<String>();
        }
        if (context == null) {
            throw new BuglyHintException("getAllUserDataKeys args context should not be null");
        }
        return com.tencent.bugly.crashreport.common.info.a.a(context).y();
    }

    public static int getUserDatasSize(Context context) {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not get size of user data because bugly is disable.");
            return -1;
        }
        if (context == null) {
            throw new BuglyHintException("getUserDatasSize args context should not be null");
        }
        return com.tencent.bugly.crashreport.common.info.a.a(context).x();
    }

    public static synchronized String getAppID() {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not get App ID because bugly is disable.");
            return "unknown";
        }
        if (!CrashModule.hasInitialized()) {
            throw new BuglyHintException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
        return com.tencent.bugly.crashreport.common.info.a.a(a).e();
    }

    public static void setUserId(String string) {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not set user ID because bugly is disable.");
            return;
        }
        if (!CrashModule.hasInitialized()) {
            throw new BuglyHintException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
        if (string == null) {
            u.d("userId should not be null", new Object[0]);
            return;
        }
        if (string.length() > 100) {
            String string2 = string.substring(0, 100);
            u.d("userId %s length is over limit %d substring to %s", string, 100, string2);
            string = string2;
        }
        if (string.equals(com.tencent.bugly.crashreport.common.info.a.a(a).f())) {
            return;
        }
        com.tencent.bugly.crashreport.common.info.a.a(a).b(string);
        u.b("[user] set userId : %s", string);
        com.tencent.bugly.crashreport.biz.b.a();
    }

    public static synchronized String getUserId() {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not get user ID because bugly is disable.");
            return "unknown";
        }
        if (!CrashModule.hasInitialized()) {
            throw new BuglyHintException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
        return com.tencent.bugly.crashreport.common.info.a.a(a).f();
    }

    public static synchronized String getAppVer() {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not get app version because bugly is disable.");
            return "unknown";
        }
        if (!CrashModule.hasInitialized()) {
            throw new BuglyHintException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
        return com.tencent.bugly.crashreport.common.info.a.a((Context)CrashReport.a).i;
    }

    public static synchronized String getAppChannel() {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not get App channel because bugly is disable.");
            return "unknown";
        }
        if (!CrashModule.hasInitialized()) {
            throw new BuglyHintException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
        return com.tencent.bugly.crashreport.common.info.a.a((Context)CrashReport.a).j;
    }

    public static synchronized void setContext(Context context) {
        a = context;
    }

    public static synchronized boolean isLastSessionCrash() {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"The info 'isLastSessionCrash' is not accurate because bugly is disable.");
            return false;
        }
        if (!CrashModule.hasInitialized()) {
            throw new BuglyHintException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
        return com.tencent.bugly.crashreport.crash.c.a().b();
    }

    public static synchronized void setSdkExtraData(Context context, String string, String string2) {
        Object object;
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not put SDK extra data because bugly is disable.");
            return;
        }
        if (context == null || (object = string) == null || ((String)object).trim().length() <= 0 || (object = string2) == null || ((String)object).trim().length() <= 0) {
            return;
        }
        if (b == null) {
            b = new HashMap<String, String>();
        }
        b.put(string, string2);
        if (b.size() > 0) {
            string = "SDK_INFO";
            string2 = "";
            for (Map.Entry entry : b.entrySet()) {
                string2 = string2 + "[" + (String)entry.getKey() + "," + (String)entry.getValue() + "] ";
            }
            CrashReport.putSdkData(context, string, string2);
        }
    }

    public static Map<String, String> getSdkExtraData() {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not get SDK extra data because bugly is disable.");
            return new HashMap<String, String>();
        }
        return b;
    }

    private static void putSdkData(Context context, String string, String string2) {
        String string3;
        if (context == null || (string3 = string) == null || string3.trim().length() <= 0 || (string3 = string2) == null || string3.trim().length() <= 0) {
            return;
        }
        if ((string = string.replace("[a-zA-Z[0-9]]+", "")).length() > 50) {
            Log.w((String)u.b, (String)String.format("putSdkData key length over limit %d, will be cutted.", 50));
            string = string.substring(0, 50);
        }
        if (string2.length() > 200) {
            Log.w((String)u.b, (String)String.format("putSdkData value length over limit %d, will be cutted!", 200));
            string2 = string2.substring(0, 200);
        }
        com.tencent.bugly.crashreport.common.info.a.a(context).b(string, string2);
        Log.w((String)u.a, (String)String.format("[param] putSdkData data: %s - %s", string, string2));
    }

    public static void setIsAppForeground(Context context, boolean bl) {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not set 'isAppForeground' because bugly is disable.");
            return;
        }
        if (context == null) {
            u.d("Context should not be null.", new Object[0]);
            return;
        }
        if (bl) {
            u.c("App is in foreground.", new Object[0]);
        } else {
            u.c("App is in background.", new Object[0]);
        }
        com.tencent.bugly.crashreport.common.info.a.a((Context)context).n = bl;
    }

    public static void setSessionIntervalMills(long l2) {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not set 'SessionIntervalMills' because bugly is disable.");
            return;
        }
        com.tencent.bugly.crashreport.biz.b.a(l2);
    }

    public static void setAppVersion(Context context, String string) {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not set APP version because bugly is disable.");
            return;
        }
        if (context == null) {
            Log.w((String)u.b, (String)"setAppVersion args context should not be null");
            return;
        }
        if (string == null) {
            Log.w((String)u.b, (String)"Version is null, will not set");
            return;
        }
        com.tencent.bugly.crashreport.common.info.a.a((Context)context).i = string;
    }

    public static boolean setJavascriptMonitor(WebView webView, boolean bl) {
        return CrashReport.setJavascriptMonitor(webView, bl, false);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public static boolean setJavascriptMonitor(WebView webView, boolean bl, boolean n2) {
        if (webView == null) {
            Log.w((String)u.b, (String)"Webview is null.");
            return false;
        }
        if (!CrashModule.hasInitialized()) {
            u.e("CrashReport has not been initialed! please to call method 'initCrashReport' first!", new Object[0]);
            return false;
        }
        u.a("Set Javascript exception monitor of webview.", new Object[0]);
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not set JavaScript monitor because bugly is disable.");
            return false;
        }
        u.c("URL of webview is %s", webView.getUrl());
        if (webView.getUrl() == null) {
            return false;
        }
        if (!n2 && (n2 = Build.VERSION.SDK_INT) < 19) {
            u.e("This interface is only available for Android 4.4 or later.", new Object[0]);
            return false;
        }
        Object object = webView.getSettings();
        if (!object.getJavaScriptEnabled()) {
            u.a("Enable the javascript needed by webview monitor.", new Object[0]);
            object.setJavaScriptEnabled(true);
        }
        if ((object = H5JavaScriptInterface.getInstance(webView)) != null) {
            u.a("Add a secure javascript interface to the webview.", new Object[0]);
            webView.addJavascriptInterface(object, "exceptionUploader");
        }
        if (bl) {
            u.a("Inject bugly.js(v%s) to the webview.", c.b());
            String string = c.a();
            if (string == null) {
                u.e("Failed to inject Bugly.js.", c.b());
                return false;
            }
            webView.loadUrl("javascript:" + string);
        }
        return true;
    }

    static {
        b = null;
    }

    public static class CrashHandleCallback
    extends BuglyStrategy.a {
    }

    public static class UserStrategy
    extends BuglyStrategy {
        private CrashHandleCallback a;

        public UserStrategy(Context context) {
        }

        @Override
        public synchronized CrashHandleCallback getCrashHandleCallback() {
            return this.a;
        }

        public synchronized void setCrashHandleCallback(CrashHandleCallback crashHandleCallback) {
            this.a = crashHandleCallback;
        }
    }
}

