/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.crashreport;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.tencent.bugly.BuglyStrategy;
import com.tencent.bugly.CrashModule;
import com.tencent.bugly.crashreport.common.strategy.StrategyBean;
import com.tencent.bugly.crashreport.crash.h5.H5JavaScriptInterface;
import com.tencent.bugly.crashreport.crash.jni.NativeCrashHandler;
import com.tencent.bugly.proguard.aa;
import com.tencent.bugly.proguard.ac;
import com.tencent.bugly.proguard.ak;
import com.tencent.bugly.proguard.al;
import com.tencent.bugly.proguard.an;
import com.tencent.bugly.proguard.ap;
import com.tencent.bugly.proguard.aq;
import com.tencent.bugly.proguard.at;
import com.tencent.bugly.proguard.au;
import com.tencent.bugly.proguard.bc;
import com.tencent.bugly.proguard.p;
import com.tencent.bugly.proguard.s;
import com.tencent.bugly.proguard.w;
import com.tencent.bugly.proguard.x;
import com.tencent.bugly.proguard.y;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CrashReport {
    private static Context a;

    public static void enableBugly(boolean bl2) {
        p.a = bl2;
    }

    public static void initCrashReport(Context context) {
        if (context == null) {
            return;
        }
        a = context;
        p.a(CrashModule.getInstance());
        p.a(context);
    }

    public static void initCrashReport(Context context, UserStrategy userStrategy) {
        if (context == null) {
            return;
        }
        a = context;
        p.a(CrashModule.getInstance());
        p.a(context, userStrategy);
    }

    public static void initCrashReport(Context context, String string, boolean bl2) {
        CrashReport.initCrashReport(context, string, bl2, null);
    }

    public static void initCrashReport(Context context, String string, boolean bl2, UserStrategy userStrategy) {
        if (context == null) {
            return;
        }
        a = context;
        p.a(CrashModule.getInstance());
        p.a(context, string, bl2, userStrategy);
    }

    public static Context getContext() {
        return a;
    }

    public static String getBuglyVersion(Context context) {
        if (context == null) {
            al.d("Please call with context.", new Object[0]);
            return "unknown";
        }
        return aa.a((Context)context).h;
    }

    public static void testJavaCrash() {
        int n2;
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not test Java crash because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)al.b, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        aa aa2 = aa.b();
        if (aa2 != null && (n2 = aa2.x) != 24096) {
            aa2.x = 24096;
            al.a("server scene tag %d changed to tag %d", n2, aa2.x);
        }
        throw new RuntimeException("This Crash create for Test! You can go to Bugly see more detail!");
    }

    public static void testNativeCrash() {
        CrashReport.testNativeCrash(true, true, false);
    }

    public static void testNativeCrash(boolean bl2, boolean bl3, boolean bl4) {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not test native crash because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)al.b, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        al.a("start to create a native crash for test!", new Object[0]);
        at.a().a(bl2, bl3, bl4);
    }

    public static void testANRCrash() {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not test ANR crash because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)al.b, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        al.a("start to create a anr crash for test!", new Object[0]);
        at.a().h();
    }

    public static void postException(Thread thread, int n2, String string, String string2, String string3, Map<String, String> map) {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not post crash caught because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)al.b, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        au.a(thread, n2, string, string2, string3, map);
    }

    public static void postException(int n2, String string, String string2, String string3, Map<String, String> map) {
        CrashReport.postException(Thread.currentThread(), n2, string, string2, string3, map);
    }

    public static void postCatchedException(Throwable throwable) {
        CrashReport.postCatchedException(throwable, Thread.currentThread());
    }

    public static void postCatchedException(Throwable throwable, Thread thread) {
        CrashReport.postCatchedException(throwable, thread, false);
    }

    public static void postCatchedException(Throwable object, Thread thread, boolean bl2) {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not post crash caught because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)al.b, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        if (object == null) {
            al.d("throwable is null, just return", new Object[0]);
            return;
        }
        if (thread == null) {
            thread = Thread.currentThread();
        }
        boolean bl3 = bl2;
        Throwable throwable = object;
        object = at.a();
        ((at)object).v.a(new Runnable(thread, throwable, bl3){
            final /* synthetic */ boolean a;
            final /* synthetic */ Thread b;
            final /* synthetic */ Throwable c;
            final /* synthetic */ String d;
            final /* synthetic */ byte[] e;
            final /* synthetic */ boolean f;
            final /* synthetic */ boolean g;
            {
                this.a = false;
                this.b = thread;
                this.c = throwable;
                this.d = null;
                this.e = null;
                this.f = true;
                this.g = bl2;
            }

            @Override
            public final void run() {
                try {
                    al.c("post a throwable %b", this.a);
                    at.this.s.a(this.b, this.c, false, this.d, this.e, this.f);
                    if (this.g) {
                        al.a("clear user datas", new Object[0]);
                        aa.a(at.this.c).u();
                    }
                    return;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!al.b(throwable)) {
                        throwable2.printStackTrace();
                    }
                    al.e("java catch error: %s", this.c.toString());
                    return;
                }
            }
        });
    }

    public static void setAllThreadStackEnable(Context object, boolean bl2, boolean bl3) {
        object = aa.a(object);
        v0.Q = bl2;
        object.R = bl3;
    }

    public static void closeNativeReport() {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not close native report because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)al.b, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        at.a().d();
    }

    public static void startCrashReport() {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not start crash report because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.w((String)al.b, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        at.a().b();
    }

    public static void closeCrashReport() {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not close crash report because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.w((String)al.b, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        at.a().c();
    }

    public static void closeBugly() {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not close bugly because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.w((String)al.b, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        if (a == null) {
            return;
        }
        Object object = aq.a();
        if (object != null) {
            object.b(a);
        }
        CrashReport.closeCrashReport();
        s.a(a);
        object = ak.a();
        if (object != null) {
            ((ak)object).b();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUserSceneTag(Context object, int n2) {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not set tag caught because bugly is disable.");
            return;
        }
        if (object == null) {
            Log.e((String)al.b, (String)"setTag args context should not be null");
            return;
        }
        if (n2 <= 0) {
            al.d("setTag args tagId should > 0", new Object[0]);
        }
        object = aa.a(object);
        Object object2 = object.U;
        synchronized (object2) {
            int n3 = object.w;
            if (n3 != n2) {
                object.w = n2;
                al.a("user scene tag %d changed to tag %d", n3, object.w);
            }
        }
        al.b("[param] set user scene tag: %d", n2);
    }

    public static int getUserSceneTagId(Context context) {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not get user scene tag because bugly is disable.");
            return -1;
        }
        if (context == null) {
            Log.e((String)al.b, (String)"getUserSceneTagId args context should not be null");
            return -1;
        }
        return aa.a(context).z();
    }

    public static String getUserData(Context context, String string) {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not get user data because bugly is disable.");
            return "unknown";
        }
        if (context == null) {
            Log.e((String)al.b, (String)"getUserDataValue args context should not be null");
            return "unknown";
        }
        if (ap.a(string)) {
            return null;
        }
        return aa.a(context).g(string);
    }

    public static void putUserData(Context context, String string, String string2) {
        Object object;
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not put user data because bugly is disable.");
            return;
        }
        if (context == null) {
            Log.w((String)al.b, (String)"putUserData args context should not be null");
            return;
        }
        if (string == null) {
            new StringBuilder().append(string);
            al.d("putUserData args key should not be null or empty", new Object[0]);
            return;
        }
        if (string2 == null) {
            new StringBuilder().append(string2);
            al.d("putUserData args value should not be null", new Object[0]);
            return;
        }
        if (string2.length() > 200) {
            al.d("user data value length over limit %d, it will be cutted!", 200);
            string2 = string2.substring(0, 200);
        }
        if (((aa)(object = aa.a(context))).w().contains(string)) {
            object = NativeCrashHandler.getInstance();
            if (object != null) {
                ((NativeCrashHandler)object).putKeyValueToNative(string, string2);
            }
            aa.a(context).a(string, string2);
            al.c("replace KV %s %s", string, string2);
            return;
        }
        if (((aa)object).v() >= 50) {
            al.d("user data size is over limit %d, it will be cutted!", 50);
            return;
        }
        if (string.length() > 50) {
            al.d("user data key length over limit %d , will drop this new key %s", 50, string);
            string = string.substring(0, 50);
        }
        if ((object = NativeCrashHandler.getInstance()) != null) {
            ((NativeCrashHandler)object).putKeyValueToNative(string, string2);
        }
        aa.a(context).a(string, string2);
        al.b("[param] set user data: %s - %s", string, string2);
    }

    public static String removeUserData(Context context, String string) {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not remove user data because bugly is disable.");
            return "unknown";
        }
        if (context == null) {
            Log.e((String)al.b, (String)"removeUserData args context should not be null");
            return "unknown";
        }
        if (ap.a(string)) {
            return null;
        }
        al.b("[param] remove user data: %s", string);
        return aa.a(context).f(string);
    }

    public static Set<String> getAllUserDataKeys(Context context) {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not get all keys of user data because bugly is disable.");
            return new HashSet<String>();
        }
        if (context == null) {
            Log.e((String)al.b, (String)"getAllUserDataKeys args context should not be null");
            return new HashSet<String>();
        }
        return aa.a(context).w();
    }

    public static int getUserDatasSize(Context context) {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not get size of user data because bugly is disable.");
            return -1;
        }
        if (context == null) {
            Log.e((String)al.b, (String)"getUserDatasSize args context should not be null");
            return -1;
        }
        return aa.a(context).v();
    }

    public static String getAppID() {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not get App ID because bugly is disable.");
            return "unknown";
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)al.b, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return "unknown";
        }
        return aa.a(a).e();
    }

    public static void setUserId(String string) {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not set user ID because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)al.b, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        CrashReport.setUserId(a, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUserId(Context object, String string) {
        Object object2;
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not set user ID because bugly is disable.");
            return;
        }
        if (object == null) {
            Log.e((String)al.b, (String)"Context should not be null when bugly has not been initialed!");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            al.d("userId should not be null", new Object[0]);
            return;
        }
        if (string.length() > 100) {
            object2 = string.substring(0, 100);
            al.d("userId %s length is over limit %d substring to %s", string, 100, object2);
            string = object2;
        }
        if (string.equals(aa.a(object).f())) {
            return;
        }
        object2 = string;
        object = aa.a(object);
        Object object3 = object.V;
        synchronized (object3) {
            if (object2 == null) {
                object2 = "10000";
            }
            object.l = String.valueOf(object2);
        }
        al.b("[user] set userId : %s", string);
        object2 = NativeCrashHandler.getInstance();
        if (object2 != null) {
            ((NativeCrashHandler)object2).setNativeUserId(string);
        }
        if (CrashModule.getInstance().hasInitialized()) {
            s.a();
        }
    }

    public static String getUserId() {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not get user ID because bugly is disable.");
            return "unknown";
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)al.b, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return "unknown";
        }
        return aa.a(a).f();
    }

    public static void setDeviceId(Context context, String string) {
        if (context != null && !TextUtils.isEmpty((CharSequence)string)) {
            aa.a(context).a(string);
        }
    }

    public static void setDeviceModel(Context context, String string) {
        if (context != null && !TextUtils.isEmpty((CharSequence)string)) {
            aa.a(context).b(string);
        }
    }

    public static String getDeviceID(Context context) {
        return aa.a(context).g();
    }

    public static String getAppVer() {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not get app version because bugly is disable.");
            return "unknown";
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)al.b, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return "unknown";
        }
        return aa.a((Context)CrashReport.a).o;
    }

    public static String getAppChannel() {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not get App channel because bugly is disable.");
            return "unknown";
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)al.b, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return "unknown";
        }
        return aa.a((Context)CrashReport.a).s;
    }

    public static void setContext(Context context) {
        a = context;
    }

    public static boolean isLastSessionCrash() {
        if (!p.a) {
            Log.w((String)al.b, (String)"The info 'isLastSessionCrash' is not accurate because bugly is disable.");
            return false;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)al.b, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return false;
        }
        at at2 = at.a();
        Object object = at2.z;
        if (object != null) {
            return (Boolean)object;
        }
        object = aa.b().d;
        Object object2 = w.a().a(1);
        ArrayList<y> arrayList = new ArrayList<y>();
        if (object2 != null && object2.size() > 0) {
            object2 = object2.iterator();
            while (object2.hasNext()) {
                y y2 = (y)object2.next();
                if (!((String)object).equals(y2.c)) continue;
                at2.z = Boolean.TRUE;
                arrayList.add(y2);
            }
            if (arrayList.size() > 0) {
                w.a().a(arrayList);
            }
            return true;
        }
        at2.z = Boolean.FALSE;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSdkExtraData(Context object, String string, String string2) {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not put SDK extra data because bugly is disable.");
            return;
        }
        if (object == null || ap.a(string) || ap.a(string2)) {
            return;
        }
        object = aa.a(object);
        if (string == null || string2 == null) {
            return;
        }
        Object object2 = object.T;
        synchronized (object2) {
            object.K.put(string, string2);
            return;
        }
    }

    public static Map<String, String> getSdkExtraData() {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not get SDK extra data because bugly is disable.");
            return new HashMap<String, String>();
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)al.b, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return null;
        }
        return aa.a((Context)CrashReport.a).K;
    }

    public static Map<String, String> getSdkExtraData(Context context) {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not get SDK extra data because bugly is disable.");
            return new HashMap<String, String>();
        }
        if (context == null) {
            al.d("Context should not be null.", new Object[0]);
            return null;
        }
        return aa.a((Context)context).K;
    }

    private static void putSdkData(Context context, String string, String string2) {
        if (context == null || ap.a(string) || ap.a(string2)) {
            return;
        }
        if ((string = string.replace("[a-zA-Z[0-9]]+", "")).length() > 100) {
            Log.w((String)al.b, (String)String.format("putSdkData key length over limit %d, will be cutted.", 50));
            string = string.substring(0, 50);
        }
        if (string2.length() > 500) {
            Log.w((String)al.b, (String)String.format("putSdkData value length over limit %d, will be cutted!", 200));
            string2 = string2.substring(0, 200);
        }
        aa.a(context).b(string, string2);
        al.b(String.format("[param] putSdkData data: %s - %s", string, string2), new Object[0]);
    }

    @Deprecated
    public static void setIsAppForeground(Context context, boolean bl2) {
        al.a("App fore and back status are no longer supported", new Object[0]);
    }

    public static void setIsDevelopmentDevice(Context context, boolean bl2) {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not set 'isDevelopmentDevice' because bugly is disable.");
            return;
        }
        if (context == null) {
            al.d("Context should not be null.", new Object[0]);
            return;
        }
        if (bl2) {
            al.c("This is a development device.", new Object[0]);
        } else {
            al.c("This is not a development device.", new Object[0]);
        }
        aa.a((Context)context).I = bl2;
    }

    public static void setSessionIntervalMills(long l2) {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not set 'SessionIntervalMills' because bugly is disable.");
            return;
        }
        s.a(l2);
    }

    public static void setDumpFilePath(Context context, String string) {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not set App version because bugly is disable.");
            return;
        }
        if (context == null) {
            Log.w((String)al.b, (String)"setTombPath args context should not be null");
            return;
        }
        if (string == null) {
            Log.w((String)al.b, (String)"tombstone path is null, will not set");
            return;
        }
        Log.i((String)al.b, (String)"user set tombstone path: ".concat(String.valueOf(string)));
        NativeCrashHandler.setDumpFilePath(string);
    }

    public static void setAppVersion(Context object, String string) {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not set App version because bugly is disable.");
            return;
        }
        if (object == null) {
            Log.w((String)al.b, (String)"setAppVersion args context should not be null");
            return;
        }
        if (string == null) {
            Log.w((String)al.b, (String)"App version is null, will not set");
            return;
        }
        aa.a((Context)object).o = string;
        object = NativeCrashHandler.getInstance();
        if (object != null) {
            ((NativeCrashHandler)object).setNativeAppVersion(string);
        }
    }

    public static void setAppChannel(Context object, String string) {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not set App channel because Bugly is disable.");
            return;
        }
        if (object == null) {
            Log.w((String)al.b, (String)"setAppChannel args context should not be null");
            return;
        }
        if (string == null) {
            Log.w((String)al.b, (String)"App channel is null, will not set");
            return;
        }
        aa.a((Context)object).s = string;
        object = NativeCrashHandler.getInstance();
        if (object != null) {
            ((NativeCrashHandler)object).setNativeAppChannel(string);
        }
    }

    public static void setAppPackage(Context object, String string) {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not set App package because bugly is disable.");
            return;
        }
        if (object == null) {
            Log.w((String)al.b, (String)"setAppPackage args context should not be null");
            return;
        }
        if (string == null) {
            Log.w((String)al.b, (String)"App package is null, will not set");
            return;
        }
        aa.a((Context)object).c = string;
        object = NativeCrashHandler.getInstance();
        if (object != null) {
            ((NativeCrashHandler)object).setNativeAppPackage(string);
        }
    }

    public static void setCrashFilter(String string) {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not set App package because bugly is disable.");
            return;
        }
        Log.i((String)al.b, (String)"Set crash stack filter: ".concat(String.valueOf(string)));
        at.p = string;
    }

    public static void setCrashRegularFilter(String string) {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not set App package because bugly is disable.");
            return;
        }
        Log.i((String)al.b, (String)"Set crash stack filter: ".concat(String.valueOf(string)));
        at.q = string;
    }

    public static void setHandleNativeCrashInJava(boolean bl2) {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not set App package because bugly is disable.");
            return;
        }
        Log.i((String)al.b, (String)"Should handle native crash in Java profile after handled in native profile: ".concat(String.valueOf(bl2)));
        NativeCrashHandler.setShouldHandleInJava(bl2);
    }

    public static void setBuglyDbName(String string) {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not set DB name because bugly is disable.");
            return;
        }
        Log.i((String)al.b, (String)"Set Bugly DB name: ".concat(String.valueOf(string)));
        x.a = string;
    }

    public static void enableObtainId(Context context, boolean bl2) {
        CrashReport.setCollectPrivacyInfo(context, bl2);
    }

    public static void setCollectPrivacyInfo(Context context, boolean bl2) {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not set collect privacy info enable because bugly is disable.");
            return;
        }
        if (context == null) {
            Log.w((String)al.b, (String)"setCollectPrivacyInfo args context should not be null");
            return;
        }
        Log.i((String)al.b, (String)"setCollectPrivacyInfo: ".concat(String.valueOf(bl2)));
        aa.a((Context)context).n = bl2;
    }

    public static void setServerUrl(String string) {
        if (ap.a(string) || !ap.c(string)) {
            Log.i((String)al.b, (String)"URL is invalid.");
            return;
        }
        ac.a(string);
        StrategyBean.a = string;
        StrategyBean.b = string;
    }

    public static void uploadUserInfo() {
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not upload user info because bugly is disable.");
            return;
        }
        if (s.b == null) {
            Log.w((String)al.b, (String)"Can not upload user info because bugly is not init.");
            return;
        }
        s.b.b();
    }

    public static boolean setJavascriptMonitor(WebView webView, boolean bl2) {
        return CrashReport.setJavascriptMonitor(webView, bl2, false);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public static boolean setJavascriptMonitor(final WebView webView, boolean bl2, boolean bl3) {
        if (webView == null) {
            Log.w((String)al.b, (String)"WebView is null.");
            return false;
        }
        webView.getSettings().setSavePassword(false);
        webView.getSettings().setAllowFileAccess(false);
        return CrashReport.setJavascriptMonitor(new a(){

            @Override
            public final String a() {
                return webView.getUrl();
            }

            @Override
            public final void b() {
                WebSettings webSettings = webView.getSettings();
                if (!webSettings.getJavaScriptEnabled()) {
                    webSettings.setJavaScriptEnabled(true);
                }
            }

            @Override
            public final void a(String string) {
                webView.loadUrl(string);
            }

            @Override
            public final void a(H5JavaScriptInterface h5JavaScriptInterface, String string) {
                webView.addJavascriptInterface((Object)h5JavaScriptInterface, string);
            }

            @Override
            public final CharSequence c() {
                return webView.getContentDescription();
            }
        }, bl2, bl3);
    }

    public static boolean setJavascriptMonitor(a a2, boolean bl2) {
        return CrashReport.setJavascriptMonitor(a2, bl2, false);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public static boolean setJavascriptMonitor(a a2, boolean bl2, boolean bl3) {
        if (a2 == null) {
            Log.w((String)al.b, (String)"WebViewInterface is null.");
            return false;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            al.e("CrashReport has not been initialed! please to call method 'initCrashReport' first!", new Object[0]);
            return false;
        }
        al.a("Set Javascript exception monitor of webview.", new Object[0]);
        if (!p.a) {
            Log.w((String)al.b, (String)"Can not set JavaScript monitor because bugly is disable.");
            return false;
        }
        al.c("URL of webview is %s", a2.a());
        if (!bl3 && Build.VERSION.SDK_INT < 19) {
            al.e("This interface is only available for Android 4.4 or later.", new Object[0]);
            return false;
        }
        al.a("Enable the javascript needed by webview monitor.", new Object[0]);
        a2.b();
        H5JavaScriptInterface h5JavaScriptInterface = H5JavaScriptInterface.getInstance(a2);
        if (h5JavaScriptInterface != null) {
            al.a("Add a secure javascript interface to the webview.", new Object[0]);
            a2.a(h5JavaScriptInterface, "exceptionUploader");
        }
        if (bl2) {
            al.a("Inject bugly.js(v%s) to the webview.", bc.b());
            String string = bc.a();
            if (string == null) {
                al.e("Failed to inject Bugly.js.", bc.b());
                return false;
            }
            a2.a("javascript:".concat(String.valueOf(string)));
        }
        return true;
    }

    public static void setHttpProxy(String string, int n2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            an.a = null;
            return;
        }
        an.a = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string, n2));
    }

    public static void setHttpProxy(InetAddress inetAddress, int n2) {
        if (inetAddress == null) {
            an.a = null;
            return;
        }
        an.a = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(inetAddress, n2));
    }

    public static Proxy getHttpProxy() {
        return an.a;
    }

    public static interface a {
        public String a();

        public void b();

        public void a(String var1);

        public void a(H5JavaScriptInterface var1, String var2);

        public CharSequence c();
    }

    public static class CrashHandleCallback
    extends BuglyStrategy.a {
    }

    public static class UserStrategy
    extends BuglyStrategy {
        CrashHandleCallback c;

        public UserStrategy(Context context) {
        }

        @Override
        public synchronized void setCallBackType(int n2) {
            this.a = n2;
        }

        @Override
        public synchronized int getCallBackType() {
            return this.a;
        }

        @Override
        public synchronized void setCloseErrorCallback(boolean bl2) {
            this.b = bl2;
        }

        @Override
        public synchronized boolean getCloseErrorCallback() {
            return this.b;
        }

        @Override
        public synchronized CrashHandleCallback getCrashHandleCallback() {
            return this.c;
        }

        public synchronized void setCrashHandleCallback(CrashHandleCallback crashHandleCallback) {
            this.c = crashHandleCallback;
        }
    }
}

