/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.gradle;

import com.tencent.bugly.gradle.BuglyPluginExtension;
import com.tencent.bugly.gradle.FileRecorder;
import com.tencent.bugly.gradle.Logger;
import com.tencent.bugly.gradle.Utils;
import com.tencent.bugly.symtabtool.android.SymtabToolAndroid;
import com.tencent.bugly.symtabtool.common.upload.SymtabFileUploader;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.file.ConfigurableFileTree;

public class BuglyPlugin
implements Plugin<Project>,
GroovyObject {
    private Project project;
    private String prjPath;
    private String buglyPath;
    private static final String SYMTAB_RECORD_FILE_NAME = "BuglySymtabLog.txt";
    private static final String UPLOAD_RECORD_FILE_NAME = "BuglyUploadLog.txt";
    private static final int RECORD_MAX_NUMBER = 200;
    private FileRecorder symtabRecorder;
    private FileRecorder uploadRecorder;
    private String appId;
    public String appKey;
    private String appVersion;
    private String appPackage;
    private String appChannel;
    private String flavorName;
    private boolean isDebug;
    private boolean upload;
    private boolean uploadMapping;
    private boolean uploadSymbol;
    private boolean isAppModule;
    private String outputDirName;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;
    private static /* synthetic */ Class $class$com$android$builder$core$DefaultManifestParser;

    public BuglyPlugin() {
        MetaClass metaClass;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        CallSite[] callSiteArray = BuglyPlugin.$getCallSiteArray();
        Object var2_2 = null;
        this.project = (Project)ScriptBytecodeAdapter.castToType(var2_2, Project.class);
        Object var3_3 = null;
        this.prjPath = ShortTypeHandling.castToString(var3_3);
        Object var4_4 = null;
        this.buglyPath = ShortTypeHandling.castToString(var4_4);
        Object var5_5 = null;
        this.symtabRecorder = (FileRecorder)ScriptBytecodeAdapter.castToType(var5_5, FileRecorder.class);
        Object var6_6 = null;
        this.uploadRecorder = (FileRecorder)ScriptBytecodeAdapter.castToType(var6_6, FileRecorder.class);
        Object var7_7 = null;
        this.appId = ShortTypeHandling.castToString(var7_7);
        Object var8_8 = null;
        this.appKey = ShortTypeHandling.castToString(var8_8);
        Object var9_9 = null;
        this.appVersion = ShortTypeHandling.castToString(var9_9);
        Object var10_10 = null;
        this.appPackage = ShortTypeHandling.castToString(var10_10);
        Object var11_11 = null;
        this.appChannel = ShortTypeHandling.castToString(var11_11);
        Object var12_12 = null;
        this.flavorName = ShortTypeHandling.castToString(var12_12);
        this.isDebug = bl6 = false;
        this.upload = bl5 = true;
        this.uploadMapping = bl4 = true;
        this.uploadSymbol = bl3 = true;
        this.isAppModule = bl2 = true;
        Object var18_18 = null;
        this.outputDirName = ShortTypeHandling.castToString(var18_18);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    private String extractSymtabFile(String soFilePath, Vector<Map<String, String>> symtabRecords) {
        CallSite[] callSiteArray = BuglyPlugin.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)soFilePath, null)) {
            return ShortTypeHandling.castToString((Object)false);
        }
        String symtabFileName = null;
        String soFileUuid = ShortTypeHandling.castToString((Object)callSiteArray[0].call(SymtabToolAndroid.class, (Object)soFilePath));
        boolean foundInRecord = false;
        Map record = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(symtabRecords), Iterator.class);
        while (iterator.hasNext()) {
            boolean bl2;
            record = (Map)ScriptBytecodeAdapter.castToType(iterator.next(), Map.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].call((Object)record, (Object)"file")) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call(callSiteArray[4].call((Object)record, (Object)"file"), (Object)soFilePath)) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].call((Object)record, (Object)"uuid")) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].call(callSiteArray[7].call((Object)record, (Object)"uuid"), (Object)soFileUuid)) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[8].call((Object)record, (Object)"symbolFile"))) continue;
            callSiteArray[9].call(Logger.class, (Object)"The SO file had been extracted before.");
            Object object = callSiteArray[10].call((Object)record, (Object)"symbolFile");
            symtabFileName = ShortTypeHandling.castToString((Object)object);
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[11].call(callSiteArray[12].callConstructor(File.class, (Object)symtabFileName)))) continue;
            foundInRecord = bl2 = true;
            break;
        }
        if (!foundInRecord) {
            Vector args = (Vector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].callConstructor(Vector.class), Vector.class);
            callSiteArray[14].call(callSiteArray[15].call((Object)args, (Object)"-i"), (Object)soFilePath);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)this.outputDirName, null)) {
                callSiteArray[16].call(callSiteArray[17].call((Object)args, (Object)"-o"), (Object)this.outputDirName);
            }
            if (this.isDebug) {
                callSiteArray[18].call((Object)args, (Object)"-d");
            }
            callSiteArray[19].call(SymtabToolAndroid.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[20].call((Object)args), String[].class)), String[].class));
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[21].callGetProperty(SymtabToolAndroid.class))) {
                callSiteArray[22].call(Logger.class, (Object)"Failed to extract symbol file for SO: %s", (Object)soFilePath);
                return ShortTypeHandling.castToString((Object)false);
            }
            Object object = callSiteArray[23].callGetProperty(SymtabToolAndroid.class);
            symtabFileName = ShortTypeHandling.castToString((Object)object);
            callSiteArray[24].call(Logger.class, (Object)"Record symbol file: %s", (Object)symtabFileName);
            HashMap infos = (HashMap)ScriptBytecodeAdapter.castToType((Object)callSiteArray[25].callConstructor(HashMap.class), HashMap.class);
            callSiteArray[26].call((Object)infos, (Object)"file", (Object)soFilePath);
            callSiteArray[27].call((Object)infos, (Object)"uuid", (Object)soFileUuid);
            callSiteArray[28].call((Object)infos, (Object)"symbolFile", (Object)symtabFileName);
            callSiteArray[29].call((Object)this.symtabRecorder, (Object)infos);
        }
        return symtabFileName;
    }

    private boolean uploadSymbolFile(SymbolFile file, Vector<Map<String, String>> uploadRecords) {
        CallSite[] callSiteArray = BuglyPlugin.$getCallSiteArray();
        Object object = callSiteArray[30].callGroovyObjectGetProperty((Object)file);
        if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[31].callGetProperty(SymbolFile.class))) {
            if (!this.uploadMapping) {
                callSiteArray[32].call(Logger.class, (Object)"Uploading of mapping file is disable.");
                return true;
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[33].call(callSiteArray[34].callGroovyObjectGetProperty((Object)file), (Object)".txt"))) {
                callSiteArray[35].call(Logger.class, (Object)"Mapping file to upload is not valid: %s", callSiteArray[36].callGroovyObjectGetProperty((Object)file));
                return false;
            }
        } else if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[37].callGetProperty(SymbolFile.class))) {
            if (!this.uploadSymbol) {
                callSiteArray[38].call(Logger.class, (Object)"Uploading of symbol file is disable.");
                return true;
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[39].call(callSiteArray[40].callGroovyObjectGetProperty((Object)file), (Object)".zip"))) {
                callSiteArray[41].call(Logger.class, (Object)"Symbol file to upload is not valid: %s", callSiteArray[42].callGroovyObjectGetProperty((Object)file));
                return false;
            }
        } else {
            callSiteArray[43].call(Logger.class, (Object)"Unknown file type: %d", callSiteArray[44].callGroovyObjectGetProperty((Object)file));
            return false;
        }
        String fileSha1 = ShortTypeHandling.castToString((Object)callSiteArray[45].call(Utils.class, callSiteArray[46].callGroovyObjectGetProperty((Object)file)));
        boolean foundInRecord = false;
        Map record = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[47].call(uploadRecords), Iterator.class);
        while (iterator.hasNext()) {
            boolean bl2;
            record = (Map)ScriptBytecodeAdapter.castToType(iterator.next(), Map.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[48].call((Object)record, (Object)"file")) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[49].call(callSiteArray[50].call((Object)record, (Object)"file"), callSiteArray[51].callGroovyObjectGetProperty((Object)file))) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[52].call((Object)record, (Object)"sha1")) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[53].call(callSiteArray[54].call((Object)record, (Object)"sha1"), (Object)fileSha1)) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[55].call((Object)record, (Object)"appId")) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[56].call(callSiteArray[57].call((Object)record, (Object)"appId"), (Object)this.appId)) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[58].callGroovyObjectGetProperty((Object)file), (Object)callSiteArray[59].callGetProperty(SymbolFile.class)) && (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[60].call((Object)record, (Object)"appChannel")) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[61].call(callSiteArray[62].call((Object)record, (Object)"appChannel"), (Object)this.appChannel)) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[63].call((Object)record, (Object)"appPackage")) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[64].call(callSiteArray[65].call((Object)record, (Object)"appPackage"), (Object)this.appPackage)) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[66].call((Object)record, (Object)"appVersion")) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[67].call(callSiteArray[68].call((Object)record, (Object)"appVersion"), (Object)this.appVersion)))) continue;
            foundInRecord = bl2 = true;
            break;
        }
        if (foundInRecord) {
            callSiteArray[69].call(Logger.class, (Object)"The file had been uploaded before.");
            return true;
        }
        callSiteArray[70].call(Logger.class, (Object)"Uploading file: %s", callSiteArray[71].callGroovyObjectGetProperty((Object)file));
        callSiteArray[72].call(SymtabToolAndroid.class);
        if (this.isDebug) {
            callSiteArray[73].call(SymtabToolAndroid.class, (Object)true);
        } else {
            callSiteArray[74].call(SymtabToolAndroid.class, (Object)false);
        }
        SymtabFileUploader.UploadInfo uploadInfo = (SymtabFileUploader.UploadInfo)ScriptBytecodeAdapter.castToType((Object)callSiteArray[75].callConstructor(SymtabFileUploader.UploadInfo.class), SymtabFileUploader.UploadInfo.class);
        File fileToUpload = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[76].callConstructor(File.class, callSiteArray[77].callGroovyObjectGetProperty((Object)file)), File.class);
        File file2 = fileToUpload;
        ScriptBytecodeAdapter.setProperty((Object)file2, null, (Object)uploadInfo, (String)"file");
        Object object2 = callSiteArray[78].call((Object)fileToUpload);
        ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)uploadInfo, (String)"fileName");
        Object object3 = callSiteArray[79].callGroovyObjectGetProperty((Object)file);
        if (ScriptBytecodeAdapter.isCase((Object)object3, (Object)callSiteArray[80].callGetProperty(SymbolFile.class))) {
            Object object4 = callSiteArray[81].callGetProperty(SymtabFileUploader.UploadInfo.class);
            ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)uploadInfo, (String)"symbolType");
            if (ScriptBytecodeAdapter.compareNotEqual((Object)this.appChannel, null)) {
                String string = this.appChannel;
                ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)uploadInfo, (String)"appChannel");
                Object object5 = callSiteArray[82].call(String.class, (Object)"%s-%s", (Object)this.appChannel, callSiteArray[83].callGetProperty((Object)uploadInfo));
                ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)uploadInfo, (String)"fileName");
            }
        } else if (ScriptBytecodeAdapter.isCase((Object)object3, (Object)callSiteArray[84].callGetProperty(SymbolFile.class))) {
            Object object6 = callSiteArray[85].callGetProperty(SymtabFileUploader.UploadInfo.class);
            ScriptBytecodeAdapter.setProperty((Object)object6, null, (Object)uploadInfo, (String)"symbolType");
        } else {
            callSiteArray[86].call(Logger.class, (Object)"Unknown file type: %d", callSiteArray[87].callGroovyObjectGetProperty((Object)file));
            return false;
        }
        String string = this.appId;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)uploadInfo, (String)"appId");
        String string2 = this.appKey;
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)uploadInfo, (String)"appKey");
        String string3 = this.appVersion;
        ScriptBytecodeAdapter.setProperty((Object)string3, null, (Object)uploadInfo, (String)"appVersion");
        String string4 = this.appPackage;
        ScriptBytecodeAdapter.setProperty((Object)string4, null, (Object)uploadInfo, (String)"appPackage");
        boolean res = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[88].call(SymtabFileUploader.class, (Object)uploadInfo));
        if (res) {
            callSiteArray[89].call(Logger.class, (Object)"Successfully uploaded.");
            callSiteArray[90].call(Logger.class, (Object)"Record uploaded file: %s", callSiteArray[91].callGroovyObjectGetProperty((Object)file));
            LinkedHashMap infos = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)callSiteArray[92].callConstructor(LinkedHashMap.class), LinkedHashMap.class);
            callSiteArray[93].call((Object)infos, (Object)"file", callSiteArray[94].callGroovyObjectGetProperty((Object)file));
            callSiteArray[95].call((Object)infos, (Object)"sha1", (Object)fileSha1);
            callSiteArray[96].call((Object)infos, (Object)"appId", (Object)this.appId);
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[97].callGroovyObjectGetProperty((Object)file), (Object)callSiteArray[98].callGetProperty(SymbolFile.class)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.appChannel, null)) {
                callSiteArray[99].call((Object)infos, (Object)"appChannel", (Object)this.appChannel);
                callSiteArray[100].call((Object)infos, (Object)"appPackage", (Object)this.appPackage);
                callSiteArray[101].call((Object)infos, (Object)"appVersion", (Object)this.appVersion);
            }
            callSiteArray[102].call((Object)this.uploadRecorder, (Object)infos);
            return true;
        }
        callSiteArray[103].call(Logger.class, (Object)"Failed to upload.");
        return false;
    }

    private void processFiles(Vector<SymbolFile> files) {
        CallSite[] callSiteArray = BuglyPlugin.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[104].call(files))) {
            return;
        }
        Reference uploadRecords = new Reference(null);
        if (this.upload) {
            callSiteArray[105].call(Logger.class, (Object)"Read all upload records.");
            Object object = callSiteArray[106].call((Object)this.uploadRecorder);
            uploadRecords.set((Object)((Vector)ScriptBytecodeAdapter.castToType((Object)object, Vector.class)));
            callSiteArray[107].call(Logger.class, (Object)"Number of upload records is: %d", callSiteArray[108].call((Object)((Vector)uploadRecords.get())));
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)callSiteArray[109].call((Object)((Vector)uploadRecords.get())), (Object)RECORD_MAX_NUMBER)) {
                callSiteArray[110].call((Object)this.uploadRecorder);
            }
        } else {
            callSiteArray[111].call(Logger.class, (Object)"Uploading is disable.");
        }
        callSiteArray[112].call(Logger.class, (Object)"Read all symbol records.");
        Reference symtabRecords = new Reference((Object)((Vector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[113].call((Object)this.symtabRecorder), Vector.class)));
        callSiteArray[114].call(Logger.class, (Object)"Number of symbol records is: %d", callSiteArray[115].call((Object)((Vector)symtabRecords.get())));
        if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)callSiteArray[116].call((Object)((Vector)symtabRecords.get())), (Object)RECORD_MAX_NUMBER)) {
            callSiteArray[117].call((Object)this.symtabRecorder);
        }
        class _processFiles_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference uploadRecords;
            private /* synthetic */ Reference symtabRecords;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _processFiles_closure1(Object _outerInstance, Object _thisObject, Reference uploadRecords, Reference symtabRecords) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _processFiles_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.uploadRecords = reference2 = uploadRecords;
                this.symtabRecords = reference = symtabRecords;
            }

            public Object doCall(Object file) {
                CallSite[] callSiteArray = _processFiles_closure1.$getCallSiteArray();
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(callSiteArray[1].callConstructor(File.class, callSiteArray[2].callGetProperty(file))))) {
                    return null;
                }
                callSiteArray[3].call(Logger.class, (Object)"Processing file: %s", callSiteArray[4].callGetProperty(file));
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[5].callGetProperty(file), (Object)callSiteArray[6].callGetProperty(SymbolFile.class))) {
                    Object object = callSiteArray[7].callCurrent((GroovyObject)this, callSiteArray[8].callGetProperty(file), this.symtabRecords.get());
                    ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)file, (String)"fileName");
                }
                if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[9].callGetProperty(file), null) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[10].call(callSiteArray[11].callConstructor(File.class, callSiteArray[12].callGetProperty(file)))) : ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[13].callGetProperty(file), null) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[14].call(callSiteArray[15].callConstructor(File.class, callSiteArray[16].callGetProperty(file))))) {
                    return null;
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].callGroovyObjectGetProperty((Object)this))) {
                    return callSiteArray[18].callCurrent((GroovyObject)this, file, this.uploadRecords.get());
                }
                return null;
            }

            public Vector getUploadRecords() {
                CallSite[] callSiteArray = _processFiles_closure1.$getCallSiteArray();
                return (Vector)ScriptBytecodeAdapter.castToType((Object)this.uploadRecords.get(), Vector.class);
            }

            public Vector getSymtabRecords() {
                CallSite[] callSiteArray = _processFiles_closure1.$getCallSiteArray();
                return (Vector)ScriptBytecodeAdapter.castToType((Object)this.symtabRecords.get(), Vector.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processFiles_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "exists";
                stringArray[1] = "<$constructor$>";
                stringArray[2] = "fileName";
                stringArray[3] = "info";
                stringArray[4] = "fileName";
                stringArray[5] = "type";
                stringArray[6] = "SYMBOL_TYPE_SYMBOL";
                stringArray[7] = "extractSymtabFile";
                stringArray[8] = "fileName";
                stringArray[9] = "fileName";
                stringArray[10] = "exists";
                stringArray[11] = "<$constructor$>";
                stringArray[12] = "fileName";
                stringArray[13] = "fileName";
                stringArray[14] = "exists";
                stringArray[15] = "<$constructor$>";
                stringArray[16] = "fileName";
                stringArray[17] = "upload";
                stringArray[18] = "uploadSymbolFile";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[19];
                _processFiles_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_processFiles_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _processFiles_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[118].call(files, (Object)new _processFiles_closure1(this, this, uploadRecords, symtabRecords));
    }

    private Vector<File> getDebugSoFiles(Object project, String flavorName) {
        CallSite[] callSiteArray = BuglyPlugin.$getCallSiteArray();
        Vector soFiles = (Vector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[119].callConstructor(Vector.class), Vector.class);
        if (ScriptBytecodeAdapter.compareEqual((Object)project, null)) {
            return soFiles;
        }
        String flavorPath = "";
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)flavorName, null) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[120].call((Object)flavorName))) {
                Object object = callSiteArray[121].call((Object)flavorName, (Object)"/");
                flavorPath = ShortTypeHandling.castToString((Object)object);
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)flavorName, null) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[122].call((Object)flavorName))) {
            Object object = callSiteArray[123].call((Object)flavorName, (Object)"/");
            flavorPath = ShortTypeHandling.castToString((Object)object);
        }
        Reference variantFilter = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[124].call(callSiteArray[125].call((Object)"**/", (Object)flavorPath), (Object)"release/obj/**/*.so")));
        Reference genericFilter = new Reference((Object)"**/obj/**/*.so");
        class _getDebugSoFiles_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference variantFilter;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getDebugSoFiles_closure2(Object _outerInstance, Object _thisObject, Reference variantFilter) {
                Reference reference;
                CallSite[] callSiteArray = _getDebugSoFiles_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.variantFilter = reference = variantFilter;
            }

            public Object doCall(Object it2) {
                CallSite[] callSiteArray = _getDebugSoFiles_closure2.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, this.variantFilter.get());
            }

            public String getVariantFilter() {
                CallSite[] callSiteArray = _getDebugSoFiles_closure2.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.variantFilter.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getDebugSoFiles_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getDebugSoFiles_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "include";
                return new CallSiteArray(_getDebugSoFiles_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getDebugSoFiles_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        ConfigurableFileTree collection = (ConfigurableFileTree)ScriptBytecodeAdapter.castToType((Object)callSiteArray[126].call(project, callSiteArray[127].callGetProperty(project), (Object)new _getDebugSoFiles_closure2(this, this, variantFilter)), ConfigurableFileTree.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[128].call((Object)collection))) {
            class _getDebugSoFiles_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference variantFilter;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getDebugSoFiles_closure3(Object _outerInstance, Object _thisObject, Reference variantFilter) {
                    Reference reference;
                    CallSite[] callSiteArray = _getDebugSoFiles_closure3.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.variantFilter = reference = variantFilter;
                }

                public Object doCall(Object it2) {
                    CallSite[] callSiteArray = _getDebugSoFiles_closure3.$getCallSiteArray();
                    return callSiteArray[0].callCurrent((GroovyObject)this, this.variantFilter.get());
                }

                public String getVariantFilter() {
                    CallSite[] callSiteArray = _getDebugSoFiles_closure3.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.variantFilter.get());
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _getDebugSoFiles_closure3.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getDebugSoFiles_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "include";
                    return new CallSiteArray(_getDebugSoFiles_closure3.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getDebugSoFiles_closure3.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object object = callSiteArray[129].call(project, callSiteArray[130].callGetProperty(project), (Object)new _getDebugSoFiles_closure3(this, this, variantFilter));
            collection = (ConfigurableFileTree)ScriptBytecodeAdapter.castToType((Object)object, ConfigurableFileTree.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[131].call((Object)collection))) {
            class _getDebugSoFiles_closure4
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference genericFilter;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getDebugSoFiles_closure4(Object _outerInstance, Object _thisObject, Reference genericFilter) {
                    Reference reference;
                    CallSite[] callSiteArray = _getDebugSoFiles_closure4.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.genericFilter = reference = genericFilter;
                }

                public Object doCall(Object it2) {
                    CallSite[] callSiteArray = _getDebugSoFiles_closure4.$getCallSiteArray();
                    return callSiteArray[0].callCurrent((GroovyObject)this, this.genericFilter.get());
                }

                public String getGenericFilter() {
                    CallSite[] callSiteArray = _getDebugSoFiles_closure4.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.genericFilter.get());
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _getDebugSoFiles_closure4.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getDebugSoFiles_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "include";
                    return new CallSiteArray(_getDebugSoFiles_closure4.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getDebugSoFiles_closure4.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object object = callSiteArray[132].call(project, callSiteArray[133].callGetProperty(project), (Object)new _getDebugSoFiles_closure4(this, this, genericFilter));
            collection = (ConfigurableFileTree)ScriptBytecodeAdapter.castToType((Object)object, ConfigurableFileTree.class);
        }
        callSiteArray[134].call((Object)soFiles, callSiteArray[135].callGetProperty((Object)collection));
        return soFiles;
    }

    private Vector<File> getAllDebugSoFiles() {
        CallSite[] callSiteArray = BuglyPlugin.$getCallSiteArray();
        Reference soFiles = new Reference((Object)((Vector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[136].callConstructor(Vector.class), Vector.class)));
        class _getAllDebugSoFiles_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference soFiles;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getAllDebugSoFiles_closure5(Object _outerInstance, Object _thisObject, Reference soFiles) {
                Reference reference;
                CallSite[] callSiteArray = _getAllDebugSoFiles_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.soFiles = reference = soFiles;
            }

            public Object doCall(Object it2) {
                CallSite[] callSiteArray = _getAllDebugSoFiles_closure5.$getCallSiteArray();
                Project dProject = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(it2), Project.class);
                return callSiteArray[1].call(this.soFiles.get(), callSiteArray[2].callCurrent((GroovyObject)this, (Object)dProject, callSiteArray[3].callGroovyObjectGetProperty((Object)this)));
            }

            public Vector getSoFiles() {
                CallSite[] callSiteArray = _getAllDebugSoFiles_closure5.$getCallSiteArray();
                return (Vector)ScriptBytecodeAdapter.castToType((Object)this.soFiles.get(), Vector.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getAllDebugSoFiles_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAllDebugSoFiles_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getDependencyProject";
                stringArray[1] = "addAll";
                stringArray[2] = "getDebugSoFiles";
                stringArray[3] = "flavorName";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _getAllDebugSoFiles_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getAllDebugSoFiles_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getAllDebugSoFiles_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[137].call(callSiteArray[138].call(callSiteArray[139].call(callSiteArray[140].callGetProperty(callSiteArray[141].callGetProperty((Object)this.project))), ProjectDependency.class), (Object)new _getAllDebugSoFiles_closure5(this, this, soFiles));
        callSiteArray[142].call((Object)((Vector)soFiles.get()), callSiteArray[143].callCurrent((GroovyObject)this, (Object)this.project, (Object)this.flavorName));
        return (Vector)soFiles.get();
    }

    private Vector<File> getMappingFile(Object project, String flavorName) {
        Reference flavorName2 = new Reference((Object)flavorName);
        CallSite[] callSiteArray = BuglyPlugin.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual(null, (Object)project)) {
            return (Vector)ScriptBytecodeAdapter.castToType(null, Vector.class);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[144].call(project, (Object)"android"))) {
            return (Vector)ScriptBytecodeAdapter.castToType(null, Vector.class);
        }
        Reference mappingFiles = new Reference((Object)((Vector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[145].callConstructor(Vector.class), Vector.class)));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[146].call(callSiteArray[147].callGetProperty(project), (Object)"applicationVariants"))) {
            class _getMappingFile_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference flavorName;
                private /* synthetic */ Reference mappingFiles;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getMappingFile_closure6(Object _outerInstance, Object _thisObject, Reference flavorName, Reference mappingFiles) {
                    Reference reference;
                    Reference reference2;
                    CallSite[] callSiteArray = _getMappingFile_closure6.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.flavorName = reference2 = flavorName;
                    this.mappingFiles = reference = mappingFiles;
                }

                public Object doCall(Object variant) {
                    CallSite[] callSiteArray = _getMappingFile_closure6.$getCallSiteArray();
                    if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? ScriptBytecodeAdapter.compareNotEqual((Object)this.flavorName.get(), null) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(callSiteArray[1].call(variant), this.flavorName.get())) : ScriptBytecodeAdapter.compareNotEqual((Object)this.flavorName.get(), null) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].call(callSiteArray[3].call(variant), this.flavorName.get()))) {
                        return null;
                    }
                    File mappingFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call(variant), File.class);
                    if (ScriptBytecodeAdapter.compareNotEqual(null, (Object)mappingFile) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].call((Object)mappingFile))) {
                        return callSiteArray[6].call(this.mappingFiles.get(), (Object)mappingFile);
                    }
                    return null;
                }

                public String getFlavorName() {
                    CallSite[] callSiteArray = _getMappingFile_closure6.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.flavorName.get());
                }

                public Vector getMappingFiles() {
                    CallSite[] callSiteArray = _getMappingFile_closure6.$getCallSiteArray();
                    return (Vector)ScriptBytecodeAdapter.castToType((Object)this.mappingFiles.get(), Vector.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getMappingFile_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "equals";
                    stringArray[1] = "getFlavorName";
                    stringArray[2] = "equals";
                    stringArray[3] = "getFlavorName";
                    stringArray[4] = "getMappingFile";
                    stringArray[5] = "exists";
                    stringArray[6] = "add";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[7];
                    _getMappingFile_closure6.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_getMappingFile_closure6.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getMappingFile_closure6.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[148].call(callSiteArray[149].callGetProperty(callSiteArray[150].callGetProperty(project)), (Object)new _getMappingFile_closure6(this, this, flavorName2, mappingFiles));
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[151].call(callSiteArray[152].callGetProperty(project), (Object)"libraryVariants"))) {
            class _getMappingFile_closure7
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference flavorName;
                private /* synthetic */ Reference mappingFiles;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getMappingFile_closure7(Object _outerInstance, Object _thisObject, Reference flavorName, Reference mappingFiles) {
                    Reference reference;
                    Reference reference2;
                    CallSite[] callSiteArray = _getMappingFile_closure7.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.flavorName = reference2 = flavorName;
                    this.mappingFiles = reference = mappingFiles;
                }

                public Object doCall(Object variant) {
                    CallSite[] callSiteArray = _getMappingFile_closure7.$getCallSiteArray();
                    if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? ScriptBytecodeAdapter.compareNotEqual((Object)this.flavorName.get(), null) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(callSiteArray[1].call(variant), this.flavorName.get())) : ScriptBytecodeAdapter.compareNotEqual((Object)this.flavorName.get(), null) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].call(callSiteArray[3].call(variant), this.flavorName.get()))) {
                        return null;
                    }
                    File mappingFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call(variant), File.class);
                    if (ScriptBytecodeAdapter.compareNotEqual(null, (Object)mappingFile) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].call((Object)mappingFile))) {
                        return callSiteArray[6].call(this.mappingFiles.get(), (Object)mappingFile);
                    }
                    return null;
                }

                public String getFlavorName() {
                    CallSite[] callSiteArray = _getMappingFile_closure7.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.flavorName.get());
                }

                public Vector getMappingFiles() {
                    CallSite[] callSiteArray = _getMappingFile_closure7.$getCallSiteArray();
                    return (Vector)ScriptBytecodeAdapter.castToType((Object)this.mappingFiles.get(), Vector.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getMappingFile_closure7.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "equals";
                    stringArray[1] = "getFlavorName";
                    stringArray[2] = "equals";
                    stringArray[3] = "getFlavorName";
                    stringArray[4] = "getMappingFile";
                    stringArray[5] = "exists";
                    stringArray[6] = "add";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[7];
                    _getMappingFile_closure7.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_getMappingFile_closure7.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getMappingFile_closure7.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[153].call(callSiteArray[154].callGetProperty(callSiteArray[155].callGetProperty(project)), (Object)new _getMappingFile_closure7(this, this, flavorName2, mappingFiles));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[156].call((Object)((Vector)mappingFiles.get())))) {
            String flavorPath = "";
            if (ScriptBytecodeAdapter.compareNotEqual((Object)((String)flavorName2.get()), null) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[157].call((Object)((String)flavorName2.get())))) {
                Object object = callSiteArray[158].call((Object)((String)flavorName2.get()), (Object)"/");
                flavorPath = ShortTypeHandling.castToString((Object)object);
            }
            Reference variantFilter = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[159].call(callSiteArray[160].call((Object)"**/", (Object)flavorPath), (Object)"/**/*mapping*.txt")));
            Reference genericFilter = new Reference((Object)"**/*mapping*.txt");
            class _getMappingFile_closure8
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference variantFilter;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getMappingFile_closure8(Object _outerInstance, Object _thisObject, Reference variantFilter) {
                    Reference reference;
                    CallSite[] callSiteArray = _getMappingFile_closure8.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.variantFilter = reference = variantFilter;
                }

                public Object doCall(Object it2) {
                    CallSite[] callSiteArray = _getMappingFile_closure8.$getCallSiteArray();
                    return callSiteArray[0].callCurrent((GroovyObject)this, this.variantFilter.get());
                }

                public String getVariantFilter() {
                    CallSite[] callSiteArray = _getMappingFile_closure8.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.variantFilter.get());
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _getMappingFile_closure8.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getMappingFile_closure8.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "include";
                    return new CallSiteArray(_getMappingFile_closure8.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getMappingFile_closure8.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            ConfigurableFileTree collection = (ConfigurableFileTree)ScriptBytecodeAdapter.castToType((Object)callSiteArray[161].call(project, callSiteArray[162].callGetProperty(project), (Object)new _getMappingFile_closure8(this, this, variantFilter)), ConfigurableFileTree.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[163].call((Object)collection))) {
                class _getMappingFile_closure9
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference variantFilter;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _getMappingFile_closure9(Object _outerInstance, Object _thisObject, Reference variantFilter) {
                        Reference reference;
                        CallSite[] callSiteArray = _getMappingFile_closure9.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.variantFilter = reference = variantFilter;
                    }

                    public Object doCall(Object it2) {
                        CallSite[] callSiteArray = _getMappingFile_closure9.$getCallSiteArray();
                        return callSiteArray[0].callCurrent((GroovyObject)this, this.variantFilter.get());
                    }

                    public String getVariantFilter() {
                        CallSite[] callSiteArray = _getMappingFile_closure9.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.variantFilter.get());
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _getMappingFile_closure9.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _getMappingFile_closure9.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "include";
                        return new CallSiteArray(_getMappingFile_closure9.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _getMappingFile_closure9.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Object object = callSiteArray[164].call(project, callSiteArray[165].callGetProperty(project), (Object)new _getMappingFile_closure9(this, this, variantFilter));
                collection = (ConfigurableFileTree)ScriptBytecodeAdapter.castToType((Object)object, ConfigurableFileTree.class);
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[166].call((Object)collection))) {
                class _getMappingFile_closure10
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference genericFilter;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _getMappingFile_closure10(Object _outerInstance, Object _thisObject, Reference genericFilter) {
                        Reference reference;
                        CallSite[] callSiteArray = _getMappingFile_closure10.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.genericFilter = reference = genericFilter;
                    }

                    public Object doCall(Object it2) {
                        CallSite[] callSiteArray = _getMappingFile_closure10.$getCallSiteArray();
                        return callSiteArray[0].callCurrent((GroovyObject)this, this.genericFilter.get());
                    }

                    public String getGenericFilter() {
                        CallSite[] callSiteArray = _getMappingFile_closure10.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.genericFilter.get());
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _getMappingFile_closure10.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _getMappingFile_closure10.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "include";
                        return new CallSiteArray(_getMappingFile_closure10.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _getMappingFile_closure10.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Object object = callSiteArray[167].call(project, callSiteArray[168].callGetProperty(project), (Object)new _getMappingFile_closure10(this, this, genericFilter));
                collection = (ConfigurableFileTree)ScriptBytecodeAdapter.castToType((Object)object, ConfigurableFileTree.class);
            }
            callSiteArray[169].call((Object)((Vector)mappingFiles.get()), callSiteArray[170].callGetProperty((Object)collection));
        }
        return (Vector)mappingFiles.get();
    }

    private Vector<File> getAllMappingFiles() {
        CallSite[] callSiteArray = BuglyPlugin.$getCallSiteArray();
        Reference mappingFiles = new Reference((Object)((Vector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[171].callConstructor(Vector.class), Vector.class)));
        Reference projectMappingFiles = new Reference(null);
        class _getAllMappingFiles_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference projectMappingFiles;
            private /* synthetic */ Reference mappingFiles;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getAllMappingFiles_closure11(Object _outerInstance, Object _thisObject, Reference projectMappingFiles, Reference mappingFiles) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getAllMappingFiles_closure11.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.projectMappingFiles = reference2 = projectMappingFiles;
                this.mappingFiles = reference = mappingFiles;
            }

            public Object doCall(Object it2) {
                CallSite[] callSiteArray = _getAllMappingFiles_closure11.$getCallSiteArray();
                Project dProject = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(it2), Project.class);
                Object object = callSiteArray[1].callCurrent((GroovyObject)this, (Object)dProject, null);
                this.projectMappingFiles.set((Object)((Vector)ScriptBytecodeAdapter.castToType((Object)object, Vector.class)));
                if (ScriptBytecodeAdapter.compareNotEqual((Object)this.projectMappingFiles.get(), null)) {
                    return callSiteArray[2].call(this.mappingFiles.get(), this.projectMappingFiles.get());
                }
                return null;
            }

            public Vector getProjectMappingFiles() {
                CallSite[] callSiteArray = _getAllMappingFiles_closure11.$getCallSiteArray();
                return (Vector)ScriptBytecodeAdapter.castToType((Object)this.projectMappingFiles.get(), Vector.class);
            }

            public Vector getMappingFiles() {
                CallSite[] callSiteArray = _getAllMappingFiles_closure11.$getCallSiteArray();
                return (Vector)ScriptBytecodeAdapter.castToType((Object)this.mappingFiles.get(), Vector.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getAllMappingFiles_closure11.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAllMappingFiles_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getDependencyProject";
                stringArray[1] = "getMappingFile";
                stringArray[2] = "addAll";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _getAllMappingFiles_closure11.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getAllMappingFiles_closure11.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getAllMappingFiles_closure11.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[172].call(callSiteArray[173].call(callSiteArray[174].call(callSiteArray[175].callGetProperty(callSiteArray[176].callGetProperty((Object)this.project))), ProjectDependency.class), (Object)new _getAllMappingFiles_closure11(this, this, projectMappingFiles, mappingFiles));
        Object object = callSiteArray[177].callCurrent((GroovyObject)this, (Object)this.project, (Object)this.flavorName);
        projectMappingFiles.set((Object)((Vector)ScriptBytecodeAdapter.castToType((Object)object, Vector.class)));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)((Vector)projectMappingFiles.get()), null)) {
            callSiteArray[178].call((Object)((Vector)mappingFiles.get()), (Object)((Vector)projectMappingFiles.get()));
        }
        return (Vector)mappingFiles.get();
    }

    private String getDirName(String dirName) {
        CallSite[] callSiteArray = BuglyPlugin.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)dirName, null)) {
            return ShortTypeHandling.castToString(null);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[179].call(callSiteArray[180].callConstructor(File.class, (Object)dirName))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[181].call(callSiteArray[182].callConstructor(File.class, (Object)dirName)))) {
            callSiteArray[183].call(Logger.class, (Object)"Failed to create dir: %s", (Object)dirName);
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[184].call(callSiteArray[185].callConstructor(File.class, (Object)dirName)));
    }

    private String getOutputDirName() {
        CallSite[] callSiteArray = BuglyPlugin.$getCallSiteArray();
        String dirName = ShortTypeHandling.castToString((Object)callSiteArray[186].callGetProperty(callSiteArray[187].callGetProperty((Object)this.project)));
        if (ScriptBytecodeAdapter.compareEqual((Object)dirName, null)) {
            return this.buglyPath;
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)callSiteArray[188].callCurrent((GroovyObject)this, (Object)dirName));
        }
        return this.getDirName(dirName);
    }

    private String getVersionName(Object variant) {
        CallSite[] callSiteArray = BuglyPlugin.$getCallSiteArray();
        String versionName = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[189].call(callSiteArray[190].callGetProperty((Object)this.project), (Object)"applicationVariants"))) {
            Object object = callSiteArray[191].call(variant);
            versionName = ShortTypeHandling.castToString((Object)object);
        }
        if (ScriptBytecodeAdapter.compareEqual(null, versionName) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[192].call(versionName))) {
            Object object = callSiteArray[193].callGetProperty(callSiteArray[194].callGetProperty(callSiteArray[195].callGetProperty((Object)this.project)));
            versionName = ShortTypeHandling.castToString((Object)object);
        }
        if (ScriptBytecodeAdapter.compareEqual(null, (Object)versionName) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[196].call((Object)versionName))) {
            Object object = callSiteArray[197].call(callSiteArray[198].callConstructor((Object)BuglyPlugin.$get$$class$com$android$builder$core$DefaultManifestParser()), callSiteArray[199].callGetProperty(callSiteArray[200].callGetProperty(callSiteArray[201].callGetProperty(callSiteArray[202].callGetProperty(callSiteArray[203].callGetProperty((Object)this.project))))));
            versionName = ShortTypeHandling.castToString((Object)object);
        }
        return versionName;
    }

    /*
     * Unable to fully structure code
     */
    private boolean initLocalInfos(Object variant) {
        var2_2 = BuglyPlugin.$getCallSiteArray();
        var3_3 = var2_2[204].callCurrent((GroovyObject)this, var2_2[205].call(var2_2[206].call((Object)this.prjPath, var2_2[207].callGetProperty(File.class)), (Object)"bugly"));
        this.buglyPath = ShortTypeHandling.castToString((Object)var3_3);
        var4_4 = var2_2[208].callConstructor(FileRecorder.class, var2_2[209].callConstructor(File.class, (Object)this.buglyPath, (Object)BuglyPlugin.SYMTAB_RECORD_FILE_NAME));
        this.symtabRecorder = (FileRecorder)ScriptBytecodeAdapter.castToType((Object)var4_4, FileRecorder.class);
        var5_5 = var2_2[210].callConstructor(FileRecorder.class, var2_2[211].callConstructor(File.class, (Object)this.buglyPath, (Object)BuglyPlugin.UPLOAD_RECORD_FILE_NAME));
        this.uploadRecorder = (FileRecorder)ScriptBytecodeAdapter.castToType((Object)var5_5, FileRecorder.class);
        var6_6 = var2_2[212].callGetProperty(var2_2[213].callGetProperty((Object)this.project));
        this.upload = DefaultTypeTransformation.booleanUnbox((Object)var6_6);
        var7_7 = var2_2[214].callGetProperty(var2_2[215].callGetProperty((Object)this.project));
        this.uploadMapping = DefaultTypeTransformation.booleanUnbox((Object)var7_7);
        var8_8 = var2_2[216].callGetProperty(var2_2[217].callGetProperty((Object)this.project));
        this.uploadSymbol = DefaultTypeTransformation.booleanUnbox((Object)var8_8);
        var9_9 = var2_2[218].call(variant);
        this.flavorName = ShortTypeHandling.castToString((Object)var9_9);
        if (!BytecodeInterface8.isOrigZ() || BuglyPlugin.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            ** if (!(ScriptBytecodeAdapter.compareNotEqual((Object)this.flavorName, null) != false && DefaultTypeTransformation.booleanUnbox((Object)var2_2[219].call((Object)this.flavorName)) == false != false)) goto lbl28
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.flavorName, null) != false && DefaultTypeTransformation.booleanUnbox((Object)var2_2[220].call((Object)this.flavorName)) == false != false) {
            // empty if block
        } else {
            ** GOTO lbl28
        }
lbl-1000:
        // 1 sources

        {
            // empty if block
        }
lbl28:
        // 5 sources

        var2_2[221].call(Logger.class, (Object)"Falvor name: %s", (Object)this.flavorName);
        var10_10 = var2_2[222].callGetProperty(var2_2[223].callGetProperty((Object)this.project));
        this.appId = ShortTypeHandling.castToString((Object)var10_10);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)var2_2[224].callGetProperty(variant), null) != false && DefaultTypeTransformation.booleanUnbox((Object)var2_2[225].call(var2_2[226].callGetProperty(variant), (Object)"buglyAppId")) != false) {
            var11_11 = var2_2[227].callGetProperty(var2_2[228].callGetProperty(variant));
            this.appId = ShortTypeHandling.castToString((Object)var11_11);
        }
        var2_2[229].call(Logger.class, (Object)"App ID: %s", var2_2[230].call((Object)"", (Object)this.appId));
        var12_12 = var2_2[231].callGetProperty(var2_2[232].callGetProperty((Object)this.project));
        this.appKey = ShortTypeHandling.castToString((Object)var12_12);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)var2_2[233].callGetProperty(variant), null) != false && DefaultTypeTransformation.booleanUnbox((Object)var2_2[234].call(var2_2[235].callGetProperty(variant), (Object)"buglyAppKey")) != false) {
            var13_13 = var2_2[236].callGetProperty(var2_2[237].callGetProperty(variant));
            this.appKey = ShortTypeHandling.castToString((Object)var13_13);
        }
        var2_2[238].call(Logger.class, (Object)"App key: %s", var2_2[239].call((Object)"", (Object)this.appKey));
        if (!BytecodeInterface8.isOrigZ() || BuglyPlugin.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.appId, null) != false || ScriptBytecodeAdapter.compareEqual((Object)this.appKey, null) != false) {
                var2_2[240].call(Logger.class, (Object)"App ID or App key has not been set, please check your setting!");
                return false;
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)this.appId, null) != false || ScriptBytecodeAdapter.compareEqual((Object)this.appKey, null) != false) {
            var2_2[241].call(Logger.class, (Object)"App ID or App key has not been set, please check your setting!");
            return false;
        }
        var14_14 = var2_2[242].callGetProperty(variant);
        this.appPackage = ShortTypeHandling.castToString((Object)var14_14);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)var2_2[243].callGetProperty(var2_2[244].callGetProperty((Object)this.project)), null)) {
            var15_15 = var2_2[245].callGetProperty(var2_2[246].callGetProperty((Object)this.project));
            this.appPackage = ShortTypeHandling.castToString((Object)var15_15);
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)var2_2[247].callGetProperty(variant), null) != false && DefaultTypeTransformation.booleanUnbox((Object)var2_2[248].call(var2_2[249].callGetProperty(variant), (Object)"buglyAppPackage")) != false) {
            var16_16 = var2_2[250].callGetProperty(var2_2[251].callGetProperty(variant));
            this.appPackage = ShortTypeHandling.castToString((Object)var16_16);
        }
        var2_2[252].call(Logger.class, (Object)"App package: %s", var2_2[253].call((Object)"", (Object)this.appPackage));
        var17_17 = var2_2[254].callCurrent((GroovyObject)this, variant);
        this.appVersion = ShortTypeHandling.castToString((Object)var17_17);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)var2_2[255].callGetProperty(var2_2[256].callGetProperty((Object)this.project)), null)) {
            var18_18 = var2_2[257].callGetProperty(var2_2[258].callGetProperty((Object)this.project));
            this.appVersion = ShortTypeHandling.castToString((Object)var18_18);
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)var2_2[259].callGetProperty(variant), null) != false && DefaultTypeTransformation.booleanUnbox((Object)var2_2[260].call(var2_2[261].callGetProperty(variant), (Object)"buglyAppVersion")) != false) {
            var19_19 = var2_2[262].callGetProperty(var2_2[263].callGetProperty(variant));
            this.appVersion = ShortTypeHandling.castToString((Object)var19_19);
        }
        var2_2[264].call(Logger.class, (Object)"App version: %s", var2_2[265].call((Object)"", (Object)this.appVersion));
        var20_20 = var2_2[266].callGetProperty(var2_2[267].callGetProperty((Object)this.project));
        this.appChannel = ShortTypeHandling.castToString((Object)var20_20);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)var2_2[268].callGetProperty(variant), null) != false && DefaultTypeTransformation.booleanUnbox((Object)var2_2[269].call(var2_2[270].callGetProperty(variant), (Object)"buglyAppChannel")) != false) {
            var21_21 = var2_2[271].callGetProperty(var2_2[272].callGetProperty(variant));
            this.appChannel = ShortTypeHandling.castToString((Object)var21_21);
        }
        if (!BytecodeInterface8.isOrigZ() || BuglyPlugin.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if ((ScriptBytecodeAdapter.compareEqual((Object)this.appChannel, null) != false && ScriptBytecodeAdapter.compareNotEqual((Object)this.flavorName, null) != false) != false && DefaultTypeTransformation.booleanUnbox((Object)var2_2[273].call((Object)this.flavorName)) == false != false) {
                this.appChannel = var22_22 = this.flavorName;
            }
        } else if ((ScriptBytecodeAdapter.compareEqual((Object)this.appChannel, null) != false && ScriptBytecodeAdapter.compareNotEqual((Object)this.flavorName, null) != false) != false && DefaultTypeTransformation.booleanUnbox((Object)var2_2[274].call((Object)this.flavorName)) == false != false) {
            this.appChannel = var23_23 = this.flavorName;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.appChannel, null)) {
            var2_2[275].call(Logger.class, (Object)"App channel: %s", (Object)this.appChannel);
        }
        if (BuglyPlugin.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            var24_24 = var2_2[276].callCurrent((GroovyObject)this);
            this.outputDirName = ShortTypeHandling.castToString((Object)var24_24);
        } else {
            this.outputDirName = var25_25 = this.getOutputDirName();
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.outputDirName, null)) {
            var2_2[277].call(Logger.class, (Object)"Output directory: %s", (Object)this.outputDirName);
        }
        return true;
    }

    private void clearLocalInfos() {
        CallSite[] callSiteArray = BuglyPlugin.$getCallSiteArray();
        callSiteArray[278].call((Object)this.symtabRecorder);
        callSiteArray[279].call((Object)this.uploadRecorder);
    }

    /*
     * WARNING - void declaration
     */
    private Task createUploadTask(Object variant, String taskName) {
        void var2_2;
        Reference variant2 = new Reference(variant);
        Reference taskName2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = BuglyPlugin.$getCallSiteArray();
        callSiteArray[280].call(Logger.class, (Object)"Create task(%s) for uploading symtab file to Bugly.", (Object)((String)taskName2.get()));
        class _createUploadTask_closure12
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference variant;
            private /* synthetic */ Reference taskName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createUploadTask_closure12(Object _outerInstance, Object _thisObject, Reference variant, Reference taskName) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _createUploadTask_closure12.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.variant = reference2 = variant;
                this.taskName = reference = taskName;
            }

            public Object doCall(Object it2) {
                CallSite[] callSiteArray = _createUploadTask_closure12.$getCallSiteArray();
                callSiteArray[0].call(Logger.class, (Object)"Run upload task in %s module.", (Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].callGroovyObjectGetProperty((Object)this)) ? "application" : "library"));
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callGetProperty(callSiteArray[3].callGetProperty(callSiteArray[4].callGroovyObjectGetProperty((Object)this))))) {
                    callSiteArray[5].call(Logger.class, (Object)"Execution of task(%s) is switch to disable.", this.taskName.get());
                    return null;
                }
                callSiteArray[6].call(Logger.class, (Object)"Initialize local environment information.");
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].callCurrent((GroovyObject)this, this.variant.get()))) {
                    return null;
                }
                Vector symbolFiles = (Vector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[8].callConstructor(Vector.class), Vector.class);
                Vector mappingFiles = (Vector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[9].callCurrent((GroovyObject)this), Vector.class);
                File file = null;
                Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[10].call((Object)mappingFiles), Iterator.class);
                while (iterator.hasNext()) {
                    file = (File)ScriptBytecodeAdapter.castToType(iterator.next(), File.class);
                    SymbolFile symbolFile = (SymbolFile)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].callConstructor(SymbolFile.class), SymbolFile.class);
                    Object object = callSiteArray[12].callGetProperty(SymbolFile.class);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, _createUploadTask_closure12.class, (GroovyObject)symbolFile, (String)"type");
                    Object object2 = callSiteArray[13].call((Object)file);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object2, _createUploadTask_closure12.class, (GroovyObject)symbolFile, (String)"fileName");
                    callSiteArray[14].call(Logger.class, (Object)"Pick a mapping file: %s", callSiteArray[15].callGroovyObjectGetProperty((Object)symbolFile));
                    callSiteArray[16].call((Object)symbolFiles, (Object)symbolFile);
                }
                Vector debugSoFiles = (Vector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[17].callCurrent((GroovyObject)this), Vector.class);
                File file2 = null;
                Iterator iterator2 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[18].call((Object)debugSoFiles), Iterator.class);
                while (iterator2.hasNext()) {
                    file2 = (File)ScriptBytecodeAdapter.castToType(iterator2.next(), File.class);
                    SymbolFile symbolFile = (SymbolFile)ScriptBytecodeAdapter.castToType((Object)callSiteArray[19].callConstructor(SymbolFile.class), SymbolFile.class);
                    Object object = callSiteArray[20].callGetProperty(SymbolFile.class);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, _createUploadTask_closure12.class, (GroovyObject)symbolFile, (String)"type");
                    Object object3 = callSiteArray[21].call((Object)file2);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object3, _createUploadTask_closure12.class, (GroovyObject)symbolFile, (String)"fileName");
                    callSiteArray[22].call(Logger.class, (Object)"Pick a debug so file: %s", callSiteArray[23].callGroovyObjectGetProperty((Object)symbolFile));
                    callSiteArray[24].call((Object)symbolFiles, (Object)symbolFile);
                }
                callSiteArray[25].callCurrent((GroovyObject)this, (Object)symbolFiles);
                return callSiteArray[26].callCurrent((GroovyObject)this);
            }

            public Object getVariant() {
                CallSite[] callSiteArray = _createUploadTask_closure12.$getCallSiteArray();
                return this.variant.get();
            }

            public String getTaskName() {
                CallSite[] callSiteArray = _createUploadTask_closure12.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.taskName.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createUploadTask_closure12.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createUploadTask_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "info";
                stringArray[1] = "isAppModule";
                stringArray[2] = "execute";
                stringArray[3] = "bugly";
                stringArray[4] = "project";
                stringArray[5] = "info";
                stringArray[6] = "debug";
                stringArray[7] = "initLocalInfos";
                stringArray[8] = "<$constructor$>";
                stringArray[9] = "getAllMappingFiles";
                stringArray[10] = "iterator";
                stringArray[11] = "<$constructor$>";
                stringArray[12] = "SYMBOL_TYPE_MAPPING";
                stringArray[13] = "getAbsolutePath";
                stringArray[14] = "debug";
                stringArray[15] = "fileName";
                stringArray[16] = "add";
                stringArray[17] = "getAllDebugSoFiles";
                stringArray[18] = "iterator";
                stringArray[19] = "<$constructor$>";
                stringArray[20] = "SYMBOL_TYPE_SYMBOL";
                stringArray[21] = "getAbsolutePath";
                stringArray[22] = "debug";
                stringArray[23] = "fileName";
                stringArray[24] = "add";
                stringArray[25] = "processFiles";
                stringArray[26] = "clearLocalInfos";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[27];
                _createUploadTask_closure12.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createUploadTask_closure12.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createUploadTask_closure12.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object buglyTask = callSiteArray[281].call(callSiteArray[282].call((Object)this.project, (Object)((String)taskName2.get())), (Object)new _createUploadTask_closure12(this, this, variant2, taskName2));
        String string = "bugly";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)buglyTask, (String)"group");
        return (Task)ScriptBytecodeAdapter.castToType((Object)buglyTask, Task.class);
    }

    public void apply(Project project) {
        Reference project2 = new Reference((Object)project);
        CallSite[] callSiteArray = BuglyPlugin.$getCallSiteArray();
        callSiteArray[283].call(System.class, (Object)"org.gradle.color.error", (Object)"RED");
        callSiteArray[284].call(System.class, (Object)"org.gradle.color.warn", (Object)"YELLOW");
        callSiteArray[285].call(System.class, (Object)"org.gradle.color.info", (Object)"BLUE");
        callSiteArray[286].call(callSiteArray[287].callGetProperty((Object)((Project)project2.get())), (Object)"bugly", BuglyPluginExtension.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[288].call((Object)((Project)project2.get()), (Object)"android"))) {
            return;
        }
        Project project3 = (Project)project2.get();
        this.project = (Project)ScriptBytecodeAdapter.castToType((Object)project3, Project.class);
        Object object = callSiteArray[289].call(callSiteArray[290].callGetProperty((Object)((Project)project2.get())));
        this.prjPath = ShortTypeHandling.castToString((Object)object);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[291].call(callSiteArray[292].callGetProperty((Object)((Project)project2.get())), (Object)"applicationVariants"))) {
            class _apply_closure13
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference project;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _apply_closure13(Object _outerInstance, Object _thisObject, Reference project) {
                    Reference reference;
                    CallSite[] callSiteArray = _apply_closure13.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.project = reference = project;
                }

                public Object doCall(Object variant) {
                    CallSite[] callSiteArray = _apply_closure13.$getCallSiteArray();
                    boolean bl2 = true;
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl2, BuglyPlugin.class, (GroovyObject)this.getThisObject(), (String)"isAppModule");
                    String variantName = ShortTypeHandling.castToString((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(variant)));
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callGetProperty(callSiteArray[3].callGetProperty(this.project.get())))) {
                        boolean bl3 = true;
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl3, BuglyPlugin.class, (GroovyObject)this.getThisObject(), (String)"isDebug");
                        callSiteArray[4].call(Logger.class, callSiteArray[5].callGetProperty(Logger.class));
                        callSiteArray[6].call(Logger.class, (Object)"Open debug mode for Bugly plugin.");
                    } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].call(callSiteArray[8].call((Object)variantName), (Object)"debug"))) {
                        return null;
                    }
                    String taskName = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{variantName}, new String[]{"upload", "SymtabFile"}));
                    callSiteArray[9].call(Logger.class, (Object)"Craete task for application module: %s", (Object)taskName);
                    Task buglyTask = (Task)ScriptBytecodeAdapter.castToType((Object)callSiteArray[10].callCurrent((GroovyObject)this, variant, (Object)taskName), Task.class);
                    Task dependTask = (Task)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].call(callSiteArray[12].callGetProperty(this.project.get()), (Object)new GStringImpl(new Object[]{variantName}, new String[]{"package", ""})), Task.class);
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)dependTask, null)) {
                        callSiteArray[13].call((Object)buglyTask, (Object)dependTask);
                        callSiteArray[14].call(Logger.class, (Object)"Upload task depends on %s.", callSiteArray[15].call((Object)dependTask));
                    }
                    return callSiteArray[16].call(callSiteArray[17].call(callSiteArray[18].callGetProperty(this.project.get()), (Object)new GStringImpl(new Object[]{variantName}, new String[]{"assemble", ""})), (Object)buglyTask);
                }

                public Project getProject() {
                    CallSite[] callSiteArray = _apply_closure13.$getCallSiteArray();
                    return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _apply_closure13.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "capitalize";
                    stringArray[1] = "name";
                    stringArray[2] = "debug";
                    stringArray[3] = "bugly";
                    stringArray[4] = "setLogLevel";
                    stringArray[5] = "DEBUG_LEVEL";
                    stringArray[6] = "debug";
                    stringArray[7] = "contains";
                    stringArray[8] = "toLowerCase";
                    stringArray[9] = "debug";
                    stringArray[10] = "createUploadTask";
                    stringArray[11] = "findByName";
                    stringArray[12] = "tasks";
                    stringArray[13] = "dependsOn";
                    stringArray[14] = "debug";
                    stringArray[15] = "getName";
                    stringArray[16] = "dependsOn";
                    stringArray[17] = "getAt";
                    stringArray[18] = "tasks";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[19];
                    _apply_closure13.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_apply_closure13.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _apply_closure13.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[293].call(callSiteArray[294].callGetProperty(callSiteArray[295].callGetProperty((Object)((Project)project2.get()))), (Object)new _apply_closure13(this, this, project2));
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[296].call(callSiteArray[297].callGetProperty((Object)((Project)project2.get())), (Object)"libraryVariants"))) {
            class _apply_closure14
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference project;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _apply_closure14(Object _outerInstance, Object _thisObject, Reference project) {
                    Reference reference;
                    CallSite[] callSiteArray = _apply_closure14.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.project = reference = project;
                }

                public Object doCall(Object variant) {
                    CallSite[] callSiteArray = _apply_closure14.$getCallSiteArray();
                    boolean bl2 = false;
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl2, BuglyPlugin.class, (GroovyObject)this.getThisObject(), (String)"isAppModule");
                    String variantName = ShortTypeHandling.castToString((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(variant)));
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callGetProperty(callSiteArray[3].callGetProperty(this.project.get())))) {
                        boolean bl3 = true;
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl3, BuglyPlugin.class, (GroovyObject)this.getThisObject(), (String)"isDebug");
                        callSiteArray[4].call(Logger.class, callSiteArray[5].callGetProperty(Logger.class));
                        callSiteArray[6].call(Logger.class, (Object)"Open debug mode for Bugly plugin.");
                    } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].call(callSiteArray[8].call((Object)variantName), (Object)"debug"))) {
                        return null;
                    }
                    String taskName = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{variantName}, new String[]{"upload", "SymtabFile"}));
                    callSiteArray[9].call(Logger.class, (Object)"Craete Task for library module: %s", (Object)taskName);
                    Task buglyTask = (Task)ScriptBytecodeAdapter.castToType((Object)callSiteArray[10].callCurrent((GroovyObject)this, variant, (Object)taskName), Task.class);
                    Task dependTask = (Task)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].call(callSiteArray[12].callGetProperty(this.project.get()), (Object)new GStringImpl(new Object[]{variantName}, new String[]{"bundle", ""})), Task.class);
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)dependTask, null)) {
                        callSiteArray[13].call((Object)buglyTask, (Object)dependTask);
                        callSiteArray[14].call(Logger.class, (Object)"Upload task depends on %s.", callSiteArray[15].call((Object)dependTask));
                    }
                    return callSiteArray[16].call(callSiteArray[17].call(callSiteArray[18].callGetProperty(this.project.get()), (Object)new GStringImpl(new Object[]{variantName}, new String[]{"assemble", ""})), (Object)buglyTask);
                }

                public Project getProject() {
                    CallSite[] callSiteArray = _apply_closure14.$getCallSiteArray();
                    return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _apply_closure14.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "capitalize";
                    stringArray[1] = "name";
                    stringArray[2] = "debug";
                    stringArray[3] = "bugly";
                    stringArray[4] = "setLogLevel";
                    stringArray[5] = "DEBUG_LEVEL";
                    stringArray[6] = "debug";
                    stringArray[7] = "contains";
                    stringArray[8] = "toLowerCase";
                    stringArray[9] = "debug";
                    stringArray[10] = "createUploadTask";
                    stringArray[11] = "findByName";
                    stringArray[12] = "tasks";
                    stringArray[13] = "dependsOn";
                    stringArray[14] = "debug";
                    stringArray[15] = "getName";
                    stringArray[16] = "dependsOn";
                    stringArray[17] = "getAt";
                    stringArray[18] = "tasks";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[19];
                    _apply_closure14.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_apply_closure14.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _apply_closure14.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[298].call(callSiteArray[299].callGetProperty(callSiteArray[300].callGetProperty((Object)((Project)project2.get()))), (Object)new _apply_closure14(this, this, project2));
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BuglyPlugin.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = BuglyPlugin.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(BuglyPlugin.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = BuglyPlugin.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, BuglyPlugin.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = BuglyPlugin.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(BuglyPlugin.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getSoFileUuid";
        stringArray[1] = "iterator";
        stringArray[2] = "containsKey";
        stringArray[3] = "equals";
        stringArray[4] = "get";
        stringArray[5] = "containsKey";
        stringArray[6] = "equals";
        stringArray[7] = "get";
        stringArray[8] = "containsKey";
        stringArray[9] = "debug";
        stringArray[10] = "get";
        stringArray[11] = "exists";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "<$constructor$>";
        stringArray[14] = "leftShift";
        stringArray[15] = "leftShift";
        stringArray[16] = "leftShift";
        stringArray[17] = "leftShift";
        stringArray[18] = "leftShift";
        stringArray[19] = "main";
        stringArray[20] = "toArray";
        stringArray[21] = "extracted";
        stringArray[22] = "warn";
        stringArray[23] = "symtabFileName";
        stringArray[24] = "debug";
        stringArray[25] = "<$constructor$>";
        stringArray[26] = "put";
        stringArray[27] = "put";
        stringArray[28] = "put";
        stringArray[29] = "record";
        stringArray[30] = "type";
        stringArray[31] = "SYMBOL_TYPE_MAPPING";
        stringArray[32] = "info";
        stringArray[33] = "endsWith";
        stringArray[34] = "fileName";
        stringArray[35] = "error";
        stringArray[36] = "fileName";
        stringArray[37] = "SYMBOL_TYPE_SYMBOL";
        stringArray[38] = "info";
        stringArray[39] = "endsWith";
        stringArray[40] = "fileName";
        stringArray[41] = "error";
        stringArray[42] = "fileName";
        stringArray[43] = "info";
        stringArray[44] = "type";
        stringArray[45] = "getFileSha1";
        stringArray[46] = "fileName";
        stringArray[47] = "iterator";
        stringArray[48] = "containsKey";
        stringArray[49] = "equals";
        stringArray[50] = "get";
        stringArray[51] = "fileName";
        stringArray[52] = "containsKey";
        stringArray[53] = "equals";
        stringArray[54] = "get";
        stringArray[55] = "containsKey";
        stringArray[56] = "equals";
        stringArray[57] = "get";
        stringArray[58] = "type";
        stringArray[59] = "SYMBOL_TYPE_MAPPING";
        stringArray[60] = "containsKey";
        stringArray[61] = "equals";
        stringArray[62] = "get";
        stringArray[63] = "containsKey";
        stringArray[64] = "equals";
        stringArray[65] = "get";
        stringArray[66] = "containsKey";
        stringArray[67] = "equals";
        stringArray[68] = "get";
        stringArray[69] = "info";
        stringArray[70] = "info";
        stringArray[71] = "fileName";
        stringArray[72] = "setLogPrinter";
        stringArray[73] = "setDebugMode";
        stringArray[74] = "setDebugMode";
        stringArray[75] = "<$constructor$>";
        stringArray[76] = "<$constructor$>";
        stringArray[77] = "fileName";
        stringArray[78] = "getName";
        stringArray[79] = "type";
        stringArray[80] = "SYMBOL_TYPE_MAPPING";
        stringArray[81] = "SYMBOL_TYPE_JAVA";
        stringArray[82] = "format";
        stringArray[83] = "fileName";
        stringArray[84] = "SYMBOL_TYPE_SYMBOL";
        stringArray[85] = "SYMBOL_TYPE_NATIVE";
        stringArray[86] = "info";
        stringArray[87] = "type";
        stringArray[88] = "uploadSymtabFile";
        stringArray[89] = "info";
        stringArray[90] = "debug";
        stringArray[91] = "fileName";
        stringArray[92] = "<$constructor$>";
        stringArray[93] = "put";
        stringArray[94] = "fileName";
        stringArray[95] = "put";
        stringArray[96] = "put";
        stringArray[97] = "type";
        stringArray[98] = "SYMBOL_TYPE_MAPPING";
        stringArray[99] = "put";
        stringArray[100] = "put";
        stringArray[101] = "put";
        stringArray[102] = "record";
        stringArray[103] = "warn";
        stringArray[104] = "isEmpty";
        stringArray[105] = "debug";
        stringArray[106] = "readAllRecords";
        stringArray[107] = "debug";
        stringArray[108] = "size";
        stringArray[109] = "size";
        stringArray[110] = "recreate";
        stringArray[111] = "info";
        stringArray[112] = "debug";
        stringArray[113] = "readAllRecords";
        stringArray[114] = "debug";
        stringArray[115] = "size";
        stringArray[116] = "size";
        stringArray[117] = "recreate";
        stringArray[118] = "each";
        stringArray[119] = "<$constructor$>";
        stringArray[120] = "isEmpty";
        stringArray[121] = "plus";
        stringArray[122] = "isEmpty";
        stringArray[123] = "plus";
        stringArray[124] = "plus";
        stringArray[125] = "plus";
        stringArray[126] = "fileTree";
        stringArray[127] = "buildDir";
        stringArray[128] = "isEmpty";
        stringArray[129] = "fileTree";
        stringArray[130] = "projectDir";
        stringArray[131] = "isEmpty";
        stringArray[132] = "fileTree";
        stringArray[133] = "projectDir";
        stringArray[134] = "addAll";
        stringArray[135] = "files";
        stringArray[136] = "<$constructor$>";
        stringArray[137] = "each";
        stringArray[138] = "withType";
        stringArray[139] = "getDependencies";
        stringArray[140] = "compile";
        stringArray[141] = "configurations";
        stringArray[142] = "addAll";
        stringArray[143] = "getDebugSoFiles";
        stringArray[144] = "hasProperty";
        stringArray[145] = "<$constructor$>";
        stringArray[146] = "hasProperty";
        stringArray[147] = "android";
        stringArray[148] = "all";
        stringArray[149] = "applicationVariants";
        stringArray[150] = "android";
        stringArray[151] = "hasProperty";
        stringArray[152] = "android";
        stringArray[153] = "all";
        stringArray[154] = "libraryVariants";
        stringArray[155] = "android";
        stringArray[156] = "isEmpty";
        stringArray[157] = "isEmpty";
        stringArray[158] = "plus";
        stringArray[159] = "plus";
        stringArray[160] = "plus";
        stringArray[161] = "fileTree";
        stringArray[162] = "buildDir";
        stringArray[163] = "isEmpty";
        stringArray[164] = "fileTree";
        stringArray[165] = "projectDir";
        stringArray[166] = "isEmpty";
        stringArray[167] = "fileTree";
        stringArray[168] = "projectDir";
        stringArray[169] = "addAll";
        stringArray[170] = "files";
        stringArray[171] = "<$constructor$>";
        stringArray[172] = "each";
        stringArray[173] = "withType";
        stringArray[174] = "getDependencies";
        stringArray[175] = "compile";
        stringArray[176] = "configurations";
        stringArray[177] = "getMappingFile";
        stringArray[178] = "addAll";
        stringArray[179] = "exists";
        stringArray[180] = "<$constructor$>";
        stringArray[181] = "mkdirs";
        stringArray[182] = "<$constructor$>";
        stringArray[183] = "warn";
        stringArray[184] = "getAbsolutePath";
        stringArray[185] = "<$constructor$>";
        stringArray[186] = "outputDir";
        stringArray[187] = "bugly";
        stringArray[188] = "getDirName";
        stringArray[189] = "hasProperty";
        stringArray[190] = "android";
        stringArray[191] = "getVersionName";
        stringArray[192] = "isEmpty";
        stringArray[193] = "versionName";
        stringArray[194] = "defaultConfig";
        stringArray[195] = "android";
        stringArray[196] = "isEmpty";
        stringArray[197] = "getVersionName";
        stringArray[198] = "<$constructor$>";
        stringArray[199] = "srcFile";
        stringArray[200] = "manifest";
        stringArray[201] = "main";
        stringArray[202] = "sourceSets";
        stringArray[203] = "android";
        stringArray[204] = "getDirName";
        stringArray[205] = "plus";
        stringArray[206] = "plus";
        stringArray[207] = "separator";
        stringArray[208] = "<$constructor$>";
        stringArray[209] = "<$constructor$>";
        stringArray[210] = "<$constructor$>";
        stringArray[211] = "<$constructor$>";
        stringArray[212] = "upload";
        stringArray[213] = "bugly";
        stringArray[214] = "uploadMapping";
        stringArray[215] = "bugly";
        stringArray[216] = "uploadSymbol";
        stringArray[217] = "bugly";
        stringArray[218] = "getFlavorName";
        stringArray[219] = "isEmpty";
        stringArray[220] = "isEmpty";
        stringArray[221] = "debug";
        stringArray[222] = "appId";
        stringArray[223] = "bugly";
        stringArray[224] = "ext";
        stringArray[225] = "has";
        stringArray[226] = "ext";
        stringArray[227] = "buglyAppId";
        stringArray[228] = "ext";
        stringArray[229] = "debug";
        stringArray[230] = "plus";
        stringArray[231] = "appKey";
        stringArray[232] = "bugly";
        stringArray[233] = "ext";
        stringArray[234] = "has";
        stringArray[235] = "ext";
        stringArray[236] = "buglyAppKey";
        stringArray[237] = "ext";
        stringArray[238] = "debug";
        stringArray[239] = "plus";
        stringArray[240] = "error";
        stringArray[241] = "error";
        stringArray[242] = "applicationId";
        stringArray[243] = "appPackage";
        stringArray[244] = "bugly";
        stringArray[245] = "appPackage";
        stringArray[246] = "bugly";
        stringArray[247] = "ext";
        stringArray[248] = "has";
        stringArray[249] = "ext";
        stringArray[250] = "buglyAppPackage";
        stringArray[251] = "ext";
        stringArray[252] = "debug";
        stringArray[253] = "plus";
        stringArray[254] = "getVersionName";
        stringArray[255] = "appVersion";
        stringArray[256] = "bugly";
        stringArray[257] = "appVersion";
        stringArray[258] = "bugly";
        stringArray[259] = "ext";
        stringArray[260] = "has";
        stringArray[261] = "ext";
        stringArray[262] = "buglyAppVersion";
        stringArray[263] = "ext";
        stringArray[264] = "debug";
        stringArray[265] = "plus";
        stringArray[266] = "appChannel";
        stringArray[267] = "bugly";
        stringArray[268] = "ext";
        stringArray[269] = "has";
        stringArray[270] = "ext";
        stringArray[271] = "buglyAppChannel";
        stringArray[272] = "ext";
        stringArray[273] = "isEmpty";
        stringArray[274] = "isEmpty";
        stringArray[275] = "debug";
        stringArray[276] = "getOutputDirName";
        stringArray[277] = "debug";
        stringArray[278] = "close";
        stringArray[279] = "close";
        stringArray[280] = "debug";
        stringArray[281] = "doLast";
        stringArray[282] = "task";
        stringArray[283] = "setProperty";
        stringArray[284] = "setProperty";
        stringArray[285] = "setProperty";
        stringArray[286] = "create";
        stringArray[287] = "extensions";
        stringArray[288] = "hasProperty";
        stringArray[289] = "getAbsolutePath";
        stringArray[290] = "projectDir";
        stringArray[291] = "hasProperty";
        stringArray[292] = "android";
        stringArray[293] = "all";
        stringArray[294] = "applicationVariants";
        stringArray[295] = "android";
        stringArray[296] = "hasProperty";
        stringArray[297] = "android";
        stringArray[298] = "all";
        stringArray[299] = "libraryVariants";
        stringArray[300] = "android";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[301];
        BuglyPlugin.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(BuglyPlugin.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = BuglyPlugin.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    private static /* synthetic */ Class $get$$class$com$android$builder$core$DefaultManifestParser() {
        Class clazz = $class$com$android$builder$core$DefaultManifestParser;
        if (clazz == null) {
            clazz = $class$com$android$builder$core$DefaultManifestParser = BuglyPlugin.class$("com.android.builder.core.DefaultManifestParser");
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class SymbolFile
    implements GroovyObject {
        public static final int SYMBOL_TYPE_MAPPING = 1;
        public static final int SYMBOL_TYPE_SYMBOL = 2;
        public int type;
        public String fileName;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public SymbolFile() {
            MetaClass metaClass;
            int n2;
            CallSite[] callSiteArray = SymbolFile.$getCallSiteArray();
            this.type = n2 = 0;
            Object var3_3 = null;
            this.fileName = ShortTypeHandling.castToString(var3_3);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != SymbolFile.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = SymbolFile.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(SymbolFile.class, BuglyPlugin.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = SymbolFile.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, BuglyPlugin.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = SymbolFile.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(SymbolFile.class, BuglyPlugin.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(SymbolFile.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = SymbolFile.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

