/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.symtabtool.common.upload;

import com.tencent.bugly.symtabtool.common.upload.a;
import com.tencent.bugly.symtabtool.common.utils.Utils;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SymtabFileUploader {
    public static final String BUGLY_VERSION_2X = "2.x";

    private static boolean a(UploadInfo object) {
        Object object2 = object;
        Serializable serializable = new StringBuilder();
        if (!((UploadInfo)object2).isRqd) {
            ((StringBuilder)serializable).append("https://api.bugly.qq.com/openapi/file/upload/symbol");
        } else {
            ((StringBuilder)serializable).append("http://api.bugly.ext.wsd.com/openapi/file/upload/symbol");
        }
        ((StringBuilder)serializable).append("?");
        ((StringBuilder)serializable).append(Utils.urlEncodeString("app_key"));
        ((StringBuilder)serializable).append("=");
        ((StringBuilder)serializable).append(Utils.urlEncodeString(((UploadInfo)object2).appKey));
        ((StringBuilder)serializable).append("&");
        ((StringBuilder)serializable).append(Utils.urlEncodeString("app_id"));
        ((StringBuilder)serializable).append("=");
        ((StringBuilder)serializable).append(Utils.urlEncodeString(((UploadInfo)object2).appId));
        object2 = ((StringBuilder)serializable).toString();
        serializable = new HashMap<String, String>();
        serializable.put("api_version", "1");
        serializable.put("app_id", ((UploadInfo)object).appId);
        serializable.put("app_key", ((UploadInfo)object).appKey);
        serializable.put("symbolType", ((UploadInfo)object).symbolType);
        serializable.put("fileName", ((UploadInfo)object).fileName);
        if (((UploadInfo)object).appPackage != null) {
            serializable.put("bundleId", ((UploadInfo)object).appPackage);
        }
        if (((UploadInfo)object).appVersion != null) {
            serializable.put("productVersion", ((UploadInfo)object).appVersion);
        }
        int n2 = 1;
        if (((UploadInfo)object).symbolType.equals("1")) {
            if (((UploadInfo)object).appChannel != null) {
                serializable.put("channel", ((UploadInfo)object).appChannel);
            }
            serializable.put("productVersion", ((UploadInfo)object).appVersion);
            n2 = 0;
        }
        if ((object = a.a((String)object2, true, ((UploadInfo)object).file, n2, (Map<String, String>)((Object)serializable))) != null && ((a.a)object).a != null && ((Matcher)(object = ((Pattern)(object2 = Pattern.compile("\"reponseCode\":\"([\\d]+)\""))).matcher(((a.a)object).a))).find() && ((Matcher)object).groupCount() == 1) {
            try {
                int n3 = Integer.parseInt(((Matcher)object).group(1));
                if (n3 == 0) {
                    return true;
                }
                com.tencent.bugly.symtabtool.common.utils.a.c("ReponseCode from server is %s.", ((Matcher)object).group(1));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return false;
    }

    public static boolean uploadSymtabFile(UploadInfo uploadInfo) {
        if (!uploadInfo.validate()) {
            com.tencent.bugly.symtabtool.common.utils.a.a("Can not upload symtab file.", new Object[0]);
            return false;
        }
        Object object = uploadInfo;
        StringBuilder stringBuilder = new StringBuilder();
        if (((UploadInfo)object).buglyVersion != null && ((UploadInfo)object).buglyVersion.equals(BUGLY_VERSION_2X)) {
            stringBuilder.append("https://bugly.qq.com/v2/crash-reporting/preferences/dsyms");
            stringBuilder.append("/");
            stringBuilder.append(((UploadInfo)object).appId);
            stringBuilder.append("?pid=");
            if (((UploadInfo)object).symbolType.equals("2")) {
                stringBuilder.append("2");
            } else {
                stringBuilder.append("1");
            }
        } else {
            stringBuilder.append("http://bugly.qq.com/manage");
            stringBuilder.append("?app=");
            stringBuilder.append(((UploadInfo)object).appId);
            stringBuilder.append("&");
            if (((UploadInfo)object).symbolType.equals("1") || ((UploadInfo)object).symbolType.equals("3")) {
                stringBuilder.append("pid=1");
            } else if (((UploadInfo)object).symbolType.equals("2")) {
                stringBuilder.append("pid=2");
            }
        }
        object = stringBuilder.toString();
        com.tencent.bugly.symtabtool.common.utils.a.a("Upload symbol file: %s", uploadInfo.fileName);
        for (int i2 = 0; i2 < 2; ++i2) {
            if (i2 > 0) {
                Utils.sleep(3000L);
            }
            if (!SymtabFileUploader.a(uploadInfo)) continue;
            com.tencent.bugly.symtabtool.common.utils.a.a("Successfully uploaded.", new Object[0]);
            return true;
        }
        com.tencent.bugly.symtabtool.common.utils.a.d("Failed to upload symtab file.", new Object[0]);
        com.tencent.bugly.symtabtool.common.utils.a.a("You can manually upload the file on Bugly website: %s", object);
        com.tencent.bugly.symtabtool.common.utils.a.a("The file should be manually uploaded is: %s", uploadInfo.file.getAbsolutePath());
        return false;
    }

    public static class UploadInfo {
        public static final String SYMBOL_TYPE_JAVA = "1";
        public static final String SYMBOL_TYPE_IOS = "2";
        public static final String SYMBOL_TYPE_NATIVE = "3";
        public String appId = null;
        public String appKey = null;
        public String appChannel = null;
        public String appPackage = null;
        public String appVersion = null;
        public String symbolType = null;
        public String fileName = null;
        public String buglyVersion = "2.x";
        public File file = null;
        public boolean isRqd = false;

        public boolean validate() {
            if (this.appId == null) {
                com.tencent.bugly.symtabtool.common.utils.a.c("Uploading info is missing: APP ID", new Object[0]);
                return false;
            }
            if (this.appKey == null) {
                com.tencent.bugly.symtabtool.common.utils.a.c("Uploading info is missing: APP key", new Object[0]);
                return false;
            }
            if (this.symbolType == null) {
                com.tencent.bugly.symtabtool.common.utils.a.c("Uploading info is missing: symbol type", new Object[0]);
                return false;
            }
            if (this.file == null) {
                com.tencent.bugly.symtabtool.common.utils.a.c("Uploading info is missing: file", new Object[0]);
                return false;
            }
            if (this.fileName == null) {
                com.tencent.bugly.symtabtool.common.utils.a.c("Uploading info is missing: file name", new Object[0]);
                return false;
            }
            if (this.buglyVersion != null && this.buglyVersion.equals(SymtabFileUploader.BUGLY_VERSION_2X)) {
                if (this.symbolType.equals(SYMBOL_TYPE_JAVA) && this.appVersion == null) {
                    com.tencent.bugly.symtabtool.common.utils.a.c("Uploading info is missing: APP version", new Object[0]);
                    return false;
                }
                return true;
            }
            if (this.appPackage == null) {
                com.tencent.bugly.symtabtool.common.utils.a.b("Uploading info for Bugly 1.x is missing: APP package", new Object[0]);
                return false;
            }
            if (this.appVersion == null) {
                com.tencent.bugly.symtabtool.common.utils.a.b("Uploading info for Bugly 1.x is missing: APP version", new Object[0]);
                return false;
            }
            return true;
        }
    }
}

