/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.build.gradle.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipFile;

public class FileUtils {
    public static final int BUFFER_SIZE = 16384;

    public static final boolean deleteDir(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        if (file.isFile()) {
            file.delete();
        } else if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileUtils.deleteDir(files[i]);
            }
        }
        file.delete();
        return true;
    }

    public static void cleanDir(File dir) {
        if (dir.exists()) {
            FileUtils.deleteDir(dir);
            dir.mkdirs();
        }
    }

    public static boolean isLegalFile(String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        return file.exists() && file.isFile() && file.length() > 0L;
    }

    public static boolean isLegalFileOrDirectory(String path) {
        if (FileUtils.isLegalFile(path)) {
            return true;
        }
        if (path == null) {
            return false;
        }
        File file = new File(path);
        return file.exists() && file.isDirectory() && file.canRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileUsingStream(File source, File dest) throws IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        File parent = dest.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(dest, false);
            byte[] buffer = new byte[16384];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        catch (Throwable throwable) {
            FileUtils.closeQuietly(os);
            FileUtils.closeQuietly(is);
            throw throwable;
        }
        FileUtils.closeQuietly(os);
        FileUtils.closeQuietly(is);
    }

    public static void closeQuietly(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            if (obj instanceof Closeable) {
                ((Closeable)obj).close();
            } else if (obj instanceof AutoCloseable) {
                ((AutoCloseable)obj).close();
            } else if (obj instanceof ZipFile) {
                ((ZipFile)obj).close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

