/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.common.looper;

import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.SystemClock;
import android.util.Printer;
import com.tencent.bugly.common.looper.ILooperDispatchListener;
import com.tencent.bugly.common.looper.LooperPrinter;
import com.tencent.bugly.common.utils.AndroidVersion;
import com.tencent.bugly.proguard.k2;
import com.tencent.bugly.proguard.ne;
import com.tencent.bugly.proguard.ye;
import com.tencent.rmonitor.base.config.b;
import com.tencent.rmonitor.common.logger.Logger;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u000f\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0001-B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u0010\u0015\u001a\u00020\u0012J\u0006\u0010\u0016\u001a\u00020\u0012J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u0012J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u0018J\u0018\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\tH\u0002J\u0018\u0010$\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\b\u0010%\u001a\u00020\u0007H\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010&\u001a\u00020\u0007H\u0016J\b\u0010'\u001a\u00020\u0012H\u0002J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u000e\u0010)\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\fJ\u0010\u0010*\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010+\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010,\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/tencent/bugly/common/looper/LooperDispatchWatcher;", "Landroid/os/MessageQueue$IdleHandler;", "Lcom/tencent/bugly/common/looper/LooperPrinter$IDispatch;", "looper", "Landroid/os/Looper;", "(Landroid/os/Looper;)V", "isStart", "", "lastCheckPrinterTime", "", "listeners", "Ljava/util/HashSet;", "Lcom/tencent/bugly/common/looper/ILooperDispatchListener;", "Lkotlin/collections/HashSet;", "printer", "Lcom/tencent/bugly/common/looper/LooperPrinter;", "startTime", "addIdleHandler", "", "addListener", "listener", "checkAndStart", "checkAndStop", "checkValid", "Landroid/util/Printer;", "clearListeners", "dealOriginPrinter", "originPrinter", "dispatch", "isBegin", "log", "", "dispatchEnd", "msg", "endTime", "duration", "dispatchStart", "ignoreOriginPrinter", "queueIdle", "release", "removeIdleHandler", "removeListener", "resetPrinter", "resetPrinterWithOriginPrinter", "resetPrinterWithoutOriginPrinter", "Companion", "bugly-pro_release"})
public final class LooperDispatchWatcher
implements MessageQueue.IdleHandler,
LooperPrinter.IDispatch {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "RMonitor_looper_DispatchWatcher";
    private static final long CHECK_TIME_IN_MS = 60000L;
    private static final int MAX_CHECK_COUNT = 100;
    @NotNull
    private static final ThreadLocal<LooperDispatchWatcher> watcher = new ThreadLocal();
    @NotNull
    private static final ConcurrentHashMap<Looper, Handler> handlerMap = new ConcurrentHashMap();
    @NotNull
    private final Looper looper;
    @NotNull
    private final HashSet<ILooperDispatchListener> listeners;
    @Nullable
    private LooperPrinter printer;
    private long lastCheckPrinterTime;
    private boolean isStart;
    private long startTime;

    public LooperDispatchWatcher(@NotNull Looper looper) {
        HashSet hashSet;
        Intrinsics.checkNotNullParameter((Object)looper, (String)"looper");
        ((LooperDispatchWatcher)((Object)hashSet2)).looper = looper;
        HashSet hashSet2 = hashSet;
        hashSet = new HashSet();
        v1.listeners = hashSet2;
    }

    private final synchronized void release() {
        LooperPrinter looperPrinter = this.printer;
        if (looperPrinter != null) {
            if (Logger.verbos) {
                Logger.INSTANCE.v(TAG, "release printer[" + looperPrinter + "] originPrinter[" + looperPrinter.getOrigin() + "] in " + this.looper.getThread().getName());
            }
            LooperDispatchWatcher looperDispatchWatcher = this;
            looperDispatchWatcher.looper.setMessageLogging(looperPrinter.getOrigin());
            looperDispatchWatcher.removeIdleHandler(looperDispatchWatcher.looper);
        }
        this.printer = null;
    }

    private final synchronized void addIdleHandler(Looper looper) {
        if (AndroidVersion.Companion.isOverM()) {
            looper.getQueue().addIdleHandler((MessageQueue.IdleHandler)this);
        } else {
            try {
                ye.b(looper).addIdleHandler((MessageQueue.IdleHandler)this);
            }
            catch (Throwable throwable) {
                Logger.INSTANCE.exception(TAG, "addIdleHandler in " + looper.getThread().getName() + ", ", throwable);
            }
        }
    }

    private final synchronized void removeIdleHandler(Looper looper) {
        if (AndroidVersion.Companion.isOverM()) {
            looper.getQueue().removeIdleHandler((MessageQueue.IdleHandler)this);
        } else {
            try {
                ye.b(looper).removeIdleHandler((MessageQueue.IdleHandler)this);
            }
            catch (Throwable throwable) {
                Logger.INSTANCE.exception(TAG, "removeIdleHandler in " + looper.getThread().getName() + ", ", throwable);
            }
        }
    }

    private final synchronized void resetPrinter(Looper looper) {
        if (this.ignoreOriginPrinter()) {
            this.resetPrinterWithoutOriginPrinter(looper);
        } else {
            this.resetPrinterWithOriginPrinter(looper);
        }
    }

    private final void resetPrinterWithoutOriginPrinter(Looper looper) {
        if (this.printer == null) {
            LooperPrinter looperPrinter;
            LooperPrinter looperPrinter2 = looperPrinter;
            looperPrinter = new LooperPrinter(null, this);
            this.printer = looperPrinter2;
        }
        looper.setMessageLogging((Printer)this.printer);
    }

    private final void resetPrinterWithOriginPrinter(Looper looper) {
        LooperPrinter looperPrinter;
        LooperPrinter looperPrinter2;
        Printer printer = ye.a(looper);
        if (printer == (looperPrinter2 = this.printer) && looperPrinter2 != null) {
            return;
        }
        if (looperPrinter2 != null) {
            Logger.INSTANCE.w(TAG, "resetPrinter maybe printer[" + this.printer + "] was replace by other[" + printer + "] in " + looper.getThread().getName() + ' ');
        }
        looperPrinter2 = looperPrinter;
        this.printer = new LooperPrinter(this.dealOriginPrinter(printer), this);
        looper.setMessageLogging((Printer)looperPrinter2);
        if (printer != null || Logger.debug) {
            Logger.INSTANCE.w(TAG, "resetPrinter printer[" + this.printer + "] originPrinter[" + printer + "] in " + looper.getThread().getName());
        }
    }

    private final boolean ignoreOriginPrinter() {
        boolean bl = false;
        ne ne2 = b.c.a().a("common");
        if (ne2 instanceof k2 && ((k2)ne2).c()) {
            bl = true;
        }
        return bl;
    }

    private final void dispatchStart(String string, long l10) {
        for (ILooperDispatchListener iLooperDispatchListener : ((LooperDispatchWatcher)this).listeners) {
            if (!iLooperDispatchListener.isOpen()) continue;
            iLooperDispatchListener.onDispatchStart(string, l10);
        }
    }

    private final void dispatchEnd(String string, long l10, long l11) {
        for (ILooperDispatchListener iLooperDispatchListener : ((LooperDispatchWatcher)this).listeners) {
            if (!iLooperDispatchListener.isOpen()) continue;
            iLooperDispatchListener.onDispatchEnd(string, l10, l11);
        }
    }

    public final boolean isStart() {
        return this.isStart;
    }

    public final void checkAndStart() {
        if (!this.isStart && this.listeners.size() != 0) {
            LooperDispatchWatcher looperDispatchWatcher = this;
            Logger.INSTANCE.d(TAG, "checkAndStart in " + this.looper.getThread().getName());
            looperDispatchWatcher.isStart = true;
            looperDispatchWatcher.resetPrinter(looperDispatchWatcher.looper);
            looperDispatchWatcher.addIdleHandler(looperDispatchWatcher.looper);
            return;
        }
    }

    public final void checkAndStop() {
        if (this.isStart && this.listeners.size() <= 0) {
            Logger.INSTANCE.d(TAG, "checkAndStop in " + this.looper.getThread().getName());
            this.release();
            this.isStart = false;
            return;
        }
    }

    public final void addListener(@NotNull ILooperDispatchListener iLooperDispatchListener) {
        Intrinsics.checkNotNullParameter((Object)iLooperDispatchListener, (String)"listener");
        this.listeners.add(iLooperDispatchListener);
    }

    public final void removeListener(@NotNull ILooperDispatchListener iLooperDispatchListener) {
        Intrinsics.checkNotNullParameter((Object)iLooperDispatchListener, (String)"listener");
        this.listeners.remove(iLooperDispatchListener);
    }

    public final void clearListeners() {
        this.listeners.clear();
    }

    public boolean queueIdle() {
        if (SystemClock.uptimeMillis() - this.lastCheckPrinterTime >= 60000L) {
            LooperDispatchWatcher looperDispatchWatcher = this;
            looperDispatchWatcher.resetPrinter(looperDispatchWatcher.looper);
            looperDispatchWatcher.lastCheckPrinterTime = SystemClock.uptimeMillis();
        }
        return true;
    }

    @Nullable
    public final Printer dealOriginPrinter(@Nullable Printer printer) {
        int n10 = 0;
        while (printer instanceof LooperPrinter) {
            printer = ((LooperPrinter)printer).getOrigin();
            if (++n10 < 100) continue;
            printer = null;
            break;
        }
        return printer;
    }

    @Override
    public boolean checkValid(@NotNull Printer printer) {
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        LooperPrinter looperPrinter = ((LooperDispatchWatcher)((Object)looperPrinter)).printer;
        return printer == looperPrinter && looperPrinter != null;
    }

    @Override
    public void dispatch(boolean bl, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"log");
        if (bl) {
            long l10;
            this.startTime = l10 = SystemClock.uptimeMillis();
            this.dispatchStart(string, l10);
        } else if (this.startTime != 0L) {
            long l11 = SystemClock.uptimeMillis();
            long l12 = l11 - this.startTime;
            this.startTime = 0L;
            this.dispatchEnd(string, l11, l12);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bJ\u001a\u0010\u0017\u001a\u00020\u00162\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u001a\u0010\u001b\u001a\u00020\u00162\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/tencent/bugly/common/looper/LooperDispatchWatcher$Companion;", "", "()V", "CHECK_TIME_IN_MS", "", "MAX_CHECK_COUNT", "", "TAG", "", "handlerMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Landroid/os/Looper;", "Landroid/os/Handler;", "watcher", "Ljava/lang/ThreadLocal;", "Lcom/tencent/bugly/common/looper/LooperDispatchWatcher;", "fetchHandler", "looper", "createWhenNotExist", "", "fetchWatcher", "forceStop", "", "register", "listener", "Lcom/tencent/bugly/common/looper/ILooperDispatchListener;", "release", "unregister", "bugly-pro_release"})
    public static final class Companion {
        private Companion() {
        }

        private final void release(Looper looper) {
            watcher.remove();
            handlerMap.remove(looper);
            Logger.INSTANCE.i(LooperDispatchWatcher.TAG, "release watcher and handler of looper[" + looper + ']');
        }

        private final Handler fetchHandler(Looper looper, boolean bl) {
            Companion companion = (Handler)handlerMap.get(looper);
            if (companion == null && bl) {
                Handler handler;
                companion = handler;
                handler = new Handler(looper);
                handlerMap.put(looper, companion);
                Logger.INSTANCE.i(LooperDispatchWatcher.TAG, "create handler of looper[" + looper + ']');
            }
            return companion;
        }

        private final LooperDispatchWatcher fetchWatcher(Looper looper, boolean bl) {
            Object object = (LooperDispatchWatcher)watcher.get();
            if (object == null && bl) {
                LooperDispatchWatcher looperDispatchWatcher;
                object = looperDispatchWatcher;
                looperDispatchWatcher = new LooperDispatchWatcher(looper);
                watcher.set(object);
                Logger.INSTANCE.i(LooperDispatchWatcher.TAG, "create watcher of looper[" + looper + ']');
            }
            return object;
        }

        private static final void forceStop$lambda-1(Looper looper) {
            Companion companion = Companion;
            LooperDispatchWatcher looperDispatchWatcher = companion.fetchWatcher(looper, false);
            if (looperDispatchWatcher != null) {
                LooperDispatchWatcher looperDispatchWatcher2 = looperDispatchWatcher;
                looperDispatchWatcher2.clearListeners();
                looperDispatchWatcher2.checkAndStop();
                if (!looperDispatchWatcher2.isStart()) {
                    companion.release(looper);
                }
            }
        }

        private static final void register$lambda-3(Looper object, ILooperDispatchListener iLooperDispatchListener) {
            if ((object = Companion.fetchWatcher((Looper)object, true)) != null) {
                Object object2 = object;
                ((LooperDispatchWatcher)object2).addListener(iLooperDispatchListener);
                ((LooperDispatchWatcher)object2).checkAndStart();
            }
        }

        private static final void unregister$lambda-5(Looper looper, ILooperDispatchListener iLooperDispatchListener) {
            Companion companion = Companion;
            LooperDispatchWatcher looperDispatchWatcher = companion.fetchWatcher(looper, false);
            if (looperDispatchWatcher != null) {
                LooperDispatchWatcher looperDispatchWatcher2 = looperDispatchWatcher;
                looperDispatchWatcher2.removeListener(iLooperDispatchListener);
                looperDispatchWatcher2.checkAndStop();
                if (!looperDispatchWatcher2.isStart()) {
                    companion.release(looper);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final void forceStop(@Nullable Looper looper) {
            if (looper == null) {
                return;
            }
            if ((this = this.fetchHandler(looper, false)) != null) {
                this.post(() -> Companion.forceStop$lambda-1(looper));
            }
        }

        public final void register(@Nullable Looper looper, @Nullable ILooperDispatchListener iLooperDispatchListener) {
            if (iLooperDispatchListener != null && looper != null) {
                if ((this = this.fetchHandler(looper, true)) != null) {
                    this.post(() -> Companion.register$lambda-3(looper, iLooperDispatchListener));
                }
                return;
            }
        }

        public final void unregister(@Nullable Looper looper, @Nullable ILooperDispatchListener iLooperDispatchListener) {
            if (iLooperDispatchListener != null && looper != null) {
                if ((this = this.fetchHandler(looper, false)) != null) {
                    this.post(() -> Companion.unregister$lambda-5(looper, iLooperDispatchListener));
                }
                return;
            }
        }
    }
}

