/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.common.reporter.upload;

import android.text.TextUtils;
import android.util.Base64;
import com.tencent.bugly.common.reporter.upload.EncryptionUtil;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/tencent/bugly/common/reporter/upload/UploadEncrypt;", "", "()V", "Companion", "bugly-pro_release"})
public final class UploadEncrypt {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int IV_LENGTH = 16;

    @JvmStatic
    @NotNull
    public static final Cipher buildCipher(@NotNull String string, int n10) {
        return Companion.buildCipher(string, n10);
    }

    @JvmStatic
    @NotNull
    public static final byte[] doUploadEncrypt(@NotNull byte[] byArray, @NotNull String string) {
        return Companion.doUploadEncrypt(byArray, string);
    }

    @JvmStatic
    @NotNull
    public static final byte[] doResponseDecrypt(@NotNull byte[] byArray, @NotNull String string) {
        return Companion.doResponseDecrypt(byArray, string);
    }

    @JvmStatic
    @NotNull
    public static final String createEncryptKey() {
        return Companion.createEncryptKey();
    }

    @JvmStatic
    @NotNull
    public static final String getEncryptKey(@NotNull String string) {
        return Companion.getEncryptKey(string);
    }

    @JvmStatic
    @NotNull
    public static final ByteArrayOutputStream encryptData(@NotNull byte[] byArray, @NotNull String string) {
        return Companion.encryptData(byArray, string);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0007J\b\u0010\n\u001a\u00020\bH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\bH\u0007J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0007J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/tencent/bugly/common/reporter/upload/UploadEncrypt$Companion;", "", "()V", "IV_LENGTH", "", "buildCipher", "Ljavax/crypto/Cipher;", "key", "", "mode", "createEncryptKey", "doResponseDecrypt", "", "response", "doUploadEncrypt", "request", "encryptData", "Ljava/io/ByteArrayOutputStream;", "data", "encryptKey", "getEncryptKey", "sha256", "input", "bugly-pro_release"})
    public static final class Companion {
        private Companion() {
        }

        private final byte[] sha256(String string) {
            Object object;
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                object = messageDigest.digest(byArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                object = null;
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        @JvmStatic
        @NotNull
        public final Cipher buildCipher(@NotNull String object, int n10) {
            IvParameterSpec ivParameterSpec;
            SecretKeySpec secretKeySpec;
            Intrinsics.checkNotNullParameter((Object)object, (String)"key");
            byte[] byArray = ((Companion)object2).sha256((String)object);
            Object object2 = byArray;
            if (byArray != null) {
                byte[] byArray2 = Arrays.copyOf((byte[])object2, 16);
                object = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(this, newSize)");
            } else {
                object = null;
            }
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeySpec secretKeySpec2 = secretKeySpec;
            secretKeySpec = new SecretKeySpec((byte[])object2, "AES");
            object2 = ivParameterSpec;
            ivParameterSpec = new IvParameterSpec((byte[])object);
            cipher.init(n10, (Key)secretKeySpec2, (AlgorithmParameterSpec)object2);
            Intrinsics.checkNotNullExpressionValue((Object)cipher, (String)"cipher");
            return cipher;
        }

        @JvmStatic
        @NotNull
        public final byte[] doUploadEncrypt(@NotNull byte[] byArray, @NotNull String string) {
            String string2 = string;
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"request");
            Intrinsics.checkNotNullParameter((Object)string2, (String)"key");
            byte[] byArray2 = this.buildCipher(string2, 1).doFinal(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"buildCipher(key, Cipher.\u2026PT_MODE).doFinal(request)");
            return byArray2;
        }

        @JvmStatic
        @NotNull
        public final byte[] doResponseDecrypt(@NotNull byte[] byArray, @NotNull String string) {
            String string2 = string;
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"response");
            Intrinsics.checkNotNullParameter((Object)string2, (String)"key");
            byte[] byArray2 = this.buildCipher(string2, 2).doFinal(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"buildCipher(key, Cipher.\u2026T_MODE).doFinal(response)");
            return byArray2;
        }

        @JvmStatic
        @NotNull
        public final String createEncryptKey() {
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
            if (!TextUtils.isEmpty((CharSequence)string)) {
                return new Regex("-").replace((CharSequence)string, "");
            }
            return "";
        }

        @JvmStatic
        @NotNull
        public final String getEncryptKey(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"encryptKey");
            try {
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                String string2 = Base64.encodeToString((byte[])EncryptionUtil.INSTANCE.encryptData(byArray), (int)2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(encryptedData, Base64.NO_WRAP)");
                return string2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return string;
            }
        }

        @JvmStatic
        @NotNull
        public final ByteArrayOutputStream encryptData(@NotNull byte[] byArray, @NotNull String string) {
            ByteArrayOutputStream byteArrayOutputStream;
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"data");
            Intrinsics.checkNotNullParameter((Object)string, (String)"encryptKey");
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream = new ByteArrayOutputStream();
            CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream2, this.buildCipher(string, 1));
            cipherOutputStream.write(byArray);
            cipherOutputStream.close();
            return byteArrayOutputStream;
        }
    }
}

