/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.common.reporter.upload;

import android.content.Context;
import com.tencent.bugly.common.reporter.IReporter;
import com.tencent.bugly.common.reporter.data.ReportData;
import com.tencent.bugly.common.reporter.upload.FileUploadRunnable;
import com.tencent.bugly.common.reporter.upload.JsonUploadRunnable;
import com.tencent.bugly.common.reporter.upload.UploadCallback;
import com.tencent.bugly.common.utils.ProcessUtil;
import com.tencent.bugly.proguard.b3;
import com.tencent.bugly.proguard.c2;
import com.tencent.bugly.proguard.kh;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0002J\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014J \u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u001a\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J \u0010 \u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u001a\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lcom/tencent/bugly/common/reporter/upload/UploadProxy;", "Lcom/tencent/bugly/common/reporter/IReporter;", "context", "Landroid/content/Context;", "appId", "", "(Landroid/content/Context;Ljava/lang/String;)V", "mAppId", "getMAppId", "()Ljava/lang/String;", "setMAppId", "(Ljava/lang/String;)V", "mContext", "getMContext", "()Landroid/content/Context;", "setMContext", "(Landroid/content/Context;)V", "checkAttrBeforeReport", "", "reportData", "Lcom/tencent/bugly/common/reporter/data/ReportData;", "getContext", "getFileUploadUrl", "reportType", "", "getJsonUploadUrl", "getMD5Params", "reportFile", "url", "callback", "Lcom/tencent/bugly/common/reporter/IReporter$ReportCallback;", "reportForVersion1", "reportJson", "reportNow", "", "bugly-pro_release"})
public final class UploadProxy
implements IReporter {
    @Nullable
    private Context mContext;
    @Nullable
    private String mAppId;

    public UploadProxy(@Nullable Context context, @Nullable String string) {
        this.mContext = context;
        this.mAppId = string;
    }

    private final Context getContext() {
        UploadProxy uploadProxy = uploadProxy.mContext;
        if (uploadProxy != null) {
            return uploadProxy;
        }
        return b3.c();
    }

    private final void checkAttrBeforeReport(ReportData reportData) {
        if (reportData.getParams().has("Attributes")) {
            UploadProxy uploadProxy = uploadProxy.getContext();
            if (!(reportData = reportData.getParams().getJSONObject("Attributes")).has("process_name")) {
                reportData.put("process_name", ProcessUtil.Companion.getCurrentProcessName((Context)uploadProxy));
            }
            if (!reportData.has("is64bit") && uploadProxy != null) {
                reportData.put("is64bit", ProcessUtil.Companion.is64BitProcess((Context)uploadProxy));
            }
        }
    }

    private final void reportForVersion1(ReportData reportData, IReporter.ReportCallback reportCallback) {
        if (reportData.getUploadFilePath().length() == 0) {
            String string = this.getJsonUploadUrl(reportData.getReportType());
            this.reportJson(reportData, string + this.getMD5Params(reportData), reportCallback);
        } else {
            String string = this.getFileUploadUrl(reportData.getReportType());
            this.reportFile(reportData, string + this.getMD5Params(reportData), reportCallback);
        }
    }

    @Nullable
    public final Context getMContext() {
        return this.mContext;
    }

    public final void setMContext(@Nullable Context context) {
        this.mContext = context;
    }

    @Nullable
    public final String getMAppId() {
        return this.mAppId;
    }

    public final void setMAppId(@Nullable String string) {
        this.mAppId = string;
    }

    public final void reportJson(@NotNull ReportData reportData, @NotNull String string, @Nullable IReporter.ReportCallback object) {
        URL uRL;
        UploadCallback uploadCallback;
        Intrinsics.checkNotNullParameter((Object)reportData, (String)"reportData");
        Intrinsics.checkNotNullParameter((Object)string, (String)"url");
        UploadCallback uploadCallback2 = uploadCallback;
        uploadCallback = new UploadCallback(reportData, (IReporter.ReportCallback)object);
        object = uRL;
        uRL = new URL(string);
        new JsonUploadRunnable((URL)object, reportData, uploadCallback2).request();
    }

    public final void reportFile(@NotNull ReportData reportData, @NotNull String string, @Nullable IReporter.ReportCallback object) {
        URL uRL;
        UploadCallback uploadCallback;
        Intrinsics.checkNotNullParameter((Object)reportData, (String)"reportData");
        Intrinsics.checkNotNullParameter((Object)string, (String)"url");
        UploadCallback uploadCallback2 = uploadCallback;
        uploadCallback = new UploadCallback(reportData, (IReporter.ReportCallback)object);
        object = uRL;
        uRL = new URL(string);
        new FileUploadRunnable((URL)object, reportData, uploadCallback2).request();
    }

    @Override
    public boolean reportNow(@NotNull ReportData reportData, @Nullable IReporter.ReportCallback reportCallback) {
        boolean bl;
        block3: {
            ReportData reportData2 = reportData;
            Intrinsics.checkNotNullParameter((Object)reportData2, (String)"reportData");
            bl = false;
            this.checkAttrBeforeReport(reportData2);
            if (reportData.getReportType() != 1) break block3;
            try {
                this.reportForVersion1(reportData, reportCallback);
                bl = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final String getJsonUploadUrl(int n10) {
        String string = "";
        if (n10 == 1) {
            string = kh.a(new StringBuilder().append(c2.b()).append("/v1/"), this.mAppId, "/upload-json");
        }
        return string;
    }

    @NotNull
    public final String getFileUploadUrl(int n10) {
        String string = "";
        if (n10 == 1) {
            string = kh.a(new StringBuilder().append(c2.b()).append("/v1/"), this.mAppId, "/upload-file");
        }
        return string;
    }

    @NotNull
    public final String getMD5Params(@NotNull ReportData reportData) {
        StringBuilder stringBuilder;
        ReportData reportData2 = reportData;
        Intrinsics.checkNotNullParameter((Object)reportData2, (String)"reportData");
        long l10 = System.currentTimeMillis();
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2("?timestamp=");
        return stringBuilder.append(l10).append("&nonce=").append(reportData2.getParams().optString("client_identify", "clientidnull")).toString();
    }
}

