/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.common.utils;

import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J\u0012\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u0011\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0012\u0010\u0015\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/tencent/bugly/common/utils/StringUtil;", "", "()V", "TAG", "", "digits", "", "bytes2HexStr", "bytes", "", "encode", "value", "getMD5", "source", "isNullOrNil", "", "str", "nullAsNil", "parseHex", "", "valueStr", "replaceBlank", "bugly-pro_release"})
public final class StringUtil {
    @NotNull
    public static final StringUtil INSTANCE = new StringUtil();
    @NotNull
    public static final String TAG = "RMonitor_common_StringUtil";
    @NotNull
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private StringUtil() {
    }

    @JvmStatic
    @NotNull
    public static final String nullAsNil(@Nullable String string) {
        if (string == null) {
            string = "";
        }
        return string;
    }

    @JvmStatic
    public static final boolean isNullOrNil(@Nullable String string) {
        boolean bl = string == null || string.length() == 0;
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final String bytes2HexStr(@Nullable byte[] byArray) {
        if (byArray != null && !(byArray.length == 0)) {
            char[] cArray = new char[byArray.length * 2];
            int n10 = byArray.length;
            for (int i10 = 0; i10 < n10; ++i10) {
                byte by = byArray[i10];
                int n11 = i10 * 2;
                int n12 = n11 + 1;
                char[] cArray2 = digits;
                cArray[n12] = cArray2[by & 0xF];
                cArray[n11] = digits[(byte)(by >>> 4) & 0xF];
            }
            return new String(cArray);
        }
        return "";
    }

    @JvmStatic
    public static final long parseHex(@NotNull String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"valueStr");
        try {
            return Long.parseLong(string2, 16);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    @JvmStatic
    @NotNull
    public static final String replaceBlank(@Nullable String string) {
        String string2 = "";
        if (string != null) {
            string2 = Pattern.compile("[\t\r\n]").matcher(string).replaceAll("");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"m.replaceAll(\"\")");
        }
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String getMD5(@Nullable String string) {
        String string2 = "";
        if (string != null) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                messageDigest.update(byArray);
                string2 = string = StringUtil.bytes2HexStr(messageDigest.digest());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noSuchAlgorithmException.printStackTrace();
            }
        }
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String encode(@NotNull String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"value");
        string = URLEncoder.encode(string2, "UTF-8");
        try {
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            URLEncoder\u2026value, \"UTF-8\")\n        }");
        }
        catch (Throwable throwable) {
            string = "";
        }
        return string;
    }
}

