/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rmonitor.common.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Debug;
import android.text.TextUtils;
import com.tencent.bugly.common.utils.ProcessUtil;
import com.tencent.rmonitor.common.logger.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00032\u00020\u0001:\u0002\u0003\u0004B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lcom/tencent/rmonitor/common/util/AppInfo;", "", "()V", "Companion", "PssInfo", "bugly-pro_release"})
public final class AppInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "RMonitor_common_AppInfo";
    private static final long PSS_INFO_VALIDATE_IN_MILLIS = 10000L;
    @NotNull
    private static PssInfo pssInfo = new PssInfo();
    @NotNull
    private static String appName = "";

    @JvmStatic
    @NotNull
    public static final String obtainProcessName(@Nullable Context context) {
        return Companion.obtainProcessName(context);
    }

    @JvmStatic
    @NotNull
    public static final String obtainProcessPackageName(@Nullable Context context) {
        return Companion.obtainProcessPackageName(context);
    }

    @JvmStatic
    @NotNull
    public static final String getAppName(@Nullable Context context) {
        return Companion.getAppName(context);
    }

    @JvmStatic
    public static final long getPssMemory() {
        return Companion.getPssMemory();
    }

    @JvmStatic
    public static final boolean isApkInDebug(@NotNull Context context) {
        return Companion.isApkInDebug(context);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lcom/tencent/rmonitor/common/util/AppInfo$PssInfo;", "", "()V", "pssSize", "", "getPssSize", "()J", "setPssSize", "(J)V", "timeStamp", "getTimeStamp", "setTimeStamp", "bugly-pro_release"})
    public static final class PssInfo {
        private long pssSize;
        private long timeStamp;

        public final long getPssSize() {
            return this.pssSize;
        }

        public final void setPssSize(long l10) {
            this.pssSize = l10;
        }

        public final long getTimeStamp() {
            return this.timeStamp;
        }

        public final void setTimeStamp(long l10) {
            this.timeStamp = l10;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\b\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0012\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0007J\u0012\u0010\u0012\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/tencent/rmonitor/common/util/AppInfo$Companion;", "", "()V", "PSS_INFO_VALIDATE_IN_MILLIS", "", "TAG", "", "appName", "pssInfo", "Lcom/tencent/rmonitor/common/util/AppInfo$PssInfo;", "getAppName", "context", "Landroid/content/Context;", "getPssMemory", "isApkInDebug", "", "obtainProcessName", "ctx", "obtainProcessPackageName", "bugly-pro_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        @JvmStatic
        @NotNull
        public final String obtainProcessName(@Nullable Context context) {
            return ProcessUtil.Companion.getCurrentProcessName(context);
        }

        @JvmStatic
        @NotNull
        public final String obtainProcessPackageName(@Nullable Context context) {
            Object object;
            if (context != null) {
                object = context.getPackageName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n                ctx.packageName\n            }");
            } else {
                object = "";
            }
            return object;
        }

        @JvmStatic
        @NotNull
        public final String getAppName(@Nullable Context context) {
            if (!TextUtils.isEmpty((CharSequence)appName)) {
                return appName;
            }
            Object object = null;
            if (context != null) {
                Context context2 = context;
                Context context3 = context2;
                context = context2.getApplicationInfo();
                try {
                    object = context3.getPackageManager().getApplicationLabel((ApplicationInfo)context);
                }
                catch (Throwable throwable) {
                    Logger.INSTANCE.exception(AppInfo.TAG, throwable);
                }
            }
            if (object == null) {
                object = "";
            }
            appName = String.valueOf(object);
            Logger.INSTANCE.d(AppInfo.TAG, "getAppName, name: " + appName);
            return appName;
        }

        @JvmStatic
        public final long getPssMemory() {
            long l10;
            block5: {
                try {
                    l10 = System.currentTimeMillis();
                }
                catch (Exception exception) {
                    Logger.INSTANCE.exception(AppInfo.TAG, exception);
                    return 0L;
                }
                if (l10 - pssInfo.getTimeStamp() >= 10000L) break block5;
                return pssInfo.getPssSize() * (long)1024;
            }
            pssInfo.setTimeStamp(l10);
            pssInfo.setPssSize(Debug.getPss());
            return pssInfo.getPssSize() * (long)1024;
        }

        @JvmStatic
        public final boolean isApkInDebug(@NotNull Context context) {
            boolean bl;
            Context context2 = context;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            try {
                bl = (context2.getApplicationInfo().flags & 2) != 0;
            }
            catch (Throwable throwable) {
                Logger.INSTANCE.exception(AppInfo.TAG, throwable);
                bl = false;
            }
            return bl;
        }
    }
}

