/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rmonitor.common.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.text.TextUtils;
import com.tencent.rmonitor.base.meta.BaseInfo;
import com.tencent.rmonitor.common.logger.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0010\u0010\u0014\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0010\u0010\u0015\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0012\u0010\u0019\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0004J\u000e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/tencent/rmonitor/common/util/AppVersionHelper;", "", "()V", "META_BUGLY_APP_VERSION", "", "META_RDM_UUID", "TAG", "appVersion", "appVersionFromMeta", "buildNo", "buildNoFromMeta", "hasParseMetadata", "", "hasParsePackageInfo", "manifestVersionCode", "manifestVersionName", "userSetAppVersion", "apkInDebug", "context", "Landroid/content/Context;", "checkAndGetAppVersion", "checkAndGetUuid", "checkAppVersion", "", "parseAppVersionFromPackageInfo", "parseMetaData", "setProductVersion", "productVersion", "setRdmUuid", "rdmUuid", "bugly-pro_release"})
public final class AppVersionHelper {
    @NotNull
    public static final AppVersionHelper INSTANCE = new AppVersionHelper();
    @NotNull
    private static final String TAG = "RMonitor_AppVersionHelper";
    @NotNull
    public static final String META_BUGLY_APP_VERSION = "BUGLY_APP_VERSION";
    @NotNull
    public static final String META_RDM_UUID = "com.tencent.rdm.uuid";
    @NotNull
    private static String appVersion = "";
    private static boolean userSetAppVersion;
    @NotNull
    private static String buildNo;
    @NotNull
    private static String manifestVersionName;
    @NotNull
    private static String manifestVersionCode;
    private static boolean hasParsePackageInfo;
    @NotNull
    private static String appVersionFromMeta;
    @NotNull
    private static String buildNoFromMeta;
    private static boolean hasParseMetadata;

    private AppVersionHelper() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void parseAppVersionFromPackageInfo(Context object) {
        if (object == null) {
            Logger.INSTANCE.i(TAG, "parseAppVersionFromPackageInfo for context is null");
            return;
        }
        if (hasParsePackageInfo) {
            return;
        }
        hasParsePackageInfo = true;
        try {
            AppVersionHelper appVersionHelper = object.getPackageManager().getPackageInfo(object.getPackageName(), 0);
            if (appVersionHelper != null) {
                void var1_5;
                String string = ((PackageInfo)appVersionHelper).versionName;
                if (string == null) {
                    String string2 = "";
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.versionName ?: \"\"");
                }
                manifestVersionName = var1_5;
                manifestVersionCode = String.valueOf(((PackageInfo)appVersionHelper).versionCode);
            }
        }
        catch (Throwable throwable) {
            Logger.INSTANCE.exception(TAG, throwable);
        }
        Logger.INSTANCE.i(TAG, "parseAppVersionFromPackageInfo, manifestVersionName: " + manifestVersionName + ", manifestVersionCode: " + manifestVersionCode);
    }

    private final void parseMetaData(Context object) {
        block13: {
            block17: {
                Object object2;
                block16: {
                    block15: {
                        block14: {
                            if (object == null) {
                                Logger.INSTANCE.i(TAG, "parseMetaData fail for context is null");
                                return;
                            }
                            if (hasParseMetadata) {
                                return;
                            }
                            hasParseMetadata = true;
                            object2 = object.getPackageManager().getApplicationInfo(object.getPackageName(), 128);
                            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"manager.getApplicationIn\u2026ageManager.GET_META_DATA)");
                            object = ((ApplicationInfo)object2).metaData;
                            if (object == null) break block13;
                            object = object.get(META_BUGLY_APP_VERSION);
                            object2 = ((ApplicationInfo)object2).metaData.get(META_RDM_UUID);
                            if (object == null) break block14;
                            object = object.toString();
                            if (object != null) break block15;
                        }
                        object = "";
                    }
                    appVersionFromMeta = object;
                    if (object2 == null) break block16;
                    object2 = object2.toString();
                    if (object2 != null) break block17;
                }
                object2 = "";
            }
            try {
                buildNoFromMeta = object2;
            }
            catch (Throwable throwable) {
                Logger.INSTANCE.exception(TAG, throwable);
            }
        }
        Logger.INSTANCE.i(TAG, "parseMetaData, appVersionFromMeta: " + appVersionFromMeta + ", buildNoFromMeta: " + buildNoFromMeta);
    }

    private final void checkAppVersion() {
        if (userSetAppVersion) {
            Logger.INSTANCE.i(TAG, "checkAppVersion for userSetVersion is true");
            return;
        }
        Object object = appVersion;
        if (object != null && !(object.length() == 0)) {
            int n10 = 0;
            char[] cArray = ((String)object).toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
            int n11 = cArray.length;
            for (int i10 = 0; i10 < n11; ++i10) {
                if (cArray[i10] != '.') continue;
                ++n10;
            }
            if (n10 < 3) {
                object = (String)object + '.' + manifestVersionCode;
                Logger.INSTANCE.i(TAG, "checkAppVersion, old:" + appVersion + ", new: " + (String)object);
                appVersion = object;
            }
            return;
        }
        Logger.INSTANCE.i(TAG, "checkAppVersion for versionName is null or empty");
    }

    static {
        buildNo = "";
        manifestVersionName = "";
        manifestVersionCode = "";
        appVersionFromMeta = "";
        buildNoFromMeta = "";
    }

    public final void setProductVersion(@NotNull String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"productVersion");
        Logger.INSTANCE.i(TAG, "setProductVersion, old:" + appVersion + ", new: " + string);
        if (string2.length() == 0) {
            appVersion = "";
            BaseInfo.userMeta.appVersion = "";
            userSetAppVersion = false;
            hasParseMetadata = false;
            hasParsePackageInfo = false;
        } else {
            appVersion = string;
            BaseInfo.userMeta.appVersion = string;
            userSetAppVersion = true;
        }
    }

    public final void setRdmUuid(@NotNull String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"rdmUuid");
        Logger.INSTANCE.i(TAG, "setRdmUuid, old:" + buildNo + ", new: " + string);
        if (string2.length() == 0) {
            buildNo = "";
            BaseInfo.userMeta.buildNumber = "";
            hasParseMetadata = false;
        } else {
            buildNo = string;
            BaseInfo.userMeta.buildNumber = string;
        }
    }

    @NotNull
    public final String checkAndGetUuid(@Nullable Context context) {
        if (TextUtils.isEmpty((CharSequence)buildNo)) {
            this.parseMetaData(context);
            if (!TextUtils.isEmpty((CharSequence)buildNoFromMeta)) {
                buildNo = buildNoFromMeta;
            }
        }
        return buildNo;
    }

    @NotNull
    public final String checkAndGetAppVersion(@Nullable Context context) {
        if (TextUtils.isEmpty((CharSequence)appVersion)) {
            this.parseAppVersionFromPackageInfo(context);
            if (!TextUtils.isEmpty((CharSequence)manifestVersionName)) {
                appVersion = manifestVersionName;
            }
            this.parseMetaData(context);
            if (!TextUtils.isEmpty((CharSequence)appVersionFromMeta)) {
                appVersion = appVersionFromMeta;
            }
        }
        this.checkAppVersion();
        return appVersion;
    }

    public final boolean apkInDebug(@Nullable Context context) {
        boolean bl;
        block4: {
            if (context == null) {
                return false;
            }
            try {
                AppVersionHelper appVersionHelper = context.getApplicationInfo();
                if (appVersionHelper == null) break block4;
            }
            catch (Throwable throwable) {}
            if ((((ApplicationInfo)appVersionHelper).flags & 2) == 0) break block4;
            bl = true;
        }
        bl = false;
        return bl;
    }
}

