/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rmonitor.fd.utils;

import com.tencent.bugly.proguard.wa;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import shark.FilteringLeakingObjectFinder;
import shark.HeapAnalysis;
import shark.HeapAnalysisFailure;
import shark.HeapAnalysisSuccess;
import shark.HeapAnalyzer;
import shark.HeapGraph;
import shark.HeapObject;
import shark.Leak;
import shark.LeakTrace;
import shark.LeakingObjectFinder;
import shark.ObjectReporter;
import shark.OnAnalysisProgressListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/tencent/rmonitor/fd/utils/SharkAnalysisUtil;", "Lshark/OnAnalysisProgressListener;", "()V", "CLASS_FINALIZER_REFERENCE", "", "OBJECT_ID_PREFIX", "TAG", "findPathsFromGcRoots", "", "", "graph", "Lshark/HeapGraph;", "objectIds", "", "getGcPathFeature", "trace", "Lshark/LeakTrace;", "getObjectIdFromLeakTrace", "onAnalysisProgress", "", "step", "Lshark/OnAnalysisProgressListener$Step;", "processAnalysisResult", "heapAnalysis", "Lshark/HeapAnalysis;", "bugly-pro_release"})
public final class SharkAnalysisUtil
implements OnAnalysisProgressListener {
    @NotNull
    public static final SharkAnalysisUtil INSTANCE = new SharkAnalysisUtil();
    @NotNull
    private static final String TAG = "SharkAnalysisUtil";
    @NotNull
    private static final String OBJECT_ID_PREFIX = "ObjectId=";
    @NotNull
    private static final String CLASS_FINALIZER_REFERENCE = "java.lang.ref.FinalizerReference";

    private SharkAnalysisUtil() {
    }

    @JvmStatic
    @NotNull
    public static final Map<Long, String> findPathsFromGcRoots(@NotNull HeapGraph heapGraph, @NotNull Set<Long> filteringLeakingObjectFinder) {
        File file;
        Object object;
        FilteringLeakingObjectFinder filteringLeakingObjectFinder2;
        FilteringLeakingObjectFinder.LeakingObjectFilter leakingObjectFilter;
        Intrinsics.checkNotNullParameter((Object)heapGraph, (String)"graph");
        Intrinsics.checkNotNullParameter(filteringLeakingObjectFinder, (String)"objectIds");
        Object object2 = leakingObjectFilter;
        leakingObjectFilter = new FilteringLeakingObjectFinder.LeakingObjectFilter((Set<Long>)filteringLeakingObjectFinder){
            final /* synthetic */ Set<Long> $objectIds;
            {
                this.$objectIds = set;
            }

            public boolean isLeakingObject(@NotNull HeapObject heapObject) {
                Intrinsics.checkNotNullParameter((Object)heapObject, (String)"heapObject");
                return this.$objectIds.contains(heapObject.getObjectId());
            }
        };
        filteringLeakingObjectFinder = filteringLeakingObjectFinder2;
        filteringLeakingObjectFinder2 = new FilteringLeakingObjectFinder(CollectionsKt.listOf((Object)object2));
        object2 = SharkAnalysisUtil::findPathsFromGcRoots$lambda-0;
        SharkAnalysisUtil sharkAnalysisUtil = INSTANCE;
        HeapAnalyzer heapAnalyzer = object;
        FilteringLeakingObjectFinder.LeakingObjectFilter leakingObjectFilter2 = object2;
        object = new HeapAnalyzer((OnAnalysisProgressListener)sharkAnalysisUtil);
        object2 = file;
        file = new File("");
        object = CollectionsKt.listOf((Object)leakingObjectFilter2);
        return sharkAnalysisUtil.processAnalysisResult(HeapAnalyzer.analyze$default((HeapAnalyzer)heapAnalyzer, (File)object2, (HeapGraph)heapGraph, (LeakingObjectFinder)filteringLeakingObjectFinder, null, (boolean)false, (List)object, null, (int)88, null));
    }

    private final Map<Long, String> processAnalysisResult(HeapAnalysis object) {
        HashMap<Long, String> hashMap;
        HashMap<Long, String> hashMap2 = hashMap;
        hashMap = new HashMap<Long, String>();
        if (object instanceof HeapAnalysisSuccess) {
            object = (HeapAnalysisSuccess)object;
            object = CollectionsKt.plus((Collection)object.getApplicationLeaks(), (Iterable)object.getLibraryLeaks()).iterator();
            while (object.hasNext()) {
                long l10;
                LeakTrace leakTrace = (LeakTrace)CollectionsKt.firstOrNull((List)((Leak)object.next()).getLeakTraces());
                if (leakTrace == null || (l10 = this.getObjectIdFromLeakTrace(leakTrace)) == 0L) continue;
                Long l11 = l10;
                hashMap2.put(l11, this.getGcPathFeature(leakTrace));
            }
        } else if (object instanceof HeapAnalysisFailure) {
            wa.b(TAG, "findPathsFromGcRoots failed: " + object);
        }
        return hashMap2;
    }

    private final String getGcPathFeature(LeakTrace leakTrace) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(leakTrace.getLeakingObject().getClassName() + " -> \n");
        boolean bl = false;
        for (Object object : CollectionsKt.reversed((Iterable)leakTrace.getReferencePath())) {
            String string = object.getOriginObject().getClassName();
            boolean bl2 = Intrinsics.areEqual((Object)string, (Object)CLASS_FINALIZER_REFERENCE);
            object = string + " -> " + object.getReferenceName() + '\n';
            if (bl2 && !bl) {
                bl = true;
                stringBuilder2.append((String)object);
                continue;
            }
            if (bl2) continue;
            stringBuilder2.append((String)object);
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append("GcRoot: " + leakTrace.getGcRootType());
        String string = stringBuilder3.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    private final long getObjectIdFromLeakTrace(LeakTrace object2) {
        block1: {
            for (Object object2 : object2.getLeakingObject().getLabels()) {
                if (!StringsKt.startsWith$default((String)((String)object2), (String)OBJECT_ID_PREFIX, (boolean)false, (int)2, null)) continue;
                break block1;
            }
            object2 = null;
        }
        Object object3 = (String)object2;
        return object3 != null && (object3 = StringsKt.substringAfter$default((String)object3, (String)OBJECT_ID_PREFIX, null, (int)2, null)) != null && (object3 = StringsKt.toLongOrNull((String)object3)) != null ? (Long)object3 : 0L;
    }

    private static final void findPathsFromGcRoots$lambda-0(ObjectReporter objectReporter) {
        ObjectReporter objectReporter2 = objectReporter;
        Intrinsics.checkNotNullParameter((Object)objectReporter2, (String)"it");
        objectReporter2.getLabels().add(OBJECT_ID_PREFIX + objectReporter.getHeapObject().getObjectId());
    }

    public void onAnalysisProgress(@NotNull OnAnalysisProgressListener.Step step) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
    }
}

