/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rmonitor.looper;

import android.content.Context;
import com.tencent.bugly.common.meta.UserMeta;
import com.tencent.bugly.common.reporter.IReporter;
import com.tencent.bugly.common.reporter.data.ReportData;
import com.tencent.bugly.common.reporter.data.ReportStrategy;
import com.tencent.bugly.common.thread.ThreadManager;
import com.tencent.bugly.proguard.bb;
import com.tencent.bugly.proguard.cf;
import com.tencent.bugly.proguard.d7;
import com.tencent.bugly.proguard.e7;
import com.tencent.bugly.proguard.ef;
import com.tencent.bugly.proguard.q0;
import com.tencent.bugly.proguard.v3;
import com.tencent.bugly.proguard.yd;
import com.tencent.rmonitor.base.db.DBDataStatus;
import com.tencent.rmonitor.base.db.DBHandler;
import com.tencent.rmonitor.base.db.DBHelper;
import com.tencent.rmonitor.base.db.table.ReportDataTable;
import com.tencent.rmonitor.base.meta.BaseInfo;
import com.tencent.rmonitor.base.meta.LooperMeta;
import com.tencent.rmonitor.base.plugin.listener.ILooperListener;
import com.tencent.rmonitor.base.plugin.listener.ListenerManager;
import com.tencent.rmonitor.base.plugin.monitor.PluginController;
import com.tencent.rmonitor.base.reporter.ReporterMachine;
import com.tencent.rmonitor.common.logger.Logger;
import com.tencent.rmonitor.common.util.AppInfo;
import com.tencent.rmonitor.common.util.FileUtil;
import com.tencent.rmonitor.looper.LooperConfig;
import com.tencent.rmonitor.looper.MonitorInfo;
import com.tencent.rmonitor.sla.AttaEvent;
import com.tencent.rmonitor.sla.AttaEventReporter;
import java.io.File;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\rj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/tencent/rmonitor/looper/LooperReport;", "", "()V", "COLLECT_STACK_MSG_MAX_DELAY", "", "HAS_FULL_STACK", "", "LONG_LAG_LIMIT", "MAX_LONG_LAG_MAP_SIZE", "", "NO_FULL_STACK", "TAG", "longLagMap", "Ljava/util/HashMap;", "Lcom/tencent/bugly/common/reporter/data/ReportData;", "Lkotlin/collections/HashMap;", "buildReportData", "monitorInfo", "Lcom/tencent/rmonitor/looper/MonitorInfo;", "cancelCachedReportData", "", "reportData", "checkValid", "", "dealLongLag", "gotoReport", "gotoReportInner", "realReport", "reportSLA", "bugly-pro_release"})
public final class LooperReport {
    @NotNull
    public static final LooperReport INSTANCE = new LooperReport();
    @NotNull
    private static final String TAG = "RMonitor_lag_report";
    private static final long COLLECT_STACK_MSG_MAX_DELAY = 20L;
    @NotNull
    private static final String NO_FULL_STACK = "0";
    @NotNull
    private static final String HAS_FULL_STACK = "1";
    private static final long LONG_LAG_LIMIT = 5000L;
    private static final int MAX_LONG_LAG_MAP_SIZE = 20;
    @NotNull
    private static final HashMap<Long, ReportData> longLagMap = new HashMap(20);

    private LooperReport() {
    }

    private final void reportSLA(MonitorInfo monitorInfo) {
        AttaEvent attaEvent;
        String string = "RMLooperStackCollectStack";
        if (!q0.a.a().a(string)) {
            return;
        }
        AttaEvent attaEvent2 = attaEvent;
        attaEvent2(string);
        double d10 = monitorInfo.getAvgCollectStackMsgCost();
        attaEvent2.setParam0(String.valueOf(d10));
        long l10 = monitorInfo.getAvgCollectStackMsgDelay();
        attaEvent2.setParam1(String.valueOf(l10));
        attaEvent2.setParam2(String.valueOf(monitorInfo.getCollectStackMsgCount()));
        attaEvent2.setParam3(String.valueOf(monitorInfo.getDuration()));
        attaEvent.setEventCost((int)monitorInfo.getDuration());
        if (monitorInfo.getFullStack() == null) {
            attaEvent2.setParam4(NO_FULL_STACK);
        } else {
            attaEvent2.setParam4(HAS_FULL_STACK);
        }
        AttaEvent attaEvent3 = attaEvent2;
        String string2 = yd.k().i();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getInstance().osVersion");
        attaEvent3.setParam5(string2);
        yd yd2 = yd.o;
        String string3 = yd2.c();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getInstance().manufacture");
        attaEvent2.setParam6(string3);
        String string4 = yd2.e();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getInstance().model");
        attaEvent3.setParam7(string4);
        attaEvent2.setParam8(String.valueOf(monitorInfo.getQuickTraceFlag()));
        int n10 = d10 / (double)1000 + (double)l10 > 20.0 ? 0 : 1;
        attaEvent2.setEventResult(n10);
        AttaEventReporter.Companion.getInstance().addEvent(attaEvent2);
    }

    private final void dealLongLag(MonitorInfo monitorInfo, ReportData reportData) {
        HashMap<Long, ReportData> hashMap;
        if (monitorInfo.isDetectedLongLag()) {
            hashMap = longLagMap;
            if (hashMap.size() >= 20) {
                hashMap.clear();
            }
            hashMap.put(monitorInfo.getLastStackRequestTime(), reportData);
            reportData.getReportStrategy().setUploadStrategy(ReportStrategy.UploadStrategy.UPLOAD_NEXT_LAUNCH);
            if (Logger.verbos) {
                hashMap = reportData.getParams().optString("client_identify");
                Logger.INSTANCE.v(TAG, "record unfinished long lag clientIdentify, duration: " + monitorInfo.getDuration() + ", requestTime: " + monitorInfo.getLastStackRequestTime() + ", clientIdentify: " + (String)((Object)hashMap));
            }
        } else if (monitorInfo.getDuration() >= 5000L) {
            ReportData reportData2 = longLagMap.remove(monitorInfo.getLastStackRequestTime());
            if (reportData2 != null) {
                super.cancelCachedReportData(reportData2);
            }
            if (Logger.verbos) {
                hashMap = reportData.getParams().optString("client_identify");
                Logger.INSTANCE.v(TAG, "deal finished long lag clientIdentify, duration: " + monitorInfo.getDuration() + ", requestTime: " + monitorInfo.getLastStackRequestTime() + ", clientIdentify: " + (String)((Object)hashMap));
            }
        }
    }

    private final void cancelCachedReportData(ReportData reportData) {
        long l10 = reportData.getDbId() == 0 ? 1000L : 200L;
        ThreadManager.Companion.runInMonitorThread(() -> LooperReport.cancelCachedReportData$lambda-0(reportData), l10);
    }

    private final boolean gotoReportInner(MonitorInfo monitorInfo) {
        boolean bl;
        ReportData reportData = this.buildReportData(monitorInfo);
        this.dealLongLag(monitorInfo, reportData);
        if (this.checkValid(monitorInfo)) {
            bl = this.realReport(reportData, monitorInfo);
        } else {
            new ef().a(reportData, DBDataStatus.SENT);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean realReport(ReportData reportData, MonitorInfo monitorInfo) {
        LooperMeta looperMeta;
        boolean bl = false;
        LooperMeta looperMeta2 = looperMeta;
        try {
            MonitorInfo monitorInfo2 = monitorInfo;
            Object object = reportData.getParams();
            String string = monitorInfo2.getThreadId();
            String string2 = monitorInfo2.getThreadName();
            looperMeta = new LooperMeta((JSONObject)object, string, string2);
            object = ListenerManager.looperListener.getListenerList().iterator();
            while (object.hasNext()) {
                ((ILooperListener)object.next()).onBeforeReport(looperMeta2);
            }
            if (PluginController.INSTANCE.whetherPluginReportSampling("looper_stack")) {
                IReporter.DefaultImpls.reportNow$default(ReporterMachine.INSTANCE, reportData, null, 2, null);
                return true;
            }
        }
        catch (Throwable throwable) {
            Logger.INSTANCE.w(TAG, "looper data may be error, " + throwable.getMessage());
            return bl;
        }
        {
            if (!Logger.verbos) return true;
            {
                Logger.INSTANCE.v(TAG, "miss report for sampling. [ThreadName: " + monitorInfo.getThreadName() + ", CostInMs: " + monitorInfo.getDuration() + ", Scene: " + monitorInfo.getScene() + ", Foreground: " + monitorInfo.isAppInForeground() + ']');
            }
        }
        return true;
    }

    private final ReportData buildReportData(MonitorInfo object) {
        ReportData reportData;
        Object object2 = cf.a();
        object2.put("process_name", (Object)AppInfo.Companion.obtainProcessName((Context)BaseInfo.app));
        long l10 = ((MonitorInfo)object).getDuration();
        object2.put("time_cost", l10);
        object2.put("stage", (Object)((MonitorInfo)object).getScene());
        l10 = ((MonitorInfo)object).getLagParam().d;
        object2.put("stack_interval", l10);
        l10 = ((MonitorInfo)object).getLastStackRequestTime();
        object2.put("start_time", l10);
        object2.put("monitored_thread_name", (Object)((MonitorInfo)object).getThreadName());
        object2.put("app_in_foreground", ((MonitorInfo)object).isAppInForeground());
        object2.put("detect_strategy", (Object)((MonitorInfo)object).getLagParam().f);
        String string = ((MonitorInfo)object).getScene();
        v3.a.a().a(false, "looper_stack", string, (JSONObject)object2);
        v3.a.a().a((JSONObject)object2);
        string = null;
        if (object2.has("biz_extend_info")) {
            string = object2.getJSONObject("biz_extend_info");
        }
        if (string == null) {
            JSONObject jSONObject;
            string = jSONObject;
            jSONObject = new JSONObject();
        }
        string.put("detect_strategy", (Object)((MonitorInfo)object).getLagParam().f);
        object2.put("biz_extend_info", (Object)string);
        MonitorInfo monitorInfo = object;
        long l11 = monitorInfo.getLastStackRequestTime() - 1000L;
        long l12 = monitorInfo.getLastStackRequestTime();
        Object object3 = d7.d.a.a(l11, ((MonitorInfo)object).getDuration() + l12);
        if (object3 != null) {
            object2.put("gc_info", object3);
        }
        object3 = BaseInfo.userMeta;
        Object object4 = cf.a((Context)BaseInfo.app, "looper", "looper_stack", (UserMeta)object3);
        MonitorInfo monitorInfo2 = object;
        object4.put("Attributes", object2);
        l12 = monitorInfo2.getLastStackRequestTime();
        l12 = monitorInfo2.getDuration() + l12;
        long l13 = l12 / 1000L;
        object4.put("event_time_in_ms", l12);
        object4.put("event_time", l13);
        object2 = reportData;
        object3 = ((UserMeta)object3).uin;
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"params");
        new ReportData((String)object3, 1, "Looper single", (JSONObject)object4).setShouldRecordLinkData(true);
        if (((MonitorInfo)object).checkUseFileToTransStacks()) {
            JSONObject jSONObject;
            File file;
            JSONObject jSONObject2 = object4;
            object3 = FileUtil.Companion;
            object4 = ((FileUtil.Companion)object3).makeTempFileName("rmonitor_trace", "json");
            File file2 = file;
            file2(((FileUtil.Companion)object3).getTempPath(), (String)object4);
            object = String.valueOf(((MonitorInfo)object).getFullStack());
            ((FileUtil.Companion)object3).writeFile(file2.getAbsolutePath(), (String)object, false);
            String string2 = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.absolutePath");
            ((ReportData)object2).addFile(string2, true, true);
            object = jSONObject;
            new JSONObject().put("file_stacks", object4);
            jSONObject2.put("Body", object);
        } else {
            object4.put("Body", (Object)((MonitorInfo)object).getFullStack());
        }
        return object2;
    }

    private final boolean checkValid(MonitorInfo object) {
        Object object2 = LooperConfig.INSTANCE.getPluginConfig("looper_stack");
        object2 = object2 instanceof bb ? (bb)object2 : null;
        if (object2 != null && ((bb)object2).e()) {
            long l10 = ((MonitorInfo)object).getDuration();
            if (l10 > ((bb)object2).g()) {
                StringBuilder stringBuilder;
                String[] stringArray = new String[2];
                stringArray[0] = TAG;
                object = stringBuilder;
                ((StringBuilder)object)("not valid sample for ");
                stringArray[1] = stringBuilder.append(l10).append(" exceed ").append(((bb)object2).g()).toString();
                Logger.INSTANCE.i(stringArray);
                return false;
            }
            int n10 = ((MonitorInfo)object).getCollectStackMsgCount();
            Object object3 = object2;
            long l11 = ((MonitorInfo)object).getLagParam().d;
            long l12 = n10;
            long l13 = l10 - l11 * l12;
            l12 = ((bb)object3).f() * l12 + l11;
            boolean bl = n10 >= ((bb)object3).i() || l13 <= l12;
            if (!bl) {
                StringBuilder stringBuilder;
                String[] stringArray = new String[2];
                stringArray[0] = TAG;
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2("not valid sample for {totalCost: ");
                stringArray[1] = stringBuilder.append(l10).append(", sliceCount: ").append(n10).append(", stackInterval: ").append(l11).append(", delay: ").append(l13).append(", delayLimit: ").append(l12).append('}').toString();
                Logger.INSTANCE.i(stringArray);
            }
            return bl;
        }
        return true;
    }

    private static final void cancelCachedReportData$lambda-0(ReportData object) {
        Object object2;
        ReportData reportData = object;
        Intrinsics.checkNotNullParameter((Object)reportData, (String)"$reportData");
        if (reportData.getDbId() > 0 && (object2 = BaseInfo.dbHelper) != null && (object2 = ((DBHelper)((Object)object2)).getDbHandler()) != null) {
            ((DBHandler)object2).updateStatus(ReportDataTable.Companion.getTableName(), ((ReportData)object).getDbId(), DBDataStatus.SENT.getValue());
        }
        if (Logger.debug) {
            object = ((ReportData)object).getParams().optString("client_identify");
            Logger.INSTANCE.d(TAG, e7.a("deal cached report data, clientIdentify: ", (String)object));
        }
    }

    public final boolean gotoReport(@NotNull MonitorInfo monitorInfo) {
        MonitorInfo monitorInfo2 = monitorInfo;
        Intrinsics.checkNotNullParameter((Object)monitorInfo2, (String)"monitorInfo");
        boolean bl = false;
        if (monitorInfo2.getFullStack() != null) {
            bl = this.gotoReportInner(monitorInfo);
        }
        this.reportSLA(monitorInfo);
        return bl;
    }
}

