/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rmonitor.looper.meta;

import android.os.Looper;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.tencent.bugly.common.utils.RecyclablePool;
import com.tencent.bugly.proguard.ag;

@Keep
class PoolProvider {
    private final Class<? extends RecyclablePool.Recyclable> clz;
    private final int capacity;
    private volatile RecyclablePool mainThreadPool = null;
    private volatile RecyclablePool otherThreadPool = null;

    public PoolProvider(Class<? extends RecyclablePool.Recyclable> clazz, int n10) {
        this.clz = clazz;
        this.capacity = n10;
    }

    private boolean isMonitoredThreadMainThread() {
        Thread thread = Looper.getMainLooper().getThread();
        Thread thread2 = Thread.currentThread();
        if (thread2 == thread) {
            return true;
        }
        return ag.a(thread).getThread() == thread2;
    }

    private RecyclablePool getMainThreadPool() {
        if (this.mainThreadPool == null) {
            RecyclablePool recyclablePool;
            RecyclablePool recyclablePool2 = recyclablePool;
            PoolProvider poolProvider = this;
            Class<? extends RecyclablePool.Recyclable> clazz = poolProvider.clz;
            recyclablePool = new RecyclablePool(clazz, poolProvider.capacity);
            this.mainThreadPool = recyclablePool2;
        }
        return this.mainThreadPool;
    }

    private RecyclablePool getOtherThreadPool() {
        if (this.otherThreadPool == null) {
            RecyclablePool recyclablePool;
            RecyclablePool recyclablePool2 = recyclablePool;
            PoolProvider poolProvider = this;
            Class<? extends RecyclablePool.Recyclable> clazz = poolProvider.clz;
            recyclablePool = new RecyclablePool(clazz, poolProvider.capacity);
            this.otherThreadPool = recyclablePool2;
        }
        return this.otherThreadPool;
    }

    @NonNull
    public RecyclablePool getPool() {
        return this.isMonitoredThreadMainThread() ? this.getMainThreadPool() : this.getOtherThreadPool();
    }
}

